/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.Comparables;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class KeyMatchedMap<K extends Comparable<K>, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> delegate;
    private final Set<K> keys;

    protected KeyMatchedMap(Map<K, V> delegate, final boolean matchFirst) {
        this.delegate = delegate;
        this.keys = Collections.synchronizedNavigableSet(new TreeSet(new Comparator<K>(){

            @Override
            public int compare(K left, K right) {
                return matchFirst ? Comparables.compareTo(left, right) : Comparables.compareTo(right, left);
            }
        }));
    }

    @Override
    public boolean containsKey(Object inputKey) {
        K key = this.matches(inputKey);
        return key != null ? this.delegate.containsKey(key) : false;
    }

    @Override
    public V get(Object inputKey) {
        K key = this.matches(inputKey);
        return key != null ? (V)this.delegate.get(key) : null;
    }

    @Override
    public V put(K key, V value) {
        Assert.isNull(key, "Non null key", new Object[0]);
        this.keys.add(key);
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object inputKey) {
        K key = this.matches(inputKey);
        return key != null ? (V)this.delegate.remove(key) : null;
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.delegate.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    private K matches(Object inputKey) {
        for (Comparable key : this.keys) {
            if (!this.match(key, inputKey)) continue;
            return (K)key;
        }
        return null;
    }

    protected abstract boolean match(K var1, Object var2);
}

