/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.collection.BoundedMap;
import com.github.paganini2008.devtools.collection.EvictionListener;
import com.github.paganini2008.devtools.collection.LruMapSupplier;
import com.github.paganini2008.devtools.collection.MapUtils;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class LruMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable,
BoundedMap<K, V> {
    private static final long serialVersionUID = -1958272189245104075L;
    private final Map<K, V> delegate;
    private final Map<K, Object> keys;
    private final int maxSize;

    public LruMap() {
        this(128);
    }

    public LruMap(int maxSize) {
        this(false, maxSize);
    }

    public LruMap(boolean sorted, int maxSize) {
        this(sorted, maxSize, (int size, EvictionListener<K, Object> listener) -> Collections.synchronizedMap(MapUtils.newLruMap(16, size, listener)));
    }

    public LruMap(boolean sorted, int maxSize, LruMapSupplier<K, Object> supplier) {
        this(sorted ? new ConcurrentSkipListMap() : new ConcurrentHashMap(), maxSize, supplier);
    }

    public LruMap(Map<K, V> delegate, int maxSize) {
        this(delegate, maxSize, (int size, EvictionListener<K, Object> listener) -> Collections.synchronizedMap(MapUtils.newLruMap(16, size, listener)));
    }

    public LruMap(Map<K, V> delegate, int maxSize, LruMapSupplier<K, Object> supplier) {
        this.delegate = delegate;
        this.maxSize = maxSize;
        this.keys = supplier.get(maxSize, (key, value) -> {
            Object eldestValue = delegate.remove(key);
            this.onEviction(key, eldestValue);
        });
    }

    @Override
    public V get(Object key) {
        this.keys.get(key);
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.keys.put(key, key);
        return this.delegate.put(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.keys.putIfAbsent(key, key);
        return this.delegate.putIfAbsent(key, value);
    }

    @Override
    public V remove(Object key) {
        this.keys.remove(key);
        return this.delegate.remove(key);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.delegate.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        this.keys.get(key);
        return this.delegate.containsKey(key);
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    protected Map<K, V> getDelegate() {
        return this.delegate;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

