/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.ObjectUtils;
import com.github.paganini2008.devtools.collection.BoundedCollection;
import com.github.paganini2008.devtools.collection.LruMapSupplier;
import com.github.paganini2008.devtools.collection.MapUtils;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class LruQueue<E>
extends AbstractQueue<E>
implements Queue<E>,
Serializable,
BoundedCollection<E> {
    private static final long serialVersionUID = -6416314527516614700L;
    private final Queue<E> delegate;
    private final int maxSize;
    private final AtomicInteger index = new AtomicInteger(0);
    private final Map<Integer, E> keys;

    public LruQueue() {
        this(128);
    }

    public LruQueue(int maxSize) {
        this(new ConcurrentLinkedQueue(), maxSize);
    }

    public LruQueue(int maxSize, LruMapSupplier<Integer, E> supplier) {
        this(new ConcurrentLinkedQueue(), maxSize, supplier);
    }

    public LruQueue(Queue<E> delegate, int maxSize) {
        this(delegate, maxSize, (size, listener) -> Collections.synchronizedMap(MapUtils.newLruMap(16, size, listener)));
    }

    public LruQueue(Queue<E> delegate, int maxSize, LruMapSupplier<Integer, E> supplier) {
        this.delegate = delegate;
        this.maxSize = maxSize;
        this.keys = supplier.get(maxSize, (key, value) -> {
            delegate.remove(value);
            this.onEviction(value);
        });
    }

    @Override
    public boolean offer(E e) {
        this.keys.put(this.index.getAndIncrement(), e);
        return this.delegate.offer(e);
    }

    @Override
    public E poll() {
        this.keys.remove(this.index.get() - this.maxSize - 1);
        return this.delegate.poll();
    }

    @Override
    public E peek() {
        this.keys.get(this.index.get() - this.maxSize - 1);
        return this.delegate.peek();
    }

    @Override
    public boolean contains(Object o) {
        this.keys.get(this.indexFor(o));
        return this.delegate.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        this.keys.remove(this.indexFor(o));
        return this.delegate.remove(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    private int indexFor(Object o) {
        for (Map.Entry<Integer, E> entry : this.keys.entrySet()) {
            if (!ObjectUtils.equals(o, entry.getValue())) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    public static void main(String[] args) {
    }
}

