/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.collection.BoundedCollection;
import com.github.paganini2008.devtools.collection.LruMapSupplier;
import com.github.paganini2008.devtools.collection.MapUtils;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class LruSet<E>
extends AbstractSet<E>
implements Set<E>,
Serializable,
BoundedCollection<E> {
    private static final long serialVersionUID = 1472051002956521109L;
    private final Set<E> delegate;
    private final Map<E, Object> keys;

    public LruSet() {
        this(128);
    }

    public LruSet(int maxSize) {
        this(new CopyOnWriteArraySet(), maxSize);
    }

    public LruSet(int maxSize, LruMapSupplier<E, Object> supplier) {
        this(new CopyOnWriteArraySet(), maxSize, supplier);
    }

    public LruSet(Set<E> delegate, int maxSize) {
        this(delegate, maxSize, (size, listener) -> Collections.synchronizedMap(MapUtils.newLruMap(16, size, listener)));
    }

    public LruSet(Set<E> delegate, int maxSize, LruMapSupplier<E, Object> supplier) {
        this.delegate = delegate;
        this.keys = supplier.get(maxSize, (key, value) -> {
            delegate.remove(key);
            this.onEviction(key);
        });
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean contains(Object o) {
        this.keys.get(o);
        return this.delegate.contains(o);
    }

    @Override
    public boolean add(E e) {
        this.keys.put(e, e);
        return this.delegate.add(e);
    }

    @Override
    public boolean remove(Object o) {
        this.keys.remove(o);
        return this.delegate.remove(o);
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.delegate.clear();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

