/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;

public class MultiDequeMap<K, V>
extends AbstractMap<K, Deque<V>>
implements Map<K, Deque<V>>,
Serializable {
    private static final long serialVersionUID = -7112963888352476892L;
    private final Map<K, Deque<V>> delegate;
    private final Supplier<Deque<V>> supplier;

    public MultiDequeMap() {
        this(new ConcurrentHashMap(), () -> new ConcurrentLinkedDeque());
    }

    public MultiDequeMap(Map<K, Deque<V>> delegate, Supplier<Deque<V>> supplier) {
        this.delegate = delegate;
        this.supplier = supplier;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    public void clear(K key) {
        Deque<V> q = this.delegate.get(key);
        if (q != null) {
            q.clear();
        }
    }

    @Override
    public Deque<V> remove(Object key) {
        return this.delegate.remove(key);
    }

    public V pollLast(K key) {
        Deque<V> q = this.delegate.get(key);
        return q.pollLast();
    }

    public V pollFirst(K key) {
        Deque<V> q = this.delegate.get(key);
        return q.pollFirst();
    }

    public V peekFirst(K key) {
        Deque<V> q = this.delegate.get(key);
        return q.peekFirst();
    }

    public V peekLast(K key) {
        Deque<V> q = this.delegate.get(key);
        return q.peekLast();
    }

    @Override
    public Deque<V> get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public void removeValue(K key, V value) {
        Deque<V> q = this.delegate.get(key);
        if (q != null) {
            while (q.contains(value)) {
                q.remove(value);
            }
        }
    }

    @Override
    public Set<Map.Entry<K, Deque<V>>> entrySet() {
        return this.delegate.entrySet();
    }

    public boolean containsValue(K key, V value) {
        Deque<V> q = this.delegate.get(key);
        return q != null ? q.contains(value) : false;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Deque<V> put(K key, Deque<V> value) {
        return this.delegate.put(key, value);
    }

    public void addAll(K key, Collection<V> values) {
        Deque<V> list = this.delegate.get(key);
        if (list == null) {
            this.delegate.putIfAbsent(key, this.supplier.get());
            list = this.delegate.get(key);
        }
        list.addAll(values);
    }

    public V addFirst(K key, V value) {
        Deque<V> q = this.delegate.get(key);
        if (q == null) {
            this.delegate.putIfAbsent(key, this.supplier.get());
            q = this.delegate.get(key);
        }
        q.addFirst(value);
        return value;
    }

    public V addLast(K key, V value) {
        Deque<V> q = this.delegate.get(key);
        if (q == null) {
            this.delegate.putIfAbsent(key, this.supplier.get());
            q = this.delegate.get(key);
        }
        q.addLast(value);
        return value;
    }

    public Map<K, V> toSingleValueMap() {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, Deque<V>> entry : this.delegate.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getFirst());
        }
        return map;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

