/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.collection.ListUtils;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;

public class MultiListMap<K, V>
extends AbstractMap<K, List<V>>
implements Map<K, List<V>>,
Serializable {
    private static final long serialVersionUID = 4293668328277273376L;
    private final Map<K, List<V>> delegate;
    private final Supplier<List<V>> supplier;

    public MultiListMap() {
        this(new ConcurrentHashMap(), () -> new CopyOnWriteArrayList());
    }

    public MultiListMap(Map<K, List<V>> delegate, Supplier<List<V>> supplier) {
        this.delegate = delegate;
        this.supplier = supplier;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    public void clear(K key) {
        List<V> list = this.delegate.get(key);
        if (list != null) {
            list.clear();
        }
    }

    @Override
    public List<V> remove(Object key) {
        return this.delegate.remove(key);
    }

    public V remove(K key, int index) {
        List<V> list = this.delegate.get(key);
        return ListUtils.remove(list, index);
    }

    public V pollLast(K key) {
        List<V> list = this.delegate.get(key);
        return ListUtils.removeLast(list);
    }

    public V pollFirst(K key) {
        List<V> list = this.delegate.get(key);
        return ListUtils.removeFirst(list);
    }

    public V peekFirst(K key) {
        List<V> list = this.delegate.get(key);
        return ListUtils.getFirst(list);
    }

    public V peekLast(K key) {
        List<V> list = this.delegate.get(key);
        return ListUtils.getLast(list);
    }

    public V get(K key, int index) {
        List<V> list = this.delegate.get(key);
        return ListUtils.get(list, index);
    }

    @Override
    public List<V> get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public void removeValue(K key, V value) {
        List<V> list = this.delegate.get(key);
        if (list != null) {
            while (list.contains(value)) {
                list.remove(value);
            }
        }
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.delegate.entrySet();
    }

    public boolean containsValue(K key, V value) {
        List<V> list = this.delegate.get(key);
        return list != null ? list.contains(value) : false;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public Set<K> keys() {
        return this.delegate.keySet();
    }

    @Override
    public List<V> put(K key, List<V> value) {
        return this.delegate.put(key, value);
    }

    public void addAll(K key, Collection<V> values) {
        List<V> list = this.delegate.get(key);
        if (list == null) {
            this.delegate.putIfAbsent(key, this.supplier.get());
            list = this.delegate.get(key);
        }
        list.addAll(values);
    }

    public V add(K key, V value) {
        List<V> list = this.delegate.get(key);
        if (list == null) {
            this.delegate.putIfAbsent(key, this.supplier.get());
            list = this.delegate.get(key);
        }
        list.add(value);
        return value;
    }

    public Map<K, V> toSingleValueMap() {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, List<V>> entry : this.delegate.entrySet()) {
            map.put(entry.getKey(), ListUtils.getFirst(entry.getValue()));
        }
        return map;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

