/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.collection.BoundedMap;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;

public class SortedBoundedMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable,
BoundedMap<K, V> {
    private static final long serialVersionUID = -2786447946165755013L;
    private final NavigableSet<K> keys;
    private final int maxSize;
    private final Map<K, V> delegate;
    private boolean asc = true;

    public SortedBoundedMap(int maxSize) {
        this(new LinkedHashMap(), maxSize);
    }

    public SortedBoundedMap(Map<K, V> delegate, int maxSize) {
        this(delegate, maxSize, new TreeSet());
    }

    protected SortedBoundedMap(Map<K, V> delegate, int maxSize, NavigableSet<K> keys) {
        this.delegate = delegate;
        this.maxSize = maxSize;
        this.keys = keys;
    }

    public void setAsc(boolean asc) {
        this.asc = asc;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        V eldestValue = this.delegate.put(key, value);
        this.ensureCapacity(key);
        return eldestValue;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V eldestValue = this.delegate.putIfAbsent(key, value);
        this.ensureCapacity(key);
        return eldestValue;
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCapacity(K key) {
        boolean reached;
        Object eldestKey = null;
        Object eldestValue = null;
        NavigableSet<K> navigableSet = this.keys;
        synchronized (navigableSet) {
            if (!this.keys.contains(key)) {
                this.keys.add(key);
            }
            if (reached = this.keys.size() > this.maxSize) {
                eldestKey = this.asc ? this.keys.pollFirst() : this.keys.pollLast();
                eldestValue = this.delegate.remove(eldestKey);
            }
        }
        if (reached) {
            this.onEviction(eldestKey, eldestValue);
        }
    }
}

