/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.comparator.map;

import com.github.paganini2008.devtools.comparator.AbstractComparator;
import com.github.paganini2008.devtools.comparator.ReverseComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MapComparator<K, V>
extends AbstractComparator<Map<K, V>> {
    private final List<Comparator<Map<K, V>>> comparatorChains = new ArrayList<Comparator<Map<K, V>>>();

    public void reset() {
        this.comparatorChains.clear();
    }

    public MapComparator<K, V> asc(K name) {
        this.comparatorChains.add(new ComparatorChain(name));
        return this;
    }

    public MapComparator<K, V> desc(K name) {
        this.comparatorChains.add(new ReverseComparator(new ComparatorChain(name)));
        return this;
    }

    @Override
    public int compare(Map<K, V> a, Map<K, V> b) {
        Comparator<Map<K, V>> chain;
        int value = 0;
        Iterator<Comparator<Map<K, V>>> iterator = this.comparatorChains.iterator();
        while (iterator.hasNext() && (value = (chain = iterator.next()).compare(a, b)) == 0) {
        }
        return value;
    }

    static class ComparatorChain<K, V>
    extends ClassifiedComparator<K, V> {
        ComparatorChain(K name) {
            super(name);
        }

        @Override
        public int compare(Map<K, V> a, Map<K, V> b) {
            int result = super.compare(a, b);
            if (result == 1) {
                V leftObject = a.get(this.name);
                V rightObject = b.get(this.name);
                return ((Comparable)leftObject).compareTo((Comparable)rightObject);
            }
            return 0;
        }

        public String toString() {
            return "[ComparatorChain] Order by: " + this.name;
        }
    }

    static class ClassifiedComparator<K, V>
    implements Comparator<Map<K, V>> {
        final K name;

        ClassifiedComparator(K name) {
            this.name = name;
        }

        @Override
        public int compare(Map<K, V> a, Map<K, V> b) {
            int rightValue;
            V leftObject = a.get(this.name);
            V rightObject = b.get(this.name);
            int leftValue = leftObject instanceof Comparable ? 1 : 0;
            int n = rightValue = rightObject instanceof Comparable ? 1 : 0;
            return leftValue * rightValue == 1 ? (leftObject.getClass() == rightObject.getClass() ? 1 : 0) : 0;
        }
    }
}

