/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.date.CalendarUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CalendarConverter
extends BasicConverter<Calendar> {
    private final Converter<Long, Calendar> longConverter = new Converter<Long, Calendar>(){

        @Override
        public Calendar convertValue(Long source, Calendar defaultValue) {
            return CalendarUtils.toCalendar(source, CalendarConverter.this.timeZone, defaultValue);
        }
    };
    private final Converter<String, Calendar> stringConverter = new Converter<String, Calendar>(){

        @Override
        public Calendar convertValue(String source, Calendar defaultValue) {
            return CalendarUtils.parse(source, CalendarConverter.this.datePattern, defaultValue);
        }
    };
    private final Converter<Date, Calendar> dateConverter = new Converter<Date, Calendar>(){

        @Override
        public Calendar convertValue(Date source, Calendar defaultValue) {
            return CalendarUtils.toCalendar(source, CalendarConverter.this.timeZone, defaultValue);
        }
    };
    private final Converter<LocalDate, Calendar> localDateConverter = new Converter<LocalDate, Calendar>(){

        @Override
        public Calendar convertValue(LocalDate source, Calendar defaultValue) {
            return CalendarUtils.toCalendar(source, CalendarConverter.this.timeZone, defaultValue);
        }
    };
    private final Converter<LocalDateTime, Calendar> localDateTimeConverter = new Converter<LocalDateTime, Calendar>(){

        @Override
        public Calendar convertValue(LocalDateTime source, Calendar defaultValue) {
            return CalendarUtils.toCalendar(source, CalendarConverter.this.timeZone, defaultValue);
        }
    };
    private TimeZone timeZone = TimeZone.getDefault();
    private String datePattern = "yyyy-MM-dd HH:mm:ss";

    public CalendarConverter() {
        this.registerType(Long.class, this.longConverter);
        this.registerType(String.class, this.stringConverter);
        this.registerType(Date.class, this.dateConverter);
        this.registerType(LocalDate.class, this.localDateConverter);
        this.registerType(LocalDateTime.class, this.localDateTimeConverter);
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }
}

