/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.date.DateUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

public class DateConverter
extends BasicConverter<Date> {
    private final Converter<Long, Date> longConverter = new Converter<Long, Date>(){

        @Override
        public Date convertValue(Long source, Date defaultValue) {
            return DateUtils.toDate(source, defaultValue);
        }
    };
    private final Converter<String, Date> stringConverter = new Converter<String, Date>(){

        @Override
        public Date convertValue(String source, Date defaultValue) {
            return DateUtils.parse(source, DateConverter.this.datePatterns, defaultValue);
        }
    };
    private final Converter<Calendar, Date> calendarConverter = new Converter<Calendar, Date>(){

        @Override
        public Date convertValue(Calendar source, Date defaultValue) {
            return DateUtils.toDate(source, defaultValue);
        }
    };
    private final Converter<int[], Date> intArrayConverter = new Converter<int[], Date>(){

        @Override
        public Date convertValue(int[] source, Date defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            if (source.length == 3) {
                return DateUtils.valueOf(source[0], source[1], source[2]);
            }
            if (source.length == 6) {
                return DateUtils.valueOf(source[0], source[1], source[2], source[3], source[4], source[5]);
            }
            throw new IllegalArgumentException("Int array's length need to be 3 or 6.");
        }
    };
    private final Converter<LocalDate, Date> localDateConverter = new Converter<LocalDate, Date>(){

        @Override
        public Date convertValue(LocalDate source, Date defaultValue) {
            return DateUtils.toDate(source, DateConverter.this.zoneId, defaultValue);
        }
    };
    private final Converter<LocalDateTime, Date> localDateTimeConverter = new Converter<LocalDateTime, Date>(){

        @Override
        public Date convertValue(LocalDateTime source, Date defaultValue) {
            return DateUtils.toDate(source, DateConverter.this.zoneId, defaultValue);
        }
    };
    private ZoneId zoneId = ZoneId.systemDefault();
    private String[] datePatterns = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyyMMddHHmmss"};

    public DateConverter() {
        this.registerType(Long.class, this.longConverter);
        this.registerType(String.class, this.stringConverter);
        this.registerType(Calendar.class, this.calendarConverter);
        this.registerType(int[].class, this.intArrayConverter);
        this.registerType(LocalDate.class, this.localDateConverter);
        this.registerType(LocalDateTime.class, this.localDateTimeConverter);
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void setDatePatterns(String[] datePatterns) {
        this.datePatterns = datePatterns;
    }
}

