/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.date.LocalDateUtils;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public class LocalTimeConverter
extends BasicConverter<LocalTime> {
    private final Converter<Long, LocalTime> longConverter = new Converter<Long, LocalTime>(){

        @Override
        public LocalTime convertValue(Long source, LocalTime defaultValue) {
            return LocalDateUtils.toLocalTime(source, LocalTimeConverter.this.zoneId, defaultValue);
        }
    };
    private final Converter<String, LocalTime> stringConverter = new Converter<String, LocalTime>(){

        @Override
        public LocalTime convertValue(String source, LocalTime defaultValue) {
            return LocalDateUtils.parseLocalTime(source, LocalTimeConverter.this.timeFormatter, defaultValue);
        }
    };
    private final Converter<Date, LocalTime> dateConverter = new Converter<Date, LocalTime>(){

        @Override
        public LocalTime convertValue(Date source, LocalTime defaultValue) {
            return LocalDateUtils.toLocalTime(source, LocalTimeConverter.this.zoneId, defaultValue);
        }
    };
    private final Converter<Calendar, LocalTime> calendarConverter = new Converter<Calendar, LocalTime>(){

        @Override
        public LocalTime convertValue(Calendar source, LocalTime defaultValue) {
            return LocalDateUtils.toLocalTime(source, LocalTimeConverter.this.zoneId, defaultValue);
        }
    };
    private ZoneId zoneId = ZoneId.systemDefault();
    private DateTimeFormatter timeFormatter = LocalDateUtils.DEFAULT_TIME_FORMATTER;

    public LocalTimeConverter() {
        this.registerType(Long.class, this.longConverter);
        this.registerType(String.class, this.stringConverter);
        this.registerType(Date.class, this.dateConverter);
        this.registerType(Calendar.class, this.calendarConverter);
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void setTimeFormatter(DateTimeFormatter timeFormatter) {
        this.timeFormatter = timeFormatter;
    }
}

