/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.date;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.date.DateUtils;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public abstract class CalendarUtils {
    public static final Calendar[] EMPTY_ARRAY = new Calendar[0];

    public static String[] formatMany(Calendar[] dates) {
        return CalendarUtils.formatMany(dates, DateUtils.DEFAULT_DATE_FORMATTER);
    }

    public static String[] formatMany(Calendar[] dates, DateFormat df) {
        return CalendarUtils.formatMany(dates, df, null);
    }

    public static String[] formatMany(Calendar[] dates, DateFormat df, String defaultValue) {
        Assert.isNull(dates, "Calendar array can not be null.", new Object[0]);
        String[] values = new String[dates.length];
        int i = 0;
        for (Calendar date : dates) {
            values[i++] = CalendarUtils.format(date, df, defaultValue);
        }
        return values;
    }

    public static String[] formatMany(Calendar[] dates, String datePattern) {
        return CalendarUtils.formatMany(dates, datePattern, "");
    }

    public static String[] formatMany(Calendar[] dates, String datePattern, String defaultValue) {
        return CalendarUtils.formatMany(dates, DateUtils.getDateFormatter(datePattern), defaultValue);
    }

    public static String format(Calendar c, String datePattern) {
        return CalendarUtils.format(c, datePattern, "");
    }

    public static String format(Calendar c, String datePattern, String defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        return DateUtils.format(c.getTime(), datePattern, defaultValue);
    }

    public static String format(Calendar cal) {
        return CalendarUtils.format(cal, DateUtils.DEFAULT_DATE_FORMATTER);
    }

    public static String format(Calendar c, DateFormat df) {
        return CalendarUtils.format(c, df, null);
    }

    public static String format(Calendar c, DateFormat df, String defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        return DateUtils.format(c.getTime(), df, defaultValue);
    }

    public static Calendar parse(String date, String datePattern) {
        return CalendarUtils.parse(date, datePattern, null);
    }

    public static Calendar parse(String date, String[] datePatterns) {
        return CalendarUtils.parse(date, datePatterns, null);
    }

    public static Calendar parse(String date, String datePattern, Calendar defaultValue) {
        if (StringUtils.isBlank(date)) {
            return defaultValue;
        }
        Date value = DateUtils.parse(date, datePattern);
        return CalendarUtils.toCalendar(value, TimeZone.getDefault(), defaultValue);
    }

    public static Calendar parse(String date, String[] datePatterns, Calendar defaultValue) {
        if (StringUtils.isBlank(date)) {
            return defaultValue;
        }
        Date value = DateUtils.parse(date, datePatterns);
        return CalendarUtils.toCalendar(value, TimeZone.getDefault(), defaultValue);
    }

    public static Calendar[] parseMany(String[] dates, String[] datePatterns) {
        return CalendarUtils.parseMany(dates, datePatterns, null);
    }

    public static Calendar[] parseMany(String[] dates, String[] datePatterns, Calendar defaultValue) {
        Calendar[] array = new Calendar[dates.length];
        int j = 0;
        for (String date : dates) {
            array[j++] = CalendarUtils.parse(date, datePatterns, defaultValue);
        }
        return array;
    }

    public static Calendar[] toCalendarArray(long[] dates, TimeZone timeZone) {
        Calendar[] array = new Calendar[dates.length];
        int i = 0;
        for (long date : dates) {
            array[i++] = CalendarUtils.toCalendar(date, timeZone);
        }
        return array;
    }

    public static Calendar[] toCalendarArray(Long[] dates, TimeZone timeZone) {
        return CalendarUtils.toCalendarArray(dates, timeZone, null);
    }

    public static Calendar[] toCalendarArray(Long[] dates, TimeZone timeZone, Calendar defaultValue) {
        Calendar[] array = new Calendar[dates.length];
        int i = 0;
        Long[] longArray = dates;
        int n = longArray.length;
        for (int j = 0; j < n; ++j) {
            long date = longArray[j];
            array[i++] = CalendarUtils.toCalendar(date, timeZone, defaultValue);
        }
        return array;
    }

    public static Calendar toCalendar(Long ms, TimeZone timeZone) {
        return CalendarUtils.toCalendar(ms, timeZone, null);
    }

    public static Calendar toCalendar(Long ms, TimeZone timeZone, Calendar defaultValue) {
        if (ms == null) {
            return defaultValue;
        }
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.setTimeInMillis(ms);
        return c;
    }

    public static Calendar toCalendar(Date date, TimeZone timeZone) {
        return CalendarUtils.toCalendar(date, timeZone, null);
    }

    public static Calendar toCalendar(Date date, TimeZone timeZone, Calendar defaultValue) {
        if (date == null) {
            return defaultValue;
        }
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.setTime(date);
        return c;
    }

    public static Calendar toCalendar(LocalDateTime localDateTime, TimeZone timeZone) {
        return CalendarUtils.toCalendar(localDateTime, timeZone, null);
    }

    public static Calendar toCalendar(LocalDateTime localDateTime, TimeZone timeZone, Calendar defaultValue) {
        return localDateTime != null ? CalendarUtils.toCalendar(DateUtils.toDate(localDateTime, timeZone.toZoneId()), timeZone) : defaultValue;
    }

    public static Calendar toCalendar(LocalDate localDate, TimeZone timeZone) {
        return CalendarUtils.toCalendar(localDate, timeZone, null);
    }

    public static Calendar toCalendar(LocalDate localDate, TimeZone timeZone, Calendar defaultValue) {
        return localDate != null ? CalendarUtils.toCalendar(DateUtils.toDate(localDate, timeZone.toZoneId()), timeZone) : defaultValue;
    }

    public static Calendar[] toCalendarArray(Date[] dates, TimeZone timeZone) {
        return CalendarUtils.toCalendarArray(dates, timeZone, null);
    }

    public static Calendar[] toCalendarArray(Date[] dates, TimeZone timeZone, Calendar defaultValue) {
        Calendar[] array = new Calendar[dates.length];
        int j = 0;
        for (Date date : dates) {
            array[j++] = CalendarUtils.toCalendar(date, timeZone, defaultValue);
        }
        return array;
    }

    public static Long getTimeInMillis(Calendar date) {
        return CalendarUtils.getTimeInMillis(date, null);
    }

    public static Long getTimeInMillis(Calendar date, Long defaultValue) {
        return date != null ? date.getTimeInMillis() : defaultValue.longValue();
    }

    public static Long[] getTimeInMillis(Calendar[] dates) {
        return CalendarUtils.getTimeInMillis(dates, null);
    }

    public static Long[] getTimeInMillis(Calendar[] dates, Long defaultValue) {
        Assert.isNull(dates, "Calendar array can not be null.", new Object[0]);
        Long[] values = new Long[dates.length];
        int j = 0;
        for (Calendar date : dates) {
            values[j++] = CalendarUtils.getTimeInMillis(date, defaultValue);
        }
        return values;
    }

    public static Calendar valueOf(long time, int hour, int minute, int second) {
        Calendar c = CalendarUtils.toCalendar(time, TimeZone.getDefault());
        c.set(11, hour);
        c.set(12, minute);
        c.set(13, second);
        return c;
    }

    public static Calendar valueOf(int year, int month, int date) {
        return CalendarUtils.valueOf(year, month, date, 0, 0, 0);
    }

    public static Calendar valueOf(int year, int month, int date, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, date, hour, minute, second);
        return c;
    }
}

