/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.date;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.LruMap;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public abstract class LocalDateUtils {
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_PATTERN = "HH:mm:ss";
    public static final String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter DEFAULT_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ENGLISH);
    public static final DateTimeFormatter DEFAULT_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ENGLISH);
    public static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    private static final LruMap<String, DateTimeFormatter> datetimeFormatterCache = new LruMap(16);

    public static LocalDate toLocalDate(Long ms, ZoneId zoneId) {
        return LocalDateUtils.toLocalDate(ms, zoneId, null);
    }

    public static LocalDate toLocalDate(Long ms, ZoneId zoneId, LocalDate defaultValue) {
        try {
            return ms != null ? Instant.ofEpochMilli(ms).atZone(zoneId).toLocalDate() : defaultValue;
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static LocalDate toLocalDate(Date date, ZoneId zoneId) {
        return LocalDateUtils.toLocalDate(date, zoneId, null);
    }

    public static LocalDate toLocalDate(Date date, ZoneId zoneId, LocalDate defaultValue) {
        try {
            return date != null ? date.toInstant().atZone(zoneId).toLocalDate() : defaultValue;
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static LocalDate toLocalDate(Calendar calendar, ZoneId zoneId) {
        return LocalDateUtils.toLocalDate(calendar, zoneId, null);
    }

    public static LocalDate toLocalDate(Calendar calendar, ZoneId zoneId, LocalDate defaultValue) {
        try {
            return calendar != null ? calendar.toInstant().atZone(zoneId).toLocalDate() : defaultValue;
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static LocalDateTime toLocalDateTime(Long ms, ZoneId zoneId) {
        return LocalDateUtils.toLocalDateTime(ms, zoneId, null);
    }

    public static LocalDateTime toLocalDateTime(Long ms, ZoneId zoneId, LocalDateTime defaultValue) {
        try {
            return ms != null ? Instant.ofEpochMilli(ms).atZone(zoneId).toLocalDateTime() : defaultValue;
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static LocalDateTime toLocalDateTime(Date date, ZoneId zoneId) {
        return LocalDateUtils.toLocalDateTime(date, zoneId, null);
    }

    public static LocalDateTime toLocalDateTime(Date date, ZoneId zoneId, LocalDateTime defaultValue) {
        try {
            return date != null ? date.toInstant().atZone(zoneId).toLocalDateTime() : defaultValue;
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static LocalDateTime toLocalDateTime(Calendar calendar, ZoneId zoneId) {
        return LocalDateUtils.toLocalDateTime(calendar, zoneId, null);
    }

    public static LocalDateTime toLocalDateTime(Calendar calendar, ZoneId zoneId, LocalDateTime defaultValue) {
        try {
            return calendar != null ? calendar.toInstant().atZone(zoneId).toLocalDateTime() : defaultValue;
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static LocalTime toLocalTime(Long ms, ZoneId zoneId) {
        return LocalDateUtils.toLocalTime(ms, zoneId, null);
    }

    public static LocalTime toLocalTime(Long ms, ZoneId zoneId, LocalTime defaultValue) {
        try {
            return ms != null ? Instant.ofEpochMilli(ms).atZone(zoneId).toLocalTime() : defaultValue;
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static LocalTime toLocalTime(Date date, ZoneId zoneId) {
        return LocalDateUtils.toLocalTime(date, zoneId, null);
    }

    public static LocalTime toLocalTime(Date date, ZoneId zoneId, LocalTime defaultValue) {
        try {
            return date != null ? date.toInstant().atZone(zoneId).toLocalTime() : defaultValue;
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static LocalTime toLocalTime(Calendar calendar, ZoneId zoneId) {
        return LocalDateUtils.toLocalTime(calendar, zoneId, null);
    }

    public static LocalTime toLocalTime(Calendar calendar, ZoneId zoneId, LocalTime defaultValue) {
        try {
            return calendar != null ? calendar.toInstant().atZone(zoneId).toLocalTime() : defaultValue;
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    private static DateTimeFormatter getDateTimeFormatter(String datePattern) {
        Assert.hasNoText(datePattern, "Date pattern can not be blank.", new Object[0]);
        DateTimeFormatter sdf = datetimeFormatterCache.get(datePattern);
        if (sdf == null) {
            datetimeFormatterCache.put(datePattern, DateTimeFormatter.ofPattern(datePattern, Locale.ENGLISH));
            sdf = datetimeFormatterCache.get(datePattern);
        }
        return sdf;
    }

    public static String format(LocalDate localDate) {
        return LocalDateUtils.format(localDate, DEFAULT_DATETIME_FORMATTER);
    }

    public static String format(LocalDate localDate, DateTimeFormatter dateTimeFormatter) {
        return LocalDateUtils.format(localDate, dateTimeFormatter, "");
    }

    public static String format(LocalDate localDate, DateTimeFormatter dateTimeFormatter, String defaultValue) {
        return localDate != null ? localDate.format(dateTimeFormatter) : defaultValue;
    }

    public static String format(LocalDate localDate, String datePattern) {
        return LocalDateUtils.format(localDate, datePattern, "");
    }

    public static String format(LocalDate localDate, String datePattern, String defaultValue) {
        return localDate != null ? localDate.format(LocalDateUtils.getDateTimeFormatter(datePattern)) : defaultValue;
    }

    public static String format(LocalDateTime localDateTime, String datePattern) {
        return LocalDateUtils.format(localDateTime, datePattern, "");
    }

    public static String format(LocalDateTime localDateTime, String datePattern, String defaultValue) {
        return localDateTime != null ? localDateTime.format(LocalDateUtils.getDateTimeFormatter(datePattern)) : defaultValue;
    }

    public static String format(LocalDateTime localDateTime) {
        return LocalDateUtils.format(localDateTime, DEFAULT_DATETIME_FORMATTER);
    }

    public static String format(LocalDateTime localDateTime, DateTimeFormatter dateTimeFormatter) {
        return LocalDateUtils.format(localDateTime, dateTimeFormatter, "");
    }

    public static String format(LocalDateTime localDateTime, DateTimeFormatter dateTimeFormatter, String defaultValue) {
        return localDateTime != null ? localDateTime.format(dateTimeFormatter) : defaultValue;
    }

    public static Long getTimeInMillis(Instant instant) {
        return LocalDateUtils.getTimeInMillis(instant, null);
    }

    public static Long getTimeInMillis(Instant instant, Long defaultValue) {
        return instant != null ? instant.toEpochMilli() : defaultValue.longValue();
    }

    public static LocalDate parseLocalDate(String text) {
        return LocalDateUtils.parseLocalDate(text, DEFAULT_DATE_FORMATTER);
    }

    public static LocalDate parseLocalDate(String text, DateTimeFormatter formatter) {
        return LocalDateUtils.parseLocalDate(text, formatter, null);
    }

    public static LocalDate parseLocalDate(String text, DateTimeFormatter formatter, LocalDate defaultValue) {
        try {
            return StringUtils.isNotBlank(text) ? LocalDate.parse(text, formatter) : defaultValue;
        }
        catch (DateTimeParseException e) {
            return defaultValue;
        }
    }

    public static LocalDate parseLocalDate(String text, String datePattern) {
        return LocalDateUtils.parseLocalDate(text, datePattern, null);
    }

    public static LocalDate parseLocalDate(String text, String datePattern, LocalDate defaultValue) {
        return LocalDateUtils.parseLocalDate(text, LocalDateUtils.getDateTimeFormatter(datePattern), defaultValue);
    }

    public static LocalDateTime parseLocalDateTime(String text) {
        return LocalDateUtils.parseLocalDateTime(text, DEFAULT_DATETIME_FORMATTER);
    }

    public static LocalDateTime parseLocalDateTime(String text, DateTimeFormatter formatter) {
        return LocalDateUtils.parseLocalDateTime(text, formatter, null);
    }

    public static LocalDateTime parseLocalDateTime(String text, DateTimeFormatter formatter, LocalDateTime defaultValue) {
        try {
            return StringUtils.isNotBlank(text) ? LocalDateTime.parse(text, formatter) : defaultValue;
        }
        catch (DateTimeParseException e) {
            return defaultValue;
        }
    }

    public static LocalDateTime parseLocalDateTime(String text, String datePattern) {
        return LocalDateUtils.parseLocalDateTime(text, datePattern, null);
    }

    public static LocalDateTime parseLocalDateTime(String text, String datePattern, LocalDateTime defaultValue) {
        return LocalDateUtils.parseLocalDateTime(text, LocalDateUtils.getDateTimeFormatter(datePattern), defaultValue);
    }

    public static LocalTime parseLocalTime(String text) {
        return LocalDateUtils.parseLocalTime(text, DEFAULT_TIME_FORMATTER);
    }

    public static LocalTime parseLocalTime(String text, DateTimeFormatter formatter) {
        return LocalDateUtils.parseLocalTime(text, formatter, null);
    }

    public static LocalTime parseLocalTime(String text, DateTimeFormatter formatter, LocalTime defaultValue) {
        try {
            return StringUtils.isNotBlank(text) ? LocalTime.parse(text, formatter) : defaultValue;
        }
        catch (DateTimeParseException e) {
            return defaultValue;
        }
    }

    public static LocalTime parseLocalTime(String text, String datePattern) {
        return LocalDateUtils.parseLocalTime(text, datePattern, null);
    }

    public static LocalTime parseLocalTime(String text, String datePattern, LocalTime defaultValue) {
        return LocalDateUtils.parseLocalTime(text, LocalDateUtils.getDateTimeFormatter(datePattern), defaultValue);
    }
}

