/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.event;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.ClassUtils;
import com.github.paganini2008.devtools.event.Event;
import com.github.paganini2008.devtools.event.EventGroup;
import com.github.paganini2008.devtools.event.EventSubscriber;
import com.github.paganini2008.devtools.multithreads.AtomicIntegerSequence;
import com.github.paganini2008.devtools.multithreads.ForEach;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;

public class EventBus<E extends Event<T>, T> {
    private EventHandler<E, T> eventHandler;
    private final boolean autoShutdown;

    public EventBus(int nThreads, boolean multicast) {
        this(Executors.newFixedThreadPool(nThreads), multicast, true);
    }

    public EventBus(Executor executor, boolean multicast, boolean autoShutdownExecutor) {
        this.eventHandler = new EventHandler(executor, multicast);
        this.autoShutdown = autoShutdownExecutor;
    }

    public void publish(E event) {
        this.eventHandler.publish(event);
    }

    public void subscribe(EventSubscriber<E, T> subscriber) {
        this.eventHandler.subscribe(subscriber);
    }

    public void unsubscribe(EventSubscriber<E, T> subscriber) {
        this.eventHandler.unsubscribe(subscriber);
    }

    public void close() {
        this.eventHandler.join(this.autoShutdown);
    }

    private static Class<?> findParameterizedType(Class<?> implementation) {
        List<ParameterizedType> parameterizedTypes = ClassUtils.getAllParameterizedTypes(implementation);
        for (ParameterizedType parameterizedType : parameterizedTypes) {
            if (parameterizedType.getRawType() != EventSubscriber.class) continue;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            return (Class)actualTypeArguments[0];
        }
        throw new IllegalStateException(implementation.getName());
    }

    static class PubSubGroup<E extends Event<T>, T>
    implements EventGroup<E, T> {
        final ForEach<Runnable> forEach;
        final BlockingQueue<EventSubscriber<E, T>> q;
        final boolean multicast;

        PubSubGroup(ForEach<Runnable> forEach, boolean multicast) {
            this.forEach = forEach;
            this.multicast = multicast;
            this.q = new PriorityBlockingQueue<EventSubscriber<E, T>>();
        }

        @Override
        public void subscribe(EventSubscriber<E, T> subscriber) {
            if (!this.q.contains(subscriber)) {
                this.q.add(subscriber);
            }
        }

        @Override
        public void unsubscribe(EventSubscriber<E, T> subscriber) {
            this.q.remove(subscriber);
        }

        @Override
        public void onEventFired(E event) {
            if (this.q.isEmpty()) {
                return;
            }
            if (this.multicast) {
                this.q.forEach(subscriber -> this.forEach.accept(() -> subscriber.onEventFired(event)));
            } else {
                ArrayList list = new ArrayList();
                if (this.q.drainTo(list) > 0) {
                    list.forEach(subscriber -> this.forEach.accept(() -> subscriber.onEventFired(event)));
                }
            }
        }
    }

    static class QueueGroup<E extends Event<T>, T>
    implements EventGroup<E, T> {
        final ForEach<Runnable> forEach;
        final List<EventSubscriber<E, T>> list;
        final boolean multicast;
        final AtomicIntegerSequence index = new AtomicIntegerSequence(0);

        QueueGroup(ForEach<Runnable> forEach, boolean multicast) {
            this.forEach = forEach;
            this.multicast = multicast;
            this.list = new CopyOnWriteArrayList<EventSubscriber<E, T>>();
        }

        @Override
        public void subscribe(EventSubscriber<E, T> subscriber) {
            if (!this.list.contains(subscriber)) {
                this.list.add(subscriber);
                this.index.setMaxValue(this.list.size() - 1);
            }
        }

        @Override
        public void unsubscribe(EventSubscriber<E, T> subscriber) {
            if (this.list.contains(subscriber)) {
                this.list.remove(subscriber);
                this.index.setMaxValue(this.list.size() - 1);
            }
        }

        @Override
        public void onEventFired(E event) {
            if (this.list.isEmpty()) {
                return;
            }
            EventSubscriber subscriber = this.multicast ? this.list.get(this.index.getAndIncrement()) : this.list.remove(this.index.getAndIncrement());
            this.forEach.accept(() -> subscriber.onEventFired(event));
        }
    }

    static class EventHandler<E extends Event<T>, T>
    extends ForEach<Runnable> {
        final boolean multicast;
        final ConcurrentMap<Class<?>, EventGroup<E, T>> eventGroups = new ConcurrentHashMap();

        EventHandler(Executor executor, boolean multicast) {
            super(executor, 200);
            this.multicast = multicast;
        }

        public void publish(E event) {
            if (this.eventGroups.containsKey(event.getClass())) {
                ((EventGroup)this.eventGroups.get(event.getClass())).onEventFired(event);
            }
        }

        public void subscribe(EventSubscriber<E, T> subscriber) {
            Assert.isNull(subscriber, "Nullable subscriber", new Object[0]);
            Class eventClass = EventBus.findParameterizedType(subscriber.getClass());
            EventGroup eventGroup = (EventGroup)this.eventGroups.get(eventClass);
            if (eventGroup == null) {
                this.eventGroups.putIfAbsent(eventClass, subscriber.isPubSub() ? new PubSubGroup(this, this.multicast) : new QueueGroup(this, this.multicast));
                eventGroup = (EventGroup)this.eventGroups.get(eventClass);
            }
            eventGroup.subscribe(subscriber);
        }

        public void unsubscribe(EventSubscriber<E, T> subscriber) {
            Assert.isNull(subscriber, "Nullable subscriber", new Object[0]);
            Class eventClass = EventBus.findParameterizedType(subscriber.getClass());
            if (this.eventGroups.containsKey(eventClass)) {
                EventGroup eventGroup = (EventGroup)this.eventGroups.get(eventClass);
                eventGroup.unsubscribe(subscriber);
            }
        }

        @Override
        protected void process(Runnable element) {
            element.run();
        }
    }
}

