/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.http;

import com.github.paganini2008.devtools.http.HttpConnectionFactory;
import com.github.paganini2008.devtools.http.HttpRequest;
import com.github.paganini2008.devtools.net.Urls;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

public class DefaultHttpConnectionFactory
implements HttpConnectionFactory {
    private SSLSocketFactory sslSocketFactory;

    @Override
    public HttpURLConnection openConnection(HttpRequest httpRequest) throws IOException {
        HttpURLConnection connection = httpRequest.proxy() != null ? (HttpURLConnection)httpRequest.url().openConnection(new Proxy(Proxy.Type.HTTP, httpRequest.proxy())) : (HttpURLConnection)httpRequest.url().openConnection();
        connection.setRequestMethod(httpRequest.method());
        connection.setConnectTimeout(httpRequest.connectTimeout());
        connection.setReadTimeout(httpRequest.readTimeout());
        connection.setDoOutput(httpRequest.doOutput());
        connection.setInstanceFollowRedirects(httpRequest.followRedirects());
        if (httpRequest.cookies().size() > 0) {
            connection.addRequestProperty("Cookie", httpRequest.cookie());
        }
        for (Map.Entry<String, String> header : httpRequest.headers().entrySet()) {
            connection.addRequestProperty(header.getKey(), header.getValue());
        }
        if (connection instanceof HttpsURLConnection && httpRequest.validateTLSCertificates()) {
            this.initUnsecuredTSL();
            ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslSocketFactory);
            ((HttpsURLConnection)connection).setHostnameVerifier(DefaultHttpConnectionFactory.getInsecureVerifier());
        }
        return connection;
    }

    private synchronized void initUnsecuredTSL() throws IOException {
        if (this.sslSocketFactory == null) {
            this.sslSocketFactory = Urls.defaultSSLSocketFactory();
        }
    }

    private static HostnameVerifier getInsecureVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
    }
}

