/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.http;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.collection.CaseInsensitiveMap;
import com.github.paganini2008.devtools.http.HttpBase;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class HttpBaseImpl<T extends HttpBase<T>>
implements HttpBase<T>,
Serializable {
    private static final long serialVersionUID = 6403400581804405562L;
    protected URL url;
    protected String method;
    protected String charset = "UTF-8";
    protected Map<String, String> headers = new CaseInsensitiveMap<String>();
    protected Map<String, String> cookies = new LinkedHashMap<String, String>();

    protected HttpBaseImpl() {
    }

    @Override
    public URL url() {
        return this.url;
    }

    @Override
    public T url(URL url) {
        Assert.isNull(url, "URL must not be null.", new Object[0]);
        this.url = url;
        return (T)this;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public T method(String method) {
        Assert.hasNoText(method, "Http method name must not be empty.", new Object[0]);
        this.method = method;
        return (T)this;
    }

    @Override
    public T charset(String charset) {
        Assert.hasNoText(charset, "Charset must not be null.", new Object[0]);
        if (!Charset.isSupported(charset)) {
            throw new IllegalCharsetNameException(charset);
        }
        this.charset = charset;
        return (T)this;
    }

    @Override
    public String charset() {
        return this.charset;
    }

    @Override
    public String header(String name) {
        Assert.isNull(name, "Header name must not be null.", new Object[0]);
        return this.headers.get(name);
    }

    @Override
    public T header(String name, String value) {
        Assert.hasNoText(name, "Header name must not be empty.", new Object[0]);
        Assert.isNull(value, "Header value must not be null.", new Object[0]);
        this.headers.put(name, value);
        return (T)this;
    }

    @Override
    public T headers(Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.headers.put(entry.getKey(), entry.getValue());
            }
        }
        return (T)this;
    }

    @Override
    public T cookies(Map<String, String> cookies) {
        if (cookies != null) {
            for (Map.Entry<String, String> entry : cookies.entrySet()) {
                this.cookies.put(entry.getKey(), entry.getValue());
            }
        }
        return (T)this;
    }

    @Override
    public boolean hasHeader(String name) {
        Assert.hasNoText(name, "Header name must not be empty.", new Object[0]);
        return this.headers.containsKey(name);
    }

    @Override
    public boolean hasHeaderWithValue(String name, String value) {
        return this.hasHeader(name) && this.header(name).equalsIgnoreCase(value);
    }

    @Override
    public T removeHeader(String name) {
        Assert.hasNoText(name, "Header name must not be empty.", new Object[0]);
        this.headers.remove(name);
        return (T)this;
    }

    @Override
    public Map<String, String> headers() {
        return this.headers;
    }

    @Override
    public String cookie(String name) {
        Assert.hasNoText(name, "Cookie name must not be empty.", new Object[0]);
        return this.cookies.get(name);
    }

    @Override
    public T cookie(String name, String value) {
        Assert.hasNoText(name, "Cookie name must not be empty.", new Object[0]);
        Assert.isNull(value, "Cookie value must not be null.", new Object[0]);
        this.cookies.put(name, value);
        return (T)this;
    }

    @Override
    public boolean hasCookie(String name) {
        Assert.hasNoText(name, "Cookie name must not be empty.", new Object[0]);
        return this.cookies.containsKey(name);
    }

    @Override
    public T removeCookie(String name) {
        Assert.hasNoText(name, "Cookie name must not be empty.", new Object[0]);
        this.cookies.remove(name);
        return (T)this;
    }

    @Override
    public Map<String, String> cookies() {
        return this.cookies;
    }

    @Override
    public String cookie() {
        StringBuilder str = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> cookie : this.cookies().entrySet()) {
            if (!first) {
                str.append("; ");
            } else {
                first = false;
            }
            str.append(cookie.getKey()).append('=').append(cookie.getValue());
        }
        return str.toString();
    }
}

