/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.http;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.http.HttpRequest;
import com.github.paganini2008.devtools.http.HttpRequestImpl;
import com.github.paganini2008.devtools.net.Urls;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public class HttpRequestBuilder
implements HttpRequest.Builder {
    protected final HttpRequest request = new HttpRequestImpl();

    public HttpRequestBuilder(String method, String url) {
        this(method, Urls.toURL(url));
    }

    public HttpRequestBuilder(String method, URL url) {
        this.request.method(method);
        this.request.url(url);
    }

    @Override
    public HttpRequest.Builder userAgent(String userAgent) {
        Assert.isNull(userAgent, "User agent must not be null", new Object[0]);
        this.request.header("User-Agent", userAgent);
        return this;
    }

    @Override
    public HttpRequest.Builder maxRedirects(int redirects) {
        this.request.maxRedirects(redirects);
        return this;
    }

    @Override
    public HttpRequest.Builder timeout(int millis) {
        this.request.connectTimeout(millis);
        this.request.readTimeout(millis);
        return this;
    }

    @Override
    public HttpRequest.Builder connectTimeout(int millis) {
        this.request.connectTimeout(millis);
        return this;
    }

    @Override
    public HttpRequest.Builder readTimeout(int millis) {
        this.request.readTimeout(millis);
        return this;
    }

    @Override
    public HttpRequest.Builder maxBodySize(int bytes) {
        this.request.maxBodySize(bytes);
        return this;
    }

    @Override
    public HttpRequest.Builder referer(String referer) {
        Assert.isNull(referer, "Referer must not be null", new Object[0]);
        this.request.header("Referer", referer);
        return this;
    }

    @Override
    public HttpRequest.Builder ignoreHttpErrors(boolean ignoreHttpErrors) {
        this.request.ignoreHttpErrors(ignoreHttpErrors);
        return this;
    }

    @Override
    public HttpRequest.Builder ignoreContentType(boolean ignoreContentType) {
        this.request.ignoreContentType(ignoreContentType);
        return this;
    }

    @Override
    public HttpRequest.Builder validateTLSCertificates(boolean value) {
        this.request.validateTLSCertificates(value);
        return this;
    }

    @Override
    public HttpRequest.Builder retryRequestsIfError(boolean retryRequests) {
        this.request.retryRequestsIfError(retryRequests);
        return this;
    }

    @Override
    public HttpRequest.Builder data(String key, String value) {
        this.request.data(key, value);
        return this;
    }

    @Override
    public HttpRequest.Builder data(String key, String filename, InputStream inputStream) {
        this.request.data(key, filename, inputStream);
        return this;
    }

    @Override
    public HttpRequest.Builder data(Map<String, String> data) {
        this.request.data(data);
        return this;
    }

    @Override
    public HttpRequest.Builder data(String ... nameValues) {
        String prev = null;
        for (String arg : nameValues) {
            if (prev == null) {
                prev = arg;
                continue;
            }
            this.data(prev, arg);
            prev = null;
        }
        if (prev != null) {
            this.data(prev, (String)null);
        }
        return this;
    }

    @Override
    public HttpRequest.Builder headers(Map<String, String> headers) {
        this.request.headers(headers);
        return this;
    }

    @Override
    public HttpRequest.Builder header(String name, String value) {
        this.request.header(name, value);
        return this;
    }

    @Override
    public HttpRequest.Builder cookie(String name, String value) {
        this.request.cookie(name, value);
        return this;
    }

    @Override
    public HttpRequest.Builder cookies(Map<String, String> cookies) {
        this.request.cookies(cookies);
        return this;
    }

    @Override
    public HttpRequest.Builder charset(String charset) {
        this.request.charset(charset);
        return this;
    }

    @Override
    public HttpRequest build() {
        return this.request;
    }
}

