/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.io.Directory;
import com.github.paganini2008.devtools.io.DirectoryWalker;
import com.github.paganini2008.devtools.multithreads.Executable;
import com.github.paganini2008.devtools.multithreads.ExecutorUtils;
import com.github.paganini2008.devtools.multithreads.ThreadPool;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.primitives.Floats;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractDirectoryWalker
implements DirectoryWalker {
    protected final File root;
    private int threadCount = 8;
    private DirectoryWalker.Progressable progressable;

    protected AbstractDirectoryWalker(File directory) {
        this.root = directory;
    }

    @Override
    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    @Override
    public void setProgressable(DirectoryWalker.Progressable progressable) {
        this.progressable = progressable;
    }

    @Override
    public Directory walk() {
        Executor threadPool = this.getThreadPool(this.threadCount);
        ProgressBarImpl progressBar = new ProgressBarImpl(this.root, this.progressable);
        FileInfoImpl rootInfo = new FileInfoImpl(this.root, null);
        this.walk(threadPool, this.root, rootInfo, 0, progressBar);
        progressBar.waitForTermination();
        this.shutdown(threadPool);
        return rootInfo;
    }

    protected abstract void walk(Executor var1, File var2, DirectoryWalker.FileInfo var3, int var4, DirectoryWalker.ProgressBar var5);

    protected abstract Executor getThreadPool(int var1);

    protected void shutdown(Executor threadPool) {
        if (threadPool instanceof ThreadPool) {
            ((ThreadPool)threadPool).shutdown();
        } else {
            ExecutorUtils.gracefulShutdown(threadPool, 60000L);
        }
    }

    static class FileInfoImpl
    implements DirectoryWalker.FileInfo {
        private final File file;
        private final Directory parent;
        private final AtomicInteger fileCount = new AtomicInteger(0);
        private final AtomicInteger folderCount = new AtomicInteger(0);
        private final AtomicLong length = new AtomicLong(0L);
        private final List<Directory> children = new CopyOnWriteArrayList<Directory>();
        private final AtomicBoolean done = new AtomicBoolean();
        private final long startTime;
        private long elapsed;

        FileInfoImpl(File file, Directory parent) {
            this.file = file;
            this.parent = parent;
            this.startTime = System.currentTimeMillis();
        }

        @Override
        public int getFileCount(boolean recursive) {
            int total = this.fileCount.get();
            if (recursive) {
                for (Directory fileInfo : this.children) {
                    total += fileInfo.getFileCount(recursive);
                }
            }
            return total;
        }

        @Override
        public int getFolderCount(boolean recursive) {
            int total = this.folderCount.get();
            if (recursive) {
                for (Directory fileInfo : this.children) {
                    total += fileInfo.getFolderCount(recursive);
                }
            }
            return total;
        }

        @Override
        public long getLength() {
            long total = this.length.get();
            for (Directory fileInfo : this.children) {
                total += fileInfo.getLength();
            }
            return total;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public Directory[] getChildren() {
            return this.children.toArray(new Directory[this.children.size()]);
        }

        @Override
        public long getLastModified() {
            long lastModified = this.file.lastModified();
            for (Directory fileInfo : this.children) {
                lastModified = Math.max(lastModified, fileInfo.getLastModified());
            }
            return lastModified;
        }

        @Override
        public DirectoryWalker.FileInfo newChildFileInfo(File childFile) {
            FileInfoImpl childFileInfo = new FileInfoImpl(childFile, this);
            this.children.add(childFileInfo);
            return childFileInfo;
        }

        @Override
        public Directory getParent() {
            return this.parent;
        }

        @Override
        public void process(File file) {
            if (file.isDirectory()) {
                this.folderCount.incrementAndGet();
            } else {
                this.fileCount.incrementAndGet();
                this.length.addAndGet(file.length());
            }
        }

        @Override
        public void done() {
            this.done.set(true);
            this.elapsed = System.currentTimeMillis() - this.startTime;
        }

        @Override
        public boolean isDone() {
            return this.done.get();
        }

        @Override
        public long getElapsed() {
            return this.elapsed;
        }
    }

    static class ProgressBarImpl
    implements DirectoryWalker.ProgressBar,
    Executable {
        private final File directory;
        private final AtomicInteger fileCounter = new AtomicInteger();
        private final AtomicInteger folderCounter = new AtomicInteger();
        private final AtomicLong length = new AtomicLong();
        private final int total;
        private final Map<String, AtomicInteger> stack = new ConcurrentHashMap<String, AtomicInteger>();
        private final long startTime;
        private final DirectoryWalker.Progressable progressable;
        private final AtomicBoolean cancelled = new AtomicBoolean();

        ProgressBarImpl(File directory, DirectoryWalker.Progressable progressable) {
            this.directory = directory;
            File[] fileArray = directory.listFiles();
            if (fileArray != null) {
                for (File file : fileArray) {
                    this.stack.put(file.getName(), new AtomicInteger(0));
                }
            }
            this.total = this.stack.size();
            this.progressable = progressable;
            this.startTime = System.currentTimeMillis();
            if (progressable != null) {
                ThreadUtils.scheduleWithFixedDelay((Executable)this, (long)progressable.refreshInterval(), TimeUnit.SECONDS);
            }
        }

        @Override
        public float getCompletionRate() {
            float value = (float)(this.total - this.stack.size()) / (float)this.total;
            return Floats.toFixed(value, 3);
        }

        @Override
        public int getFileCount() {
            return this.fileCounter.get();
        }

        @Override
        public int getFolderCount() {
            return this.folderCounter.get();
        }

        @Override
        public long getLength() {
            return this.length.get();
        }

        @Override
        public long getElapsed() {
            return System.currentTimeMillis() - this.startTime;
        }

        @Override
        public void waitForTermination() {
            ThreadUtils.wait(this, () -> this.isDone());
            if (this.progressable != null) {
                this.progressable.progress(this.getFileCount(), this.getFolderCount(), this.getLength(), this.getCompletionRate(), this.getElapsed());
            }
        }

        @Override
        public void cancel() {
            this.cancelled.set(true);
            this.stack.clear();
            ThreadUtils.notify(this, () -> this.isDone());
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled.get();
        }

        @Override
        public boolean isDone() {
            return this.stack.isEmpty();
        }

        @Override
        public boolean execute() {
            this.progressable.progress(this.getFileCount(), this.getFolderCount(), this.getLength(), this.getCompletionRate(), this.getElapsed());
            return !this.isDone();
        }

        @Override
        public void processBegin(File file) {
            if (file.isDirectory()) {
                this.folderCounter.incrementAndGet();
            } else {
                this.fileCounter.incrementAndGet();
                this.length.addAndGet(file.length());
            }
            String name = this.getPathName(file);
            AtomicInteger counter = this.stack.get(name);
            if (counter != null) {
                counter.incrementAndGet();
            }
        }

        @Override
        public void processEnd(File file) {
            String name = this.getPathName(file);
            AtomicInteger counter = this.stack.get(name);
            if (counter != null) {
                if (counter.get() > 0) {
                    counter.decrementAndGet();
                }
                if (counter.get() == 0) {
                    this.stack.remove(name);
                }
            }
            ThreadUtils.notify(this, () -> this.isDone());
        }

        private String getPathName(File file) {
            String path = file.getAbsolutePath().replace(this.directory.getAbsolutePath(), "");
            int index = path.indexOf(File.separatorChar, 1);
            return index != -1 ? path.substring(1, index) : path.substring(1);
        }
    }
}

