/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.Assert;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class FileAssert {
    public static void isFile(File arg) throws IOException {
        FileAssert.isFile(arg, "File '" + arg + "' is existed but is a file.");
    }

    public static void isFile(File file, String msg) throws IOException {
        Assert.isTrue(file != null && file.exists() && file.isFile(), new IOException(msg));
    }

    public static void isNotFile(File file) throws IOException {
        FileAssert.isNotFile(file, "File '" + file + "' dosen't exists or it's not a file.");
    }

    public static void isNotFile(File file, String msg) throws IOException {
        Assert.isFalse(file != null && file.exists() && file.isFile(), new IOException(msg));
    }

    public static void isDirectory(File file) throws IOException {
        FileAssert.isDirectory(file, "File '" + file + "' is existed but is a directory.");
    }

    public static void isDirectory(File file, String msg) throws IOException {
        Assert.isTrue(file != null && file.exists() && file.isDirectory(), new IOException(msg));
    }

    public static void isNotDirectory(File file) throws IOException {
        FileAssert.isNotDirectory(file, "File '" + file + "' doesn't exists or it's not a directory.");
    }

    public static void isNotDirectory(File file, String msg) throws IOException {
        Assert.isFalse(file != null && file.exists() && file.isDirectory(), new IOException(msg));
    }

    public static void existed(File file) throws IOException {
        FileAssert.existed(file, "File '" + file + "' is already existed.");
    }

    public static void existed(File file, String msg) throws IOException {
        Assert.isTrue(file != null && file.exists(), new IOException(msg));
    }

    public static void notExisted(File file) throws FileNotFoundException {
        FileAssert.notExisted(file, "File '" + file + "' is not existed.");
    }

    public static void notExisted(File file, String msg) throws FileNotFoundException {
        Assert.isFalse(file != null && file.exists(), new FileNotFoundException(msg));
    }

    public static void cannotWrite(File file) throws IOException {
        FileAssert.cannotWrite(file, "File '" + file + "' doesn't exists or can not be writen.");
    }

    public static void cannotWrite(File file, String msg) throws IOException {
        Assert.isFalse(file != null && file.exists() && file.canWrite(), new IOException(msg));
    }

    public static void cannotRead(File file) throws IOException {
        FileAssert.cannotRead(file, "File '" + file + "' doesn't exists or can not be read.");
    }

    public static void cannotRead(File file, String msg) throws IOException {
        Assert.isFalse(file != null && file.exists() && file.canRead(), new IOException(msg));
    }
}

