/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.CharsetUtils;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.io.FileAssert;
import com.github.paganini2008.devtools.io.IOUtils;
import com.github.paganini2008.devtools.io.PathUtils;
import com.github.paganini2008.devtools.io.ScanHandler;
import com.github.paganini2008.devtools.math.BigDecimalUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public abstract class FileUtils {
    public static final File[] EMPTY_ARRAY = new File[0];
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final long PB = 0x4000000000000L;
    public static final BigInteger EB = BigInteger.valueOf(1024L).multiply(BigInteger.valueOf(0x4000000000000L));
    public static final BigInteger ZB = BigInteger.valueOf(1024L).multiply(EB);
    public static final BigInteger YB = BigInteger.valueOf(1024L).multiply(ZB);
    public static final long FILE_COPY_BUFFER_SIZE = 0x1E00000L;

    public static File getFile(File directory, String ... names) {
        Assert.isNull(directory, "Destination directory must not be null.", new Object[0]);
        Assert.isNull(names, "Names must not be null.", new Object[0]);
        File file = directory;
        for (String name : names) {
            file = new File(file, name);
        }
        return file;
    }

    public static File getFile(String ... names) {
        Assert.isNull(names, "Names must not be null.", new Object[0]);
        File file = null;
        for (String name : names) {
            file = file == null ? new File(name) : new File(file, name);
        }
        return file;
    }

    public static String getTempDirectoryPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getTempDirectory() {
        return new File(FileUtils.getTempDirectoryPath());
    }

    public static String getUserHomePath() {
        return System.getProperty("user.home");
    }

    public static File getUserHome() {
        return new File(FileUtils.getUserHomePath());
    }

    public static String getUserDirectoryPath() {
        return System.getProperty("user.dir");
    }

    public static File getUserDirectory() {
        return new File(FileUtils.getUserDirectoryPath());
    }

    public static String getBaseName(File file) {
        return file != null ? PathUtils.getBaseName(file.getName()) : "";
    }

    public static String getExtension(File file) {
        return file != null ? PathUtils.getExtension(file.getName()) : "";
    }

    private static synchronized void canRead(File file) throws IOException {
        Assert.isNull(file, "Source file must not be null.", new Object[0]);
        FileAssert.notExisted(file);
        FileAssert.isDirectory(file);
        FileAssert.cannotRead(file);
    }

    private static synchronized void canScan(File directory) throws IOException {
        Assert.isNull(directory, "Source directory must not be null.", new Object[0]);
        FileAssert.notExisted(directory);
        FileAssert.isFile(directory);
        FileAssert.cannotRead(directory);
    }

    private static synchronized void canWrite(File file) throws IOException {
        Assert.isNull(file, "Destination file must not be null.", new Object[0]);
        FileAssert.isDirectory(file);
        FileUtils.touch(file);
        FileAssert.cannotWrite(file);
    }

    private static synchronized void canChange(File directory) throws IOException {
        Assert.isNull(directory, "Destination directory must not be null.", new Object[0]);
        FileAssert.isFile(directory);
        FileUtils.mkdirs(directory);
        FileAssert.cannotWrite(directory);
    }

    public static File[] getFiles(File parent, String ... files) {
        if (files == null) {
            return null;
        }
        int l = files.length;
        File[] array = new File[l];
        for (int i = 0; i < l; ++i) {
            array[i] = files[i] != null ? new File(parent, files[i]) : null;
        }
        return array;
    }

    public static File[] getFiles(String ... files) {
        if (files == null) {
            return null;
        }
        int l = files.length;
        File[] array = new File[l];
        for (int i = 0; i < l; ++i) {
            array[i] = files[i] != null ? new File(files[i]) : null;
        }
        return array;
    }

    public static void touch(File file) throws IOException {
        if (file != null) {
            if (file.exists()) {
                file.setLastModified(System.currentTimeMillis());
            } else {
                File parent = file.getParentFile();
                FileUtils.mkdirs(parent);
                if (!file.createNewFile() || !file.isFile()) {
                    throw new IOException("File '" + file + "' cannot be created.");
                }
            }
        }
    }

    public static boolean mkdirs(File dir) throws IOException {
        if (dir != null && !dir.exists()) {
            if (!dir.mkdirs() && !dir.isDirectory()) {
                throw new IOException("Directory '" + dir + "' cannot be created.");
            }
            return false;
        }
        return true;
    }

    public static void mkdirs(String dir) throws IOException {
        FileUtils.mkdirs(new File(dir));
    }

    public static void touch(String file) throws IOException {
        FileUtils.touch(new File(file));
    }

    public static RandomAccessFile getRandomAccessFile(File file) throws IOException {
        FileUtils.canRead(file);
        return new RandomAccessFile(file, "rw");
    }

    public static FileInputStream openInputStream(String file) throws IOException {
        return FileUtils.openInputStream(new File(file));
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        FileUtils.canRead(file);
        return new FileInputStream(file);
    }

    public static BufferedReader getBufferedReader(String filePath, String charset) throws IOException {
        return FileUtils.getBufferedReader(new File(filePath), charset);
    }

    public static BufferedReader getBufferedReader(File file, String charset) throws IOException {
        return IOUtils.getBufferedReader((InputStream)FileUtils.openInputStream(file), CharsetUtils.toCharset(charset));
    }

    public static BufferedReader getBufferedReader(File file, String charset, int bufferSize) throws IOException {
        return IOUtils.getBufferedReader((InputStream)FileUtils.openInputStream(file), CharsetUtils.toCharset(charset), bufferSize);
    }

    public static LineNumberReader getLineNumberReader(File file, Charset charset) throws IOException {
        return IOUtils.getLineNumberReader((InputStream)FileUtils.openInputStream(file), CharsetUtils.toCharset(charset));
    }

    public static FileOutputStream openOutputStream(String file) throws IOException {
        return FileUtils.openOutputStream(new File(file));
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return FileUtils.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(String file, boolean append) throws IOException {
        return FileUtils.openOutputStream(new File(file), append);
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        FileUtils.canWrite(file);
        return new FileOutputStream(file, append);
    }

    private static void writeBOM(FileOutputStream fos, Charset charset) throws IOException {
        if (CharsetUtils.UTF_8.equals(charset)) {
            fos.write(CharsetUtils.BOM_UTF_8);
        } else if (CharsetUtils.UTF_16BE.equals(charset)) {
            fos.write(CharsetUtils.BOM_UTF_16BE);
        } else if (CharsetUtils.UTF_16LE.equals(charset)) {
            fos.write(CharsetUtils.BOM_UTF_16LE);
        }
    }

    public static BufferedWriter getBufferedWriter(String filePath, Charset charset) throws IOException {
        return FileUtils.getBufferedWriter(new File(filePath), charset);
    }

    public static BufferedWriter getBufferedWriter(File file, Charset charset) throws IOException {
        return FileUtils.getBufferedWriter(file, false, charset);
    }

    public static BufferedWriter getBufferedWriter(File file, boolean append, Charset charset) throws IOException {
        FileOutputStream fos = FileUtils.openOutputStream(file, append);
        FileUtils.writeBOM(fos, charset);
        return IOUtils.getBufferedWriter((OutputStream)fos, charset);
    }

    public static String formatSize(long size) {
        return FileUtils.formatSize(size, 2);
    }

    public static String formatSize(long size, int scale) {
        return FileUtils.formatSize(BigInteger.valueOf(size), scale);
    }

    public static String formatSize(BigInteger size) {
        return FileUtils.formatSize(size, 2);
    }

    public static String formatSize(BigInteger size, int scale) {
        String displaySize;
        Assert.isNull(size, "Size must not be null.", new Object[0]);
        BigDecimal tmp = BigDecimalUtils.divide(size, YB, scale, RoundingMode.HALF_UP);
        if (tmp.toBigInteger().compareTo(BigInteger.ZERO) > 0) {
            displaySize = String.valueOf(tmp) + " YB";
        } else {
            tmp = BigDecimalUtils.divide(size, ZB, scale, RoundingMode.HALF_UP);
            if (tmp.toBigInteger().compareTo(BigInteger.ZERO) > 0) {
                displaySize = String.valueOf(tmp) + " ZB";
            } else {
                tmp = BigDecimalUtils.divide(size, EB, scale, RoundingMode.HALF_UP);
                if (tmp.toBigInteger().compareTo(BigInteger.ZERO) > 0) {
                    displaySize = String.valueOf(tmp) + " EB";
                } else {
                    tmp = BigDecimalUtils.divide(size, 0x4000000000000L, scale, RoundingMode.HALF_UP);
                    if (tmp.toBigInteger().compareTo(BigInteger.ZERO) > 0) {
                        displaySize = String.valueOf(tmp) + " PB";
                    } else {
                        tmp = BigDecimalUtils.divide(size, 0x10000000000L, scale, RoundingMode.HALF_UP);
                        if (tmp.toBigInteger().compareTo(BigInteger.ZERO) > 0) {
                            displaySize = String.valueOf(tmp) + " TB";
                        } else {
                            tmp = BigDecimalUtils.divide(size, 0x40000000L, scale, RoundingMode.HALF_UP);
                            if (tmp.toBigInteger().compareTo(BigInteger.ZERO) > 0) {
                                displaySize = String.valueOf(tmp) + " GB";
                            } else {
                                tmp = BigDecimalUtils.divide(size, 0x100000L, scale, RoundingMode.HALF_UP);
                                if (tmp.toBigInteger().compareTo(BigInteger.ZERO) > 0) {
                                    displaySize = String.valueOf(tmp) + " MB";
                                } else {
                                    tmp = BigDecimalUtils.divide(size, 1024L, scale, RoundingMode.HALF_UP);
                                    if (tmp.toBigInteger().compareTo(BigInteger.ZERO) > 0) {
                                        displaySize = String.valueOf(tmp) + " KB";
                                    } else {
                                        tmp = BigDecimalUtils.setScale(size, scale, RoundingMode.HALF_UP);
                                        displaySize = String.valueOf(tmp) + " bytes";
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return displaySize;
    }

    public static boolean isFileNewer(File file, File reference) throws IOException {
        FileAssert.notExisted(reference);
        return FileUtils.isFileNewer(file, reference.lastModified());
    }

    public static boolean isFileNewer(File file, Date referenceDate) throws IOException {
        Assert.isNull(referenceDate, "Unspecified referenceDate.", new Object[0]);
        return FileUtils.isFileNewer(file, referenceDate.getTime());
    }

    public static boolean isFileNewer(File file, long timeMillis) throws IOException {
        FileAssert.notExisted(file);
        return file.lastModified() > timeMillis;
    }

    public static boolean isFileOlder(File file, File reference) throws IOException {
        FileAssert.notExisted(reference);
        return FileUtils.isFileOlder(file, reference.lastModified());
    }

    public static boolean isFileOlder(File file, Date referenceDate) throws IOException {
        Assert.isNull(referenceDate, "Unspecified referenceDate.", new Object[0]);
        return FileUtils.isFileOlder(file, referenceDate.getTime());
    }

    public static boolean isFileOlder(File file, long timeMillis) throws IOException {
        FileAssert.notExisted(file);
        return file.lastModified() < timeMillis;
    }

    public static boolean isSymlink(File file) throws IOException {
        Assert.isNull(file, "File must not be null.", new Object[0]);
        if (PathUtils.isWindowsOS()) {
            return false;
        }
        File fileInCanonicalDir = null;
        if (file.getParent() == null) {
            fileInCanonicalDir = file;
        } else {
            File canonicalDir = file.getParentFile().getCanonicalFile();
            fileInCanonicalDir = new File(canonicalDir, file.getName());
        }
        return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }

    public static void deleteDirectory(File directory) throws IOException {
        FileUtils.canChange(directory);
        if (!FileUtils.isSymlink(directory)) {
            FileUtils.cleanDirectory(directory);
        }
        if (!directory.delete()) {
            throw new IOException("Unable to delete directory " + directory);
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        FileUtils.canChange(directory);
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                FileUtils.deleteFile(file);
            }
        }
    }

    public static void deleteFile(File file) throws IOException {
        Assert.isNull(file, "Destination file must not be null.", new Object[0]);
        FileAssert.notExisted(file);
        if (file.isDirectory()) {
            FileUtils.deleteDirectory(file);
        } else if (!file.delete()) {
            throw new IOException("Unable to delete file: " + file);
        }
    }

    public static void deleteFileOnExit(File file) throws IOException {
        Assert.isNull(file, "Destination file must not be null.", new Object[0]);
        FileAssert.notExisted(file);
        if (file.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file);
        } else {
            file.deleteOnExit();
        }
    }

    private static void deleteDirectoryOnExit(File directory) throws IOException {
        directory.deleteOnExit();
        if (!FileUtils.isSymlink(directory)) {
            FileUtils.cleanDirectoryOnExit(directory);
        }
    }

    private static void cleanDirectoryOnExit(File directory) throws IOException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                FileUtils.deleteFileOnExit(file);
            }
        }
    }

    public static String readFileToString(File file, Charset charset) throws IOException {
        Assert.isNull(file, "File must not be null.", new Object[0]);
        StringBuilder str = new StringBuilder();
        FileUtils.copyFile(file, str, charset);
        return str.toString();
    }

    public static String readFileToString(String filePath, Charset charset) throws IOException {
        return FileUtils.readFileToString(new File(filePath), charset);
    }

    public static boolean exists(File file) {
        return file != null ? file.exists() : false;
    }

    public static boolean notExists(File file) {
        return !FileUtils.exists(file);
    }

    public static boolean notExists(String file) {
        return !FileUtils.exists(file);
    }

    public static boolean exists(String file) {
        return file != null ? new File(file).exists() : false;
    }

    public static boolean isAvailable(String file) {
        return file != null ? FileUtils.isAvailable(new File(file)) : false;
    }

    public static boolean isAvailable(File f) {
        return f != null ? f.exists() && f.canRead() && f.canWrite() : false;
    }

    public static boolean isNotAvailable(String file) {
        return !FileUtils.isAvailable(file);
    }

    public static boolean isNotAvailable(File f) {
        return !FileUtils.isAvailable(f);
    }

    public static List<String> readLines(File file) throws IOException {
        return FileUtils.readLines(file, CharsetUtils.UTF_8);
    }

    public static List<String> readLines(File file, Charset charset) throws IOException {
        Assert.isNull(file, "File must not be null.", new Object[0]);
        ArrayList<String> list = new ArrayList<String>();
        FileUtils.copyFile(file, list, charset);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLineNumber(File file, Charset charset) throws IOException {
        LineNumberReader reader = null;
        try {
            reader = FileUtils.getLineNumberReader(file, charset);
            reader.skip(file.length());
            int n = reader.getLineNumber();
            return n;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    public static void split(File file, int line, File output, String template) throws IOException {
        FileUtils.split(file, null, line, output, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void split(File file, Charset charset, int line, File output, String template) throws IOException {
        int rows = FileUtils.getLineNumber(file, charset);
        int count = rows % line == 0 ? rows / line : rows / line + 1;
        String extension = FileUtils.getExtension(file);
        LineNumberReader reader = null;
        try {
            reader = FileUtils.getLineNumberReader(file, charset);
            int no = 1;
            int start = 1;
            StringBuilder content = null;
            Object[] array = new Object[1];
            while (no <= count) {
                content = new StringBuilder();
                IOUtils.rangeCopyLines(reader, start, line, content);
                array[0] = no++;
                String name = StringUtils.parseText(template, "#", array) + "." + extension;
                FileUtils.writeFile(content, new File(output, name), false, charset);
                start += line;
            }
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    public static void mergeTo(File[] files, File outputFile, Charset charset) throws IOException {
        int l;
        StringBuilder content = new StringBuilder();
        int n = l = files != null ? files.length : 0;
        for (int i = 0; i < l; ++i) {
            content.append(FileUtils.readFileToString(files[i], charset));
            if (i == l - 1) continue;
            content.append(IOUtils.NEWLINE);
        }
        FileUtils.writeFile(content, outputFile, false, charset);
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        FileInputStream in = FileUtils.openInputStream(file);
        try {
            byte[] byArray = IOUtils.toByteArray(in);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readFileToCharArray(File file, Charset charset) throws IOException {
        Assert.isNull(file, "File must not be null.", new Object[0]);
        FileInputStream in = null;
        try {
            in = FileUtils.openInputStream(file);
            char[] cArray = IOUtils.toCharArray((InputStream)in, charset);
            return cArray;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(byte[] bytes, File file, boolean append) throws IOException {
        Assert.isNull(bytes, "Bytes must not be null.", new Object[0]);
        Assert.isNull(file, "Destination file must not be null.", new Object[0]);
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(bytes);
            FileUtils.writeFile(in, file, append);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(InputStream in, File file, boolean append) throws IOException {
        Assert.isNull(in, "InputStream must not be null.", new Object[0]);
        Assert.isNull(file, "Destination file must not be null.", new Object[0]);
        FileOutputStream os = null;
        try {
            os = FileUtils.openOutputStream(file, append);
            IOUtils.copy(in, (OutputStream)os);
        }
        finally {
            IOUtils.closeQuietly(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(Reader reader, File file, boolean append, Charset charset) throws IOException {
        Assert.isNull(reader, "Content must not be null.", new Object[0]);
        Assert.isNull(file, "Destination file must not be null.", new Object[0]);
        FileOutputStream fos = FileUtils.openOutputStream(file, append);
        try {
            FileUtils.writeBOM(fos, charset);
            IOUtils.copy(reader, (OutputStream)fos, charset);
        }
        finally {
            IOUtils.closeQuietly(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(char[] content, File file, boolean append, Charset charset) throws IOException {
        Assert.isNull(content, "Content must not be null.", new Object[0]);
        Assert.isNull(file, "Destination file must not be null.", new Object[0]);
        FileOutputStream fos = FileUtils.openOutputStream(file, append);
        try {
            FileUtils.writeBOM(fos, charset);
            IOUtils.copy(content, (OutputStream)fos, charset);
        }
        finally {
            IOUtils.closeQuietly(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(CharSequence content, File file, boolean append, Charset charset) throws IOException {
        Assert.isNull(content, "Content must not be null.", new Object[0]);
        Assert.isNull(file, "Destination file must not be null.", new Object[0]);
        FileOutputStream fos = FileUtils.openOutputStream(file, append);
        try {
            FileUtils.writeBOM(fos, charset);
            IOUtils.copy(content, (OutputStream)fos, charset);
        }
        finally {
            IOUtils.closeQuietly(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(Collection<String> collection, File file, boolean append, Charset charset) throws IOException {
        Assert.isNull(collection, "Content must not be null.", new Object[0]);
        Assert.isNull(file, "Destination file must not be null.", new Object[0]);
        FileOutputStream fos = FileUtils.openOutputStream(file, append);
        try {
            FileUtils.writeBOM(fos, charset);
            IOUtils.writeLines(collection, (OutputStream)fos, charset);
        }
        finally {
            IOUtils.closeQuietly(fos);
        }
    }

    public static void moveFileToDirectory(File srcFile, File destDir) throws IOException {
        Assert.isNull(srcFile, "Unspecified source file.", new Object[0]);
        Assert.isNull(destDir, "Unspecified destination directory.", new Object[0]);
        FileUtils.moveFile(srcFile, new File(destDir, srcFile.getName()));
    }

    public static void moveToDirectory(File src, File destDir, boolean createDestDir) throws IOException {
        Assert.isNull(src, "Unspecified source file.", new Object[0]);
        Assert.isNull(destDir, "Unspecified destination directory.", new Object[0]);
        if (src.isDirectory()) {
            FileUtils.moveDirectoryToDirectory(src, destDir);
        } else {
            FileUtils.moveFileToDirectory(src, destDir);
        }
    }

    public static void moveDirectory(File srcDir, File destDir) throws IOException {
        FileUtils.canScan(srcDir);
        FileUtils.canChange(destDir);
        if (destDir.getCanonicalPath().startsWith(srcDir.getCanonicalPath())) {
            throw new IOException("Cannot move directory: " + srcDir + " to a subdirectory of itself: " + destDir);
        }
        if (!srcDir.renameTo(destDir)) {
            FileUtils.copyDirectory(srcDir, destDir);
            FileUtils.deleteDirectory(srcDir);
            if (srcDir.exists()) {
                throw new IOException("Failed to delete original directory '" + srcDir + "' after copy to '" + destDir + "'");
            }
        }
    }

    public static void moveDirectoryToDirectory(File srcDir, File destDir) throws IOException {
        Assert.isNull(srcDir, "Unspecified source directory", new Object[0]);
        Assert.isNull(destDir, "Unspecified destination directory", new Object[0]);
        FileUtils.moveDirectory(srcDir, new File(destDir, srcDir.getName()));
    }

    public static void moveFile(File srcFile, File destFile) throws IOException {
        FileUtils.canRead(srcFile);
        FileUtils.canWrite(destFile);
        if (!srcFile.renameTo(destFile)) {
            FileUtils.doCopyFile(srcFile, destFile);
            if (!srcFile.delete()) {
                FileUtils.deleteFile(destFile);
                throw new IOException("Failed to delete original file '" + srcFile + "' after copy to '" + destFile + "'");
            }
        }
    }

    public static void copyFileToDirectory(File srcFile, File destDir) throws IOException {
        Assert.isNull(srcFile, "Unspecified source file.", new Object[0]);
        FileUtils.canChange(destDir);
        File destFile = new File(destDir, srcFile.getName());
        FileUtils.doCopyFile(srcFile, destFile);
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        FileUtils.canRead(srcFile);
        FileUtils.canWrite(destFile);
        if (srcFile.getCanonicalPath().equals(destFile.getCanonicalPath())) {
            throw new IOException("Source file '" + srcFile + "' and destination file '" + destFile + "' are the same.");
        }
        FileUtils.doCopyFile(srcFile, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File source, File destination) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel in = null;
        FileChannel out = null;
        try {
            fis = new FileInputStream(source);
            in = fis.getChannel();
            fos = new FileOutputStream(destination);
            out = fos.getChannel();
            long size = in.size();
            long count = 0L;
            for (long pos = 0L; pos < size; pos += out.transferFrom(in, pos, count)) {
                count = size - pos > 0x1E00000L ? 0x1E00000L : size - pos;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(fos);
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly(out);
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(fos);
        IOUtils.closeQuietly(fis);
        if (source.length() != destination.length()) {
            throw new IOException("Failed to copy full contents from '" + source + "' to '" + destination + "'.");
        }
        if (!destination.setLastModified(System.currentTimeMillis())) {
            throw new IOException("Unable to set the last modification time for " + destination);
        }
    }

    public static void copyFilesToDirectory(File[] files, File destDir) throws IOException {
        for (File file : files) {
            FileUtils.copyFileToDirectory(file, destDir);
        }
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        FileUtils.copyDirectory(srcDir, destDir, null);
    }

    public static void copyDirectory(File srcDir, File destDir, FileFilter filter) throws IOException {
        FileUtils.canScan(srcDir);
        FileUtils.canChange(destDir);
        if (srcDir.getCanonicalPath().equals(destDir.getCanonicalPath())) {
            throw new IOException("Source directory '" + srcDir + "' and destination directory '" + destDir + "' are the same.");
        }
        ArrayList<String> exclusionList = null;
        if (destDir.getCanonicalPath().startsWith(srcDir.getCanonicalPath())) {
            File[] srcFiles;
            File[] fileArray = srcFiles = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
            if (srcFiles != null) {
                exclusionList = new ArrayList<String>(srcFiles.length);
                for (File srcFile : srcFiles) {
                    File copiedFile = new File(destDir, srcFile.getName());
                    exclusionList.add(copiedFile.getCanonicalPath());
                }
            }
        }
        FileUtils.doCopyDirectory(srcDir, destDir, filter, exclusionList);
    }

    private static void doCopyDirectory(File srcDir, File destDir, FileFilter filter, List<String> exclusionList) throws IOException {
        File[] srcFiles;
        File[] fileArray = srcFiles = filter == null ? srcDir.listFiles() : srcDir.listFiles(filter);
        if (srcFiles == null) {
            return;
        }
        for (File srcFile : srcFiles) {
            File destFile = new File(destDir, srcFile.getName());
            if (exclusionList != null && exclusionList.contains(srcFile.getCanonicalPath())) continue;
            if (srcFile.isDirectory()) {
                FileUtils.doCopyDirectory(srcFile, destFile, filter, exclusionList);
                continue;
            }
            FileUtils.doCopyFile(srcFile, destFile);
        }
        if (!destDir.setLastModified(System.currentTimeMillis())) {
            throw new IOException("Unable to set the last modification time for " + destDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyFile(File input, OutputStream output) throws IOException {
        FileInputStream fis = FileUtils.openInputStream(input);
        try {
            long l = IOUtils.copy(fis, output);
            return l;
        }
        finally {
            IOUtils.closeQuietly(fis);
        }
    }

    public static void copyFile(File file, Writer writer) throws IOException {
        FileUtils.copyFile(file, writer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, Writer writer, String charset) throws IOException {
        FileInputStream fis = FileUtils.openInputStream(file);
        try {
            IOUtils.copy((InputStream)fis, writer, CharsetUtils.toCharset(charset));
        }
        finally {
            IOUtils.closeQuietly(fis);
        }
    }

    public static void copyFile(File file, List<String> collection) throws IOException {
        FileUtils.copyFile(file, collection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, List<String> collection, Charset charset) throws IOException {
        FileInputStream in = FileUtils.openInputStream(file);
        try {
            IOUtils.copyLines((InputStream)in, charset, collection);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyFile(File file, StringBuilder str, Charset charset) throws IOException {
        FileInputStream in = FileUtils.openInputStream(file);
        try {
            int n = IOUtils.copyLines((InputStream)in, charset, str);
            return n;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyFile(File file, StringBuffer str, Charset charset) throws IOException {
        FileInputStream in = FileUtils.openInputStream(file);
        try {
            int n = IOUtils.copyLines((InputStream)in, charset, str);
            return n;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static void clearFile(File file, Charset charset) throws IOException {
        FileUtils.writeFile("", file, false, charset);
    }

    public static List<String> list(File directory, FileFilter filter) throws IOException {
        List<File> files = FileUtils.listFiles(directory, filter);
        return files.stream().map(file -> file.getAbsolutePath()).collect(Collectors.toList());
    }

    public static List<File> listFiles(File directory, FileFilter filter) throws IOException {
        FileAssert.isNotDirectory(directory);
        Object[] fileArray = filter != null ? directory.listFiles(filter) : directory.listFiles();
        ArrayList<File> directories = new ArrayList<File>();
        if (ArrayUtils.isNotEmpty(fileArray)) {
            ArrayList<Object> files = new ArrayList<Object>();
            for (Object file : fileArray) {
                if (((File)file).isDirectory()) {
                    directories.add((File)file);
                    continue;
                }
                if (!((File)file).isFile()) continue;
                files.add(file);
            }
            directories.addAll(files);
        }
        return directories;
    }

    public static long sizeOfDirectory(File directory, FileFilter filter) throws IOException {
        AtomicLong total = new AtomicLong();
        FileUtils.scan(directory, filter, (dir, file) -> total.addAndGet(file.length()));
        return total.get();
    }

    public static void scan(File directory, FileFilter filter, ScanHandler handler) throws IOException {
        Object[] files;
        FileAssert.isNotDirectory(directory);
        Object[] objectArray = files = filter != null ? directory.listFiles(filter) : directory.listFiles();
        if (ArrayUtils.isNotEmpty(files)) {
            for (Object file : files) {
                if (FileUtils.isSymlink((File)file)) continue;
                if (((File)file).isDirectory()) {
                    FileUtils.scan((File)file, filter, handler);
                    continue;
                }
                handler.handleFile(directory, (File)file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertContent(File file, int position, CharSequence content, Charset charset) throws IOException {
        FileAssert.cannotRead(file);
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        try {
            raf.seek(position);
            byte[] store = IOUtils.toByteArray(raf);
            raf.write(content.toString().getBytes(CharsetUtils.toCharset(charset)));
            raf.write(store);
        }
        finally {
            IOUtils.closeQuietly(raf);
        }
    }
}

