/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.io.FileUtils;
import com.github.paganini2008.devtools.io.IOUtils;
import com.github.paganini2008.devtools.net.Urls;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public abstract class ImageUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fade(File file, String format, File output) throws IOException {
        Assert.isNull(file, "Undefined image source.", new Object[0]);
        Assert.isNull(file, "Undefined output file.", new Object[0]);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            ImageUtils.fade(in, format, output);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fade(URL src, String format, File output) throws IOException {
        Assert.isNull(src, "Undefined image source.", new Object[0]);
        InputStream in = null;
        try {
            in = Urls.openStream(src);
            ImageUtils.fade(in, format, output);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static void fade(byte[] src, String format, File output) throws IOException {
        Assert.isNull(src, "Undefined image source.", new Object[0]);
        ImageUtils.fade(new ByteArrayInputStream(src), format, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fade(InputStream src, String format, File output) throws IOException {
        Assert.isNull(src, "Undefined image source.", new Object[0]);
        FileOutputStream fileOutput = null;
        try {
            fileOutput = new FileOutputStream(output);
            ImageUtils.fade(ImageIO.read(src), format, fileOutput);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutput);
            throw throwable;
        }
        IOUtils.closeQuietly(fileOutput);
    }

    public static void fade(BufferedImage src, String format, OutputStream output) throws IOException {
        Assert.isNull(src, "Undefined image source.", new Object[0]);
        Assert.isNull(output, "Undefined output source.", new Object[0]);
        ColorSpace cs = ColorSpace.getInstance(1003);
        ColorConvertOp op = new ColorConvertOp(cs, null);
        src = op.filter(src, null);
        ImageIO.write((RenderedImage)src, format, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(File file, String type) throws IOException {
        byte[] byArray;
        Assert.isNull(file, "Unspecified image file.", new Object[0]);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byArray = ImageUtils.toByteArray(in, type);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        return byArray;
    }

    public static byte[] toByteArray(BufferedImage src, String type) throws IOException {
        Assert.isNull(src, "Unspecified image source.", new Object[0]);
        Assert.hasNoText(type);
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)src, type.toLowerCase(), bos);
        }
        finally {
            IOUtils.closeQuietly(bos);
        }
        return bos.toByteArray();
    }

    public static byte[] toByteArray(InputStream src, String type) throws IOException {
        Assert.isNull(src, "Unspecified image source.", new Object[0]);
        return ImageUtils.toByteArray(ImageIO.read(src), type);
    }

    public static byte[] toByteArray(URL url, String type) throws IOException {
        Assert.isNull(url, "Unspecified image source.", new Object[0]);
        try {
            return ImageUtils.toByteArray(url.openStream(), type);
        }
        catch (IOException e) {
            throw new IOException("Failed to the byte array.", e);
        }
    }

    public static String encode(BufferedImage src, String type) throws IOException {
        byte[] bytes = ImageUtils.toByteArray(src, type);
        BASE64Encoder encoder = new BASE64Encoder();
        String img = encoder.encode(bytes);
        img = "data:image/" + type.toLowerCase() + ";base64," + img;
        return img;
    }

    public static String encode(InputStream src, String type) throws IOException {
        Assert.isNull(src, "Unspecified image source.", new Object[0]);
        try {
            return ImageUtils.encode(ImageIO.read(src), type);
        }
        catch (IOException e) {
            throw new IOException("Failed to encode.", e);
        }
    }

    public static String encode(URL src, String type) throws IOException {
        Assert.isNull(src, "Unspecified image source.", new Object[0]);
        try {
            return ImageUtils.encode(Urls.openStream(src), type);
        }
        catch (IOException e) {
            throw new IOException("Failed to encode.", e);
        }
    }

    public static String encode(File file, String type) throws IOException {
        Assert.isNull(file, "Unspecified image source.", new Object[0]);
        FileInputStream in = null;
        try {
            in = FileUtils.openInputStream(file);
            String string = ImageUtils.encode(in, type);
            return string;
        }
        catch (IOException e) {
            throw new IOException("Failed to encode image file by path: " + file, e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static void decode(String code, OutputStream output) throws IOException {
        Assert.isNull(code, "Unspecified image source.", new Object[0]);
        Assert.isNull(output, "Unspecified output file.", new Object[0]);
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] b = decoder.decodeBuffer(code);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            output.write(b);
        }
        catch (IOException e) {
            throw new IOException("Failed to decode image.", e);
        }
    }

    public static void decode(String code, File output) throws IOException {
        Assert.isNull(code, "Unspecified image source.", new Object[0]);
        Assert.isNull(output, "Unspecified output file.", new Object[0]);
        FileOutputStream fos = null;
        try {
            fos = FileUtils.openOutputStream(output);
            ImageUtils.decode(code, fos);
        }
        finally {
            IOUtils.closeQuietly(fos);
        }
    }
}

