/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.collection.ReadonlyProperties;
import com.github.paganini2008.devtools.collection.RefreshingProperties;
import com.github.paganini2008.devtools.multithreads.Executable;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.TimeUnit;

public class RealtimeRefreshingProperties
extends ReadonlyProperties
implements Executable {
    private static final long serialVersionUID = 4232794532546686597L;
    private final RefreshingProperties delegate;
    private final int interval;
    private Timer timer;

    RealtimeRefreshingProperties(RefreshingProperties delegate, int interval) {
        this.delegate = delegate;
        this.interval = interval;
    }

    public synchronized void start() {
        if (this.timer == null) {
            this.timer = ThreadUtils.scheduleAtFixedRate((Executable)this, (long)this.interval, TimeUnit.SECONDS);
        }
    }

    public synchronized void close() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Override
    public boolean execute() {
        try {
            this.delegate.refresh();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public void store(Writer writer, String comments) throws IOException {
        this.delegate.store(writer, comments);
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        this.delegate.store(out, comments);
    }

    @Override
    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.delegate.storeToXML(os, comment);
    }

    @Override
    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        this.delegate.storeToXML(os, comment, encoding);
    }

    @Override
    public String getProperty(String key) {
        return this.delegate.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.delegate.getProperty(key, defaultValue);
    }

    @Override
    public Enumeration<?> propertyNames() {
        return this.delegate.propertyNames();
    }

    @Override
    public Set<String> stringPropertyNames() {
        return this.delegate.stringPropertyNames();
    }

    @Override
    public void list(PrintStream out) {
        this.delegate.list(out);
    }

    @Override
    public void list(PrintWriter out) {
        this.delegate.list(out);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

