/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.io.ClassPathResource;
import com.github.paganini2008.devtools.io.FileSystemResource;
import com.github.paganini2008.devtools.io.Resource;
import com.github.paganini2008.devtools.io.ResourceBundleResource;
import java.io.File;
import java.util.Locale;

public class Resources {
    public static Resource openFromClassPath(String name) throws Exception {
        ClassPathResource resource = new ClassPathResource(name);
        resource.refresh();
        return resource;
    }

    public static Resource openFromClassPath(String name, int refreshInterval) throws Exception {
        ClassPathResource resource = new ClassPathResource(name);
        resource.refresh();
        return resource.refresh(refreshInterval);
    }

    public static Resource openBundle(String name, Locale locale) throws Exception {
        ResourceBundleResource resource = new ResourceBundleResource(name, locale);
        resource.refresh();
        return resource;
    }

    public static Resource openBundle(String name, Locale locale, int refreshInterval) throws Exception {
        ResourceBundleResource resource = new ResourceBundleResource(name, locale);
        resource.refresh();
        return resource.refresh(refreshInterval);
    }

    public static Resource openFromFileSystem(File file) throws Exception {
        FileSystemResource resource = new FileSystemResource(file);
        resource.refresh();
        return resource;
    }

    public static Resource openFromFileSystem(File file, int refreshInterval) throws Exception {
        FileSystemResource resource = new FileSystemResource(file);
        resource.refresh();
        return resource.refresh(refreshInterval);
    }

    private Resources() {
    }
}

