/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io.filter;

import com.github.paganini2008.devtools.io.filter.LogicalFileFilter;
import com.github.paganini2008.devtools.io.filter.Operator;
import java.io.File;

public class FileSizeFileFilter
extends LogicalFileFilter {
    private final int size;
    private final Operator operator;

    public FileSizeFileFilter(int size, Operator operator) {
        this.size = size;
        this.operator = operator;
    }

    @Override
    public boolean accept(File file) {
        String[] names = file.list();
        int l = names != null ? names.length : 0;
        switch (this.operator) {
            case LT: {
                return l < this.size;
            }
            case GT: {
                return l > this.size;
            }
            case LTE: {
                return l <= this.size;
            }
            case GTE: {
                return l >= this.size;
            }
            case EQ: {
                return l == this.size;
            }
            case NE: {
                return l != this.size;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static FileSizeFileFilter eq(int size) {
        return new FileSizeFileFilter(size, Operator.EQ);
    }

    public static FileSizeFileFilter ne(int size) {
        return new FileSizeFileFilter(size, Operator.NE);
    }

    public static FileSizeFileFilter gte(int size) {
        return new FileSizeFileFilter(size, Operator.GTE);
    }

    public static FileSizeFileFilter gt(int size) {
        return new FileSizeFileFilter(size, Operator.GT);
    }

    public static FileSizeFileFilter lte(int size) {
        return new FileSizeFileFilter(size, Operator.LTE);
    }

    public static FileSizeFileFilter lt(int size) {
        return new FileSizeFileFilter(size, Operator.LT);
    }
}

