/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io.filter;

import com.github.paganini2008.devtools.io.PathUtils;
import com.github.paganini2008.devtools.io.filter.LogicalFileFilter;
import java.io.File;

public class MatchNameFileFilter
extends LogicalFileFilter {
    private final String substr;
    private final MatchMode matchMode;

    public MatchNameFileFilter(String substr, MatchMode matchMode) {
        this.substr = substr;
        this.matchMode = matchMode;
    }

    @Override
    public boolean accept(File file, String name) {
        String baseName = PathUtils.getBaseName(name);
        return this.matchMode.matches(baseName, this.substr);
    }

    public static enum MatchMode {
        START{

            @Override
            boolean matches(String left, String right) {
                return left.startsWith(right);
            }
        }
        ,
        END{

            @Override
            boolean matches(String left, String right) {
                return left.endsWith(right);
            }
        }
        ,
        ANY_WHERE{

            @Override
            boolean matches(String left, String right) {
                return left.contains(right);
            }
        }
        ,
        REGEX{

            @Override
            boolean matches(String left, String right) {
                return left.matches(right);
            }
        };


        abstract boolean matches(String var1, String var2);
    }
}

