/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.jdbc;

import com.github.paganini2008.devtools.CaseFormats;
import com.github.paganini2008.devtools.Observable;
import com.github.paganini2008.devtools.Observer;
import com.github.paganini2008.devtools.collection.CollectionUtils;
import com.github.paganini2008.devtools.collection.Tuple;
import com.github.paganini2008.devtools.converter.ConvertUtils;
import com.github.paganini2008.devtools.jdbc.ConnectionFactory;
import com.github.paganini2008.devtools.jdbc.Cursor;
import com.github.paganini2008.devtools.jdbc.DefaultPageableSql;
import com.github.paganini2008.devtools.jdbc.DetachedSqlException;
import com.github.paganini2008.devtools.jdbc.PageResponse;
import com.github.paganini2008.devtools.jdbc.PageableQuery;
import com.github.paganini2008.devtools.jdbc.PageableQueryImpl;
import com.github.paganini2008.devtools.jdbc.PageableSql;
import com.github.paganini2008.devtools.jdbc.PooledConnectionFactory;
import com.github.paganini2008.devtools.jdbc.PreparedStatementCallback;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.sql.DataSource;

public abstract class JdbcUtils {
    public static void close(Connection connection) throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    public static void close(ResultSet rs) throws SQLException {
        if (rs != null) {
            rs.close();
        }
    }

    public static void close(Statement stmt) throws SQLException {
        if (stmt != null) {
            stmt.close();
        }
    }

    public static void closeQuietly(Connection connection) {
        try {
            JdbcUtils.close(connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ResultSet rs) {
        try {
            JdbcUtils.close(rs);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Statement stmt) {
        try {
            JdbcUtils.close(stmt);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void commit(Connection connection) throws SQLException {
        if (connection != null) {
            connection.commit();
        }
    }

    public static void commitQuietly(Connection connection) {
        try {
            JdbcUtils.commit(connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void commitAndClose(Connection connection) throws SQLException {
        if (connection != null) {
            try {
                connection.commit();
            }
            finally {
                connection.close();
            }
        }
    }

    public static void commitAndCloseQuietly(Connection connection) {
        try {
            JdbcUtils.commitAndClose(connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void rollback(Connection connection) throws SQLException {
        if (connection != null) {
            connection.rollback();
        }
    }

    public static void rollbackQuietly(Connection connection) {
        try {
            JdbcUtils.rollback(connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void rollbackAndClose(Connection connection) throws SQLException {
        if (connection != null) {
            try {
                connection.rollback();
            }
            finally {
                connection.close();
            }
        }
    }

    public static void rollbackAndCloseQuietly(Connection connection) {
        try {
            JdbcUtils.rollbackAndClose(connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void printStackTrace(SQLException e) {
        JdbcUtils.printStackTrace(e, new PrintWriter(System.err));
    }

    public static void printStackTrace(SQLException e, PrintWriter pw) {
        SQLException next = e;
        while (next != null) {
            next.printStackTrace(pw);
            if ((next = next.getNextException()) == null) continue;
            pw.println("Next SQLException:");
        }
    }

    public static void printWarnings(Connection connection) {
        JdbcUtils.printWarnings(connection, new PrintWriter(System.err));
    }

    public static void printWarnings(Connection connection, PrintWriter pw) {
        if (connection != null) {
            try {
                JdbcUtils.printStackTrace(connection.getWarnings(), pw);
            }
            catch (SQLException e) {
                JdbcUtils.printStackTrace(e, pw);
            }
        }
    }

    public static Connection getConnection(String url, String user, String password) throws SQLException {
        return DriverManager.getConnection(url, user, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int update(Connection connection, String sql) throws SQLException {
        Statement stm = null;
        try {
            stm = connection.createStatement();
            int n = stm.executeUpdate(sql);
            return n;
        }
        finally {
            JdbcUtils.closeQuietly(stm);
        }
    }

    public static int[] batchUpdate(Connection connection, String sql, List<Object[]> argsList) throws SQLException {
        return JdbcUtils.batchUpdate(connection, sql, JdbcUtils.setValues(argsList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] batchUpdate(Connection connection, String sql, PreparedStatementCallback callback) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(sql);
            if (callback != null) {
                callback.setValues(ps);
            }
            int[] nArray = ps.executeBatch();
            return nArray;
        }
        finally {
            JdbcUtils.closeQuietly(ps);
        }
    }

    public static int insert(Connection connection, String sql, Object[] args) throws SQLException {
        return JdbcUtils.insert(connection, sql, JdbcUtils.setValues(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int insert(Connection connection, String sql, PreparedStatementCallback callback) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block4: {
            int n;
            ps = null;
            rs = null;
            try {
                Object result;
                int effected;
                ps = connection.prepareStatement(sql, 1);
                if (callback != null) {
                    callback.setValues(ps);
                }
                if ((effected = ps.executeUpdate()) <= 0 || (rs = ps.getGeneratedKeys()) == null || !rs.next() || !((result = rs.getObject(1)) instanceof Number)) break block4;
                n = ((Number)result).intValue();
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(rs);
                JdbcUtils.closeQuietly(ps);
                throw throwable;
            }
            JdbcUtils.closeQuietly(rs);
            JdbcUtils.closeQuietly(ps);
            return n;
        }
        int n = 0;
        JdbcUtils.closeQuietly(rs);
        JdbcUtils.closeQuietly(ps);
        return n;
    }

    public static int update(Connection connection, String sql, Object[] args) throws SQLException {
        return JdbcUtils.update(connection, sql, JdbcUtils.setValues(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int update(Connection connection, String sql, PreparedStatementCallback callback) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(sql);
            if (callback != null) {
                callback.setValues(ps);
            }
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            JdbcUtils.closeQuietly(ps);
        }
    }

    public static <T> T fetchOne(Connection connection, String sql, Class<T> requiredType) throws SQLException {
        Tuple tuple = JdbcUtils.fetchOne(connection, sql);
        if (tuple.isEmpty()) {
            return null;
        }
        return ConvertUtils.convertValue(tuple.toValues()[0], requiredType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tuple fetchOne(Connection connection, String sql) throws SQLException {
        ResultSet rs;
        Statement ps;
        block3: {
            Tuple tuple;
            ps = null;
            rs = null;
            try {
                ps = connection.createStatement();
                rs = ps.executeQuery(sql);
                if (rs == null || !rs.next()) break block3;
                tuple = JdbcUtils.toTuple(rs);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(rs);
                JdbcUtils.closeQuietly(ps);
                throw throwable;
            }
            JdbcUtils.closeQuietly(rs);
            JdbcUtils.closeQuietly(ps);
            return tuple;
        }
        Tuple tuple = null;
        JdbcUtils.closeQuietly(rs);
        JdbcUtils.closeQuietly(ps);
        return tuple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Tuple> fetchAll(Connection connection, String sql) throws SQLException {
        ArrayList<Tuple> arrayList;
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.createStatement();
            rs = ps.executeQuery(sql);
            if (rs != null) {
                while (rs.next()) {
                    list.add(JdbcUtils.toTuple(rs));
                }
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(rs);
            JdbcUtils.closeQuietly(ps);
            throw throwable;
        }
        JdbcUtils.closeQuietly(rs);
        JdbcUtils.closeQuietly(ps);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cursor<Tuple> cursor(Connection connection, String sql) throws SQLException {
        CursorImpl cursorImpl;
        Statement sm = null;
        ResultSet rs = null;
        Observable observable = Observable.unrepeatable();
        try {
            sm = connection.createStatement(1004, 1007);
            rs = sm.executeQuery(sql);
            cursorImpl = new CursorImpl(rs, observable);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeLazily(observable, rs, sm, connection);
            throw throwable;
        }
        JdbcUtils.closeLazily(observable, rs, sm, connection);
        return cursorImpl;
    }

    public static <T> T fetchOne(Connection connection, String sql, Object[] args, Class<T> requiredType) throws SQLException {
        return JdbcUtils.fetchOne(connection, sql, JdbcUtils.setValues(args), requiredType);
    }

    public static <T> T fetchOne(Connection connection, String sql, PreparedStatementCallback callback, Class<T> requiredType) throws SQLException {
        Tuple tuple = JdbcUtils.fetchOne(connection, sql, callback);
        if (tuple == null || tuple.isEmpty()) {
            return null;
        }
        return ConvertUtils.convertValue(tuple.toValues()[0], requiredType);
    }

    public static Tuple fetchOne(Connection connection, String sql, Object[] args) throws SQLException {
        return JdbcUtils.fetchOne(connection, sql, JdbcUtils.setValues(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tuple fetchOne(Connection connection, String sql, PreparedStatementCallback callback) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block4: {
            Tuple tuple;
            ps = null;
            rs = null;
            try {
                ps = connection.prepareStatement(sql);
                if (callback != null) {
                    callback.setValues(ps);
                }
                if ((rs = ps.executeQuery()) == null || !rs.next()) break block4;
                tuple = JdbcUtils.toTuple(rs);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(rs);
                JdbcUtils.closeQuietly(ps);
                throw throwable;
            }
            JdbcUtils.closeQuietly(rs);
            JdbcUtils.closeQuietly(ps);
            return tuple;
        }
        Tuple tuple = null;
        JdbcUtils.closeQuietly(rs);
        JdbcUtils.closeQuietly(ps);
        return tuple;
    }

    public static List<Tuple> fetchAll(Connection connection, String sql, Object[] args) throws SQLException {
        return JdbcUtils.fetchAll(connection, sql, JdbcUtils.setValues(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Tuple> fetchAll(Connection connection, String sql, PreparedStatementCallback callback) throws SQLException {
        ArrayList<Tuple> arrayList;
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connection.prepareStatement(sql);
            if (callback != null) {
                callback.setValues(ps);
            }
            if ((rs = ps.executeQuery()) != null) {
                while (rs.next()) {
                    list.add(JdbcUtils.toTuple(rs));
                }
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(rs);
            JdbcUtils.closeQuietly(ps);
            throw throwable;
        }
        JdbcUtils.closeQuietly(rs);
        JdbcUtils.closeQuietly(ps);
        return arrayList;
    }

    public static Cursor<Tuple> cursor(Connection connection, String sql, Object[] args) throws SQLException {
        return JdbcUtils.cursor(connection, sql, JdbcUtils.setValues(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cursor<Tuple> cursor(Connection connection, String sql, PreparedStatementCallback callback) throws SQLException {
        CursorImpl cursorImpl;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Observable observable = Observable.unrepeatable();
        try {
            ps = connection.prepareStatement(sql, 1004, 1007);
            if (callback != null) {
                callback.setValues(ps);
            }
            rs = ps.executeQuery();
            cursorImpl = new CursorImpl(rs, observable);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeLazily(observable, rs, ps, connection);
            throw throwable;
        }
        JdbcUtils.closeLazily(observable, rs, ps, connection);
        return cursorImpl;
    }

    private static void closeLazily(Observable observable, final ResultSet rs, final Statement sm, final Connection connection) {
        observable.addObserver(new Observer(){

            @Override
            public void update(Observable ob, Object arg) {
                JdbcUtils.closeQuietly(rs);
                JdbcUtils.closeQuietly(sm);
                JdbcUtils.closeQuietly(connection);
            }
        });
    }

    private static Tuple toTuple(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        Tuple tuple = Tuple.newTuple(CaseFormats.LOWER_CAMEL);
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            String columnName = rsmd.getColumnLabel(columnIndex);
            Object value = rs.getObject(columnIndex);
            tuple.set(columnName, value);
        }
        return tuple;
    }

    public static void scan(Connection connection, String sql, Object[] args, Consumer<Tuple> consumer) throws SQLException {
        JdbcUtils.scan(connection, sql, JdbcUtils.setValues(args), consumer);
    }

    public static void scan(Connection connection, String sql, PreparedStatementCallback callback, Consumer<Tuple> consumer) throws SQLException {
        Cursor<Tuple> cursor = JdbcUtils.cursor(connection, sql, callback);
        CollectionUtils.forEach(cursor).forEach(consumer);
    }

    public static void scan(ConnectionFactory connectionFactory, PageableSql pageableSql, Object[] args, int page, int pageSize, Consumer<List<Tuple>> consumer) throws SQLException {
        JdbcUtils.scan(connectionFactory, pageableSql, JdbcUtils.setValues(args), page, pageSize, consumer);
    }

    public static void scan(ConnectionFactory connectionFactory, String sql, PreparedStatementCallback callback, int page, int pageSize, Consumer<List<Tuple>> consumer) throws SQLException {
        JdbcUtils.scan(connectionFactory, (PageableSql)new DefaultPageableSql(sql), callback, page, pageSize, consumer);
    }

    public static void scan(ConnectionFactory connectionFactory, PageableSql pageableSql, PreparedStatementCallback callback, int page, int pageSize, Consumer<List<Tuple>> consumer) throws SQLException {
        PageableQuery<Tuple> query = JdbcUtils.pageableQuery(connectionFactory, pageableSql, callback);
        for (PageResponse<Tuple> pageResponse : query.forEach(page, pageSize)) {
            consumer.accept(pageResponse.getContent());
        }
    }

    public static PageableQuery<Tuple> pageableQuery(DataSource dataSource, String sql, Object[] args) {
        return JdbcUtils.pageableQuery(dataSource, sql, JdbcUtils.setValues(args));
    }

    public static PageableQuery<Tuple> pageableQuery(DataSource dataSource, String sql, PreparedStatementCallback callback) {
        return JdbcUtils.pageableQuery(dataSource, (PageableSql)new DefaultPageableSql(sql), callback);
    }

    public static PageableQuery<Tuple> pageableQuery(DataSource dataSource, PageableSql pageableSql, Object[] args) {
        return new PageableQueryImpl(new PooledConnectionFactory(dataSource), pageableSql, JdbcUtils.setValues(args));
    }

    public static PageableQuery<Tuple> pageableQuery(DataSource dataSource, PageableSql pageableSql, PreparedStatementCallback callback) {
        return new PageableQueryImpl(new PooledConnectionFactory(dataSource), pageableSql, callback);
    }

    public static PageableQuery<Tuple> pageableQuery(ConnectionFactory connectionFactory, String sql, Object[] args) {
        return JdbcUtils.pageableQuery(connectionFactory, sql, JdbcUtils.setValues(args));
    }

    public static PageableQuery<Tuple> pageableQuery(ConnectionFactory connectionFactory, String sql, PreparedStatementCallback callback) {
        return JdbcUtils.pageableQuery(connectionFactory, (PageableSql)new DefaultPageableSql(sql), callback);
    }

    public static PageableQuery<Tuple> pageableQuery(ConnectionFactory connectionFactory, PageableSql pageableSql, Object[] args) {
        return JdbcUtils.pageableQuery(connectionFactory, pageableSql, JdbcUtils.setValues(args));
    }

    public static PageableQuery<Tuple> pageableQuery(ConnectionFactory connectionFactory, PageableSql pageableSql, PreparedStatementCallback callback) {
        return new PageableQueryImpl(connectionFactory, pageableSql, callback);
    }

    public static void setValues(PreparedStatement ps, Object[] args) throws SQLException {
        if (args != null && args.length > 0) {
            int parameterIndex = 1;
            for (Object arg : args) {
                ps.setObject(parameterIndex++, arg);
            }
        }
    }

    private static PreparedStatementCallback setValues(List<Object[]> argsList) {
        return ps -> {
            for (Object[] args : argsList) {
                if (args == null || args.length <= 0) continue;
                JdbcUtils.setValues(ps, args);
                ps.addBatch();
            }
        };
    }

    private static PreparedStatementCallback setValues(Object[] args) {
        return ps -> JdbcUtils.setValues(ps, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsTable(DatabaseMetaData dbmd, String schema, String tableName) throws SQLException {
        ResultSet rs;
        block2: {
            boolean bl;
            rs = null;
            try {
                rs = dbmd.getTables(null, schema, tableName, new String[]{"TABLE"});
                if (rs == null || !rs.next()) break block2;
                bl = tableName.equalsIgnoreCase(rs.getString("TABLE_NAME"));
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(rs);
                throw throwable;
            }
            JdbcUtils.closeQuietly(rs);
            return bl;
        }
        JdbcUtils.closeQuietly(rs);
        return false;
    }

    public static boolean existsTable(Connection connection, String schema, String tableName) throws SQLException {
        return JdbcUtils.existsTable(connection.getMetaData(), schema, tableName);
    }

    private static class CursorImpl
    implements Cursor<Tuple> {
        private final ResultSet rs;
        private final Observable observable;
        private final AtomicBoolean opened;

        CursorImpl(ResultSet rs, Observable observable) {
            this.rs = rs;
            this.observable = observable;
            this.opened = new AtomicBoolean(true);
        }

        @Override
        public boolean hasNext() {
            try {
                this.opened.set(this.rs.next());
                boolean bl = this.opened.get();
                return bl;
            }
            catch (SQLException e) {
                this.opened.set(false);
                throw new DetachedSqlException(e.getMessage(), e);
            }
            finally {
                if (!this.isOpened()) {
                    this.close();
                }
            }
        }

        @Override
        public Tuple next() {
            try {
                Tuple tuple = JdbcUtils.toTuple(this.rs);
                return tuple;
            }
            catch (SQLException e) {
                this.opened.set(false);
                throw new DetachedSqlException(e.getMessage(), e);
            }
            finally {
                if (!this.isOpened()) {
                    this.close();
                }
            }
        }

        @Override
        public int getRownum() {
            try {
                return this.rs.getRow();
            }
            catch (SQLException e) {
                throw new DetachedSqlException(e.getMessage(), e);
            }
        }

        @Override
        public void mark(int rownum) {
            try {
                this.rs.absolute(rownum);
            }
            catch (SQLException e) {
                throw new DetachedSqlException(e.getMessage(), e);
            }
        }

        @Override
        public boolean isOpened() {
            return this.opened.get();
        }

        @Override
        public void close() {
            this.observable.notifyObservers();
        }
    }
}

