/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.jdbc;

import com.github.paganini2008.devtools.collection.Tuple;
import com.github.paganini2008.devtools.jdbc.ConnectionFactory;
import com.github.paganini2008.devtools.jdbc.Cursor;
import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import com.github.paganini2008.devtools.jdbc.PageableException;
import com.github.paganini2008.devtools.jdbc.PageableQuery;
import com.github.paganini2008.devtools.jdbc.PageableResultSetSlice;
import com.github.paganini2008.devtools.jdbc.PageableSql;
import com.github.paganini2008.devtools.jdbc.PreparedStatementCallback;
import java.sql.Connection;
import java.sql.SQLException;

public class PageableQueryImpl
extends PageableResultSetSlice<Tuple>
implements PageableQuery<Tuple> {
    private final ConnectionFactory connectionFactory;
    private final PageableSql pageableSql;
    private final PreparedStatementCallback callback;

    public PageableQueryImpl(ConnectionFactory connectionFactory, PageableSql pageableSql, PreparedStatementCallback callback) {
        this.connectionFactory = connectionFactory;
        this.pageableSql = pageableSql;
        this.callback = callback;
    }

    @Override
    public int rowCount() {
        String sql = this.pageableSql.countableSql();
        Connection connection = null;
        try {
            connection = this.connectionFactory.getConnection();
            int n = JdbcUtils.fetchOne(connection, sql, this.callback, Integer.class);
            return n;
        }
        catch (SQLException e) {
            throw new PageableException(e.getMessage(), e);
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    @Override
    public Cursor<Tuple> cursor(int maxResults, int firstResult) {
        String execution = this.pageableSql.pageableSql(maxResults, firstResult);
        Connection connection = null;
        try {
            connection = this.connectionFactory.getConnection();
            return JdbcUtils.cursor(connection, execution, this.callback);
        }
        catch (SQLException e) {
            throw new PageableException(e.getMessage(), e);
        }
    }
}

