/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.jdbc;

import com.github.paganini2008.devtools.beans.ToStringBuilder;
import com.github.paganini2008.devtools.jdbc.ConnectionFactory;
import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import com.github.paganini2008.devtools.jdbc.TransactionIsolationLevel;
import java.sql.Connection;
import java.sql.SQLException;

public class UnpooledConnectionFactory
implements ConnectionFactory {
    private String driverClassName;
    private String jdbcUrl;
    private String user;
    private String password;
    private Boolean autoCommit;
    private TransactionIsolationLevel transactionIsolationLevel;

    public UnpooledConnectionFactory() {
    }

    public UnpooledConnectionFactory(String driverClassName, String jdbcUrl, String user, String password) {
        this.setDriverClassName(driverClassName);
        this.setJdbcUrl(jdbcUrl);
        this.setUser(user);
        this.setPassword(password);
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(driverClassName);
        }
        this.driverClassName = driverClassName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public TransactionIsolationLevel getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public void setTransactionIsolationLevel(TransactionIsolationLevel transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = JdbcUtils.getConnection(this.jdbcUrl, this.user, this.password);
        if (this.autoCommit != null) {
            connection.setAutoCommit(this.autoCommit);
        }
        if (this.transactionIsolationLevel != null) {
            connection.setTransactionIsolation(this.transactionIsolationLevel.getLevel());
        }
        return connection;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, new String[]{"connection"});
    }
}

