/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.logging;

import com.github.paganini2008.devtools.logging.DefaultLoggerFactory;
import com.github.paganini2008.devtools.logging.Levels;
import com.github.paganini2008.devtools.logging.Log;
import com.github.paganini2008.devtools.logging.LoggerFactory;
import com.github.paganini2008.devtools.logging.TokenParser;
import com.github.paganini2008.devtools.logging.VarsTokenParser;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdkLog
implements Log {
    private static LoggerFactory loggerFactory = new DefaultLoggerFactory();
    private static TokenParser tokenParser = new VarsTokenParser("{}");
    private final Logger logger;

    static void setLoggerFactory(LoggerFactory loggerFactory) {
        JdkLog.loggerFactory = loggerFactory;
    }

    public void setTokenParser(TokenParser tokenParser) {
        JdkLog.tokenParser = tokenParser;
    }

    public JdkLog(String name) {
        this.logger = loggerFactory.getLogger(name);
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    public void all() {
        this.logger.setLevel(Levels.ALL);
    }

    public void off() {
        this.logger.setLevel(Levels.OFF);
    }

    @Override
    public void fatal(Object arg) {
        this.log(Levels.FATAL, arg, null);
    }

    @Override
    public void fatal(String pattern, Object ... args) {
        this.log(Levels.FATAL, pattern, args, null);
    }

    @Override
    public void fatal(Object arg, Throwable cause) {
        this.log(Levels.FATAL, arg, cause);
    }

    @Override
    public void fatal(String pattern, Throwable cause, Object ... args) {
        this.log(Levels.FATAL, pattern, args, cause);
    }

    @Override
    public void debug(Object arg) {
        this.log(Levels.DEBUG, arg, null);
    }

    @Override
    public void debug(String pattern, Object ... args) {
        this.log(Levels.DEBUG, pattern, args, null);
    }

    @Override
    public void debug(Object arg, Throwable cause) {
        this.log(Levels.DEBUG, arg, cause);
    }

    @Override
    public void debug(String pattern, Throwable cause, Object ... args) {
        this.log(Levels.DEBUG, pattern, args, cause);
    }

    @Override
    public void error(Object arg) {
        this.log(Levels.ERROR, arg, null);
    }

    @Override
    public void error(String pattern, Object ... args) {
        this.log(Levels.ERROR, pattern, args, null);
    }

    @Override
    public void error(Object arg, Throwable cause) {
        this.log(Levels.ERROR, arg, cause);
    }

    @Override
    public void error(String pattern, Throwable cause, Object ... args) {
        this.log(Levels.ERROR, pattern, args, cause);
    }

    @Override
    public void info(Object arg) {
        this.log(Levels.INFO, arg, null);
    }

    @Override
    public void info(String pattern, Object ... args) {
        this.log(Levels.INFO, pattern, args, null);
    }

    @Override
    public void info(Object arg, Throwable cause) {
        this.log(Levels.INFO, arg, cause);
    }

    @Override
    public void info(String pattern, Throwable cause, Object ... args) {
        this.log(Levels.INFO, pattern, args, cause);
    }

    @Override
    public void warn(Object arg) {
        this.log(Levels.WARN, arg, null);
    }

    @Override
    public void warn(String pattern, Object ... args) {
        this.log(Levels.WARN, pattern, args, null);
    }

    @Override
    public void warn(Object arg, Throwable cause) {
        this.log(Levels.WARN, arg, cause);
    }

    @Override
    public void warn(String pattern, Throwable cause, Object ... args) {
        this.log(Levels.WARN, pattern, args, cause);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Levels.FATAL);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Levels.DEBUG);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Levels.ERROR);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Levels.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Levels.WARN);
    }

    private void log(Level level, Object o, Throwable e) {
        String msg = o != null ? o.toString() : "";
        this.logger.log(level, msg, e);
    }

    private void log(Level level, String pattern, Object[] args, Throwable e) {
        String msg = this.parseText(pattern, args);
        this.logger.log(level, msg, e);
    }

    public String toString() {
        return "[JdkLog] Name: " + this.getName() + ", logger: " + this.logger;
    }

    private String parseText(String pattern, Object ... args) {
        return tokenParser.parse(pattern, args);
    }
}

