/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.logging;

import java.util.logging.Level;

public class Levels {
    private static final String LOGGING_LEVEL_BUNDLE = "sun.util.logging.resources.logging";
    public static final Level OFF = new Off();
    public static final Level DEBUG = new Debug();
    public static final Level INFO = new Info();
    public static final Level WARN = new Warn();
    public static final Level ERROR = new Error();
    public static final Level FATAL = new Fatal();
    public static final Level ALL = new All();

    public static Level getByName(String name) {
        if ("OFF".equalsIgnoreCase(name)) {
            return OFF;
        }
        if ("DEBUG".equalsIgnoreCase(name)) {
            return DEBUG;
        }
        if ("INFO".equalsIgnoreCase(name)) {
            return INFO;
        }
        if ("WARN".equalsIgnoreCase(name)) {
            return WARN;
        }
        if ("ERROR".equalsIgnoreCase(name)) {
            return ERROR;
        }
        if ("FATAL".equalsIgnoreCase(name)) {
            return FATAL;
        }
        if ("ALL".equalsIgnoreCase(name)) {
            return ALL;
        }
        throw new IllegalArgumentException("Unknown level name: " + name);
    }

    private Levels() {
    }

    static class All
    extends LoggingLevel {
        private static final long serialVersionUID = 1L;

        All() {
            super("ALL", Integer.MAX_VALUE);
        }
    }

    static class Fatal
    extends LoggingLevel {
        private static final long serialVersionUID = 1L;

        Fatal() {
            super("FATAL", 50000);
        }
    }

    static class Error
    extends LoggingLevel {
        private static final long serialVersionUID = 1L;

        Error() {
            super("ERROR", 40000);
        }
    }

    static class Warn
    extends LoggingLevel {
        private static final long serialVersionUID = 1L;

        Warn() {
            super("WARN", 30000);
        }
    }

    static class Info
    extends LoggingLevel {
        private static final long serialVersionUID = 1L;

        Info() {
            super("INFO", 20000);
        }
    }

    static class Debug
    extends LoggingLevel {
        private static final long serialVersionUID = 1L;

        Debug() {
            super("DEBUG", 10000);
        }
    }

    static class Off
    extends LoggingLevel {
        private static final long serialVersionUID = 1L;

        Off() {
            super("OFF", Integer.MIN_VALUE);
        }
    }

    static abstract class LoggingLevel
    extends Level
    implements Comparable<LoggingLevel> {
        private static final long serialVersionUID = 1L;
        private final int value;

        LoggingLevel(String name, int value) {
            super(name, value, Levels.LOGGING_LEVEL_BUNDLE);
            this.value = value;
        }

        @Override
        public int compareTo(LoggingLevel other) {
            return this.value - other.value;
        }
    }
}

