/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

import com.github.paganini2008.devtools.Sequence;
import com.github.paganini2008.devtools.multithreads.Action;
import com.github.paganini2008.devtools.multithreads.Promise;
import com.github.paganini2008.devtools.multithreads.RejectedExecutionHandler;
import com.github.paganini2008.devtools.multithreads.ThreadPool;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.multithreads.latch.CounterLatch;
import com.github.paganini2008.devtools.multithreads.latch.Latch;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GenericThreadPool
extends ThreadPoolExecutor
implements ThreadPool {
    private final Latch latch;
    private final long timeout;
    private final Queue<Runnable> waitQueue;
    private final AtomicInteger failedCount = new AtomicInteger(0);
    private RejectedExecutionHandler rejectedExecutionHandler;

    public GenericThreadPool(int maxPoolSize, long timeout, int queueSize, ThreadFactory threadFactory) {
        this(maxPoolSize, new CounterLatch(maxPoolSize), timeout, queueSize, threadFactory);
    }

    public GenericThreadPool(int maxPoolSize, Latch latch, long timeout, int queueSize, ThreadFactory threadFactory) {
        super(maxPoolSize, maxPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
        this.latch = latch;
        this.timeout = timeout;
        this.waitQueue = new LinkedBlockingQueue<Runnable>(queueSize);
    }

    @Override
    public boolean apply(Runnable task) {
        boolean acquired;
        boolean bl = this.timeout > 0L ? this.latch.acquire(this.timeout, TimeUnit.MILLISECONDS) : (acquired = this.timeout == 0L ? this.latch.tryAcquire() : this.latch.acquire());
        if (acquired) {
            super.execute(task);
        } else {
            try {
                this.waitQueue.add(task);
            }
            catch (RuntimeException e) {
                if (this.rejectedExecutionHandler != null) {
                    this.rejectedExecutionHandler.handleRejectedExecution(task, this);
                }
                throw new IllegalStateException("WaitQueue Full!");
            }
        }
        return acquired;
    }

    @Override
    public <R> Promise<R> submit(Action<R> action) {
        Reference reference = new Reference();
        Future<Object> future = super.submit(() -> action.execute());
        this.apply(new ActionFutureTask<Object>(future, action, reference, this));
        return new DefaultPromise(reference);
    }

    @Override
    public int getMaxPoolSize() {
        return this.getMaximumPoolSize();
    }

    @Override
    public int getQueueSize() {
        return this.waitQueue.size();
    }

    @Override
    public int getActiveThreadSize() {
        return this.getActiveCount();
    }

    @Override
    public int getIdleThreadSize() {
        return this.getMaxPoolSize() - this.getActiveThreadSize();
    }

    @Override
    public long getFailedTaskCount() {
        return this.failedCount.get();
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    @Override
    public void execute(Runnable command) {
        this.apply(command);
    }

    @Override
    protected final void afterExecute(Runnable runnable, Throwable e) {
        Runnable prev;
        super.afterExecute(runnable, e);
        this.latch.release();
        if (e != null) {
            this.failedCount.incrementAndGet();
        }
        if ((prev = this.waitQueue.poll()) != null) {
            this.execute(prev);
        }
    }

    @Override
    public void shutdown() {
        this.latch.join();
        super.shutdown();
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[GenericThreadPool]: ");
        str.append(", maxPoolSize=").append(this.getMaxPoolSize());
        str.append(", activeThreadSize=").append(this.getActiveThreadSize());
        str.append(", idleThreadSize=").append(this.getIdleThreadSize());
        str.append(", completedTaskCount=").append(this.getCompletedTaskCount());
        str.append(", failedTaskCount=").append(this.getFailedTaskCount());
        str.append(", queueSize=").append(this.getQueueSize());
        return str.toString();
    }

    public static void main(String[] args) throws IOException {
        GenericThreadPool threadPool = new GenericThreadPool(10, 1000L, Integer.MAX_VALUE, Executors.defaultThreadFactory());
        CopyOnWriteArrayList<Promise<Long>> promises = new CopyOnWriteArrayList<Promise<Long>>();
        for (final int n : Sequence.forEach(0, 100)) {
            Promise<Long> p = threadPool.submit(new Action<Long>(){

                @Override
                public Long execute() throws Exception {
                    ThreadUtils.randomSleep(1000L);
                    System.out.println(ThreadUtils.currentThreadName() + " say: " + n);
                    return new Long(n);
                }

                @Override
                public boolean shouldReact(Long result) {
                    return false;
                }
            });
            promises.add(p);
        }
        for (Promise promise : promises) {
            System.out.println("***: " + promise.get());
        }
        System.in.read();
        threadPool.shutdown();
        System.out.println("SimpleThreadPool.main()");
    }

    static class ActionFutureTask<R>
    implements Runnable {
        final Map<Action<R>, R> results = new HashMap<Action<R>, R>();
        final Future<R> delegate;
        final Action<R> action;
        final Reference<R> reference;
        final ThreadPool threadPool;

        ActionFutureTask(Future<R> delegate, Action<R> action, Reference<R> reference, ThreadPool threadPool) {
            this.delegate = delegate;
            this.action = action;
            this.reference = reference;
            this.threadPool = threadPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object result;
            block9: {
                result = null;
                if (this.results.containsKey(this.action)) {
                    result = this.action.onReaction(this.results.remove(this.action), this.threadPool);
                } else {
                    try {
                        result = this.delegate.get();
                    }
                    catch (Exception e) {
                        if (!(e instanceof ExecutionException)) break block9;
                        this.action.onFailure(e, this.threadPool);
                    }
                }
            }
            if (this.action.shouldReact(result)) {
                this.results.put(this.action, result);
                this.reference.set(result);
                this.threadPool.apply(this);
            } else {
                Reference<R> reference = this.reference;
                synchronized (reference) {
                    this.reference.set(result);
                    this.reference.notifyAll();
                    this.reference.setDone(true);
                }
            }
        }
    }

    static class Reference<R> {
        R result;
        volatile boolean done;

        Reference() {
        }

        public R get() {
            return this.result;
        }

        public void set(R result) {
            this.result = result;
        }

        public boolean isDone() {
            return this.done;
        }

        public void setDone(boolean done) {
            this.done = done;
        }
    }

    static class DefaultPromise<R>
    implements Promise<R> {
        final Reference<R> reference;
        final long startTime;
        volatile boolean cancelled;
        volatile boolean done;

        DefaultPromise(Reference<R> reference) {
            this.reference = reference;
            this.startTime = System.currentTimeMillis();
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done || this.cancelled;
        }

        @Override
        public long getElapsed() {
            return System.currentTimeMillis() - this.startTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public R get() {
            while (!this.isDone()) {
                Reference<R> reference = this.reference;
                synchronized (reference) {
                    if (!this.reference.isDone()) {
                        try {
                            this.reference.wait();
                        }
                        catch (InterruptedException ignored) {
                            break;
                        }
                    }
                }
                this.done = this.reference.isDone();
            }
            return this.reference.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public R get(long timeout) {
            if (!this.isDone()) {
                Reference<R> reference = this.reference;
                synchronized (reference) {
                    if (!this.reference.isDone()) {
                        try {
                            this.reference.wait(timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.done = this.reference.isDone();
            return this.reference.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            if (!this.isDone()) {
                this.cancelled = true;
                Reference<R> reference = this.reference;
                synchronized (reference) {
                    this.reference.notifyAll();
                }
            }
        }
    }
}

