/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

public class ThreadLocalLong
extends Number {
    private static final long serialVersionUID = 1107286858663072809L;
    private final ThreadLocal<Long> threadLocal;

    public ThreadLocalLong() {
        this(0L);
    }

    public ThreadLocalLong(final long value) {
        this.threadLocal = new ThreadLocal<Long>(){

            @Override
            protected Long initialValue() {
                return value;
            }
        };
    }

    public long getAndDecrement() {
        return this.getAndAdd(-1L);
    }

    public long getAndIncrement() {
        return this.getAndAdd(1L);
    }

    public long getAndAdd(long delta) {
        long prev = this.get();
        this.threadLocal.set(prev + delta);
        return prev;
    }

    public long decrementAndGet() {
        return this.addAndGet(-1L);
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public long addAndGet(long delta) {
        long prev = this.get();
        this.threadLocal.set(prev + delta);
        return this.threadLocal.get();
    }

    public void reset() {
        this.threadLocal.remove();
    }

    public void set(long delta) {
        this.threadLocal.set(delta);
    }

    public long get() {
        return this.threadLocal.get();
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

