/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads.latch;

import com.github.paganini2008.devtools.multithreads.latch.Latch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class NoopLatch
implements Latch {
    private final long startTime = System.currentTimeMillis();

    @Override
    public long cons() {
        return 0L;
    }

    @Override
    public long availablePermits() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean acquire() {
        return true;
    }

    @Override
    public boolean tryAcquire() {
        return true;
    }

    @Override
    public boolean acquire(long timeout, TimeUnit timeUnit) {
        return true;
    }

    @Override
    public void release() {
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public long join() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public <E> void forEach(Iterable<E> iterable, Executor executor, Consumer<E> consumer) {
        throw new UnsupportedOperationException();
    }
}

