/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.net;

import com.github.paganini2008.devtools.RandomUtils;
import com.github.paganini2008.devtools.regex.RegexUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Pattern;

public abstract class NetUtils {
    public static final String LOCALHOST = "127.0.0.1";
    public static final String ANYHOST = "0.0.0.0";
    public static final int MIN_PORT = 5001;
    public static final int MAX_PORT = 65535;
    private static final int RANDOM_PORT_TRY_TIMES = 10;
    private static final Pattern ADDRESS_PATTERN = RegexUtils.ADDRESS_PATTERN;
    private static final Pattern LOCAL_IP_PATTERN = RegexUtils.LOCAL_IP_PATTERN;
    private static final Pattern IP_PATTERN = RegexUtils.IP_PATTERN;

    public static boolean isValidPort(int port) {
        return port > 5001 && port <= 65535;
    }

    public static boolean isValidAddress(String address) {
        return ADDRESS_PATTERN.matcher(address).matches();
    }

    public static boolean isLocalHost(String host) {
        return host != null && (LOCAL_IP_PATTERN.matcher(host).matches() || host.equalsIgnoreCase("localhost"));
    }

    public static boolean isAnyHost(String host) {
        return ANYHOST.equals(host);
    }

    private static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANYHOST.equals(name) && !LOCALHOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }

    public static String getHostName() {
        return NetUtils.getHostName(NetUtils.getLocalHost());
    }

    public static String getLocalHost() {
        InetAddress address = NetUtils.getLocalAddress();
        return address == null ? LOCALHOST : address.getHostAddress();
    }

    public static InetAddress getLocalAddress() {
        Enumeration<NetworkInterface> interfaces;
        InetAddress localAddress;
        try {
            localAddress = InetAddress.getLocalHost();
            if (NetUtils.isValidAddress(localAddress)) {
                return localAddress;
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface network = interfaces.nextElement();
                Enumeration<InetAddress> addresses = network.getInetAddresses();
                if (addresses == null) continue;
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!NetUtils.isValidAddress(address)) continue;
                    return address;
                }
            }
        }
        return localAddress;
    }

    public static String getHostName(String address) {
        try {
            InetAddress inetAddress;
            int i = address.indexOf(58);
            if (i > 0) {
                address = address.substring(0, i);
            }
            if ((inetAddress = InetAddress.getByName(address)) != null) {
                return inetAddress.getHostName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return address;
    }

    public static String toAddressString(InetSocketAddress address) {
        if (address != null) {
            return address.getAddress().getHostAddress() + ":" + address.getPort();
        }
        return "";
    }

    public static InetSocketAddress toAddress(String address) {
        int port;
        String host;
        int i = address.indexOf(58);
        if (i > 0) {
            host = address.substring(0, i);
            port = Integer.parseInt(address.substring(i + 1));
        } else {
            host = address;
            port = 0;
        }
        return new InetSocketAddress(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAvailablePort() {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket();
            ss.bind(null);
            int n = ss.getLocalPort();
            return n;
        }
        catch (IOException e) {
            int n = NetUtils.getRandomPort();
            return n;
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAvailablePort(int port) {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(port);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int getAvailablePort(int from, int to) {
        int i;
        from = Math.max(5001, from);
        to = Math.min(65535, to);
        for (i = from; i < to && !NetUtils.isAvailablePort(i); ++i) {
        }
        return i;
    }

    public static int getRandomPort() {
        return NetUtils.getRandomPort(5001, 65535);
    }

    public static int getRandomPort(int from, int to) {
        int port;
        int i = 0;
        from = Math.max(5001, from);
        to = Math.min(65535, to);
        while (!NetUtils.isAvailablePort(port = RandomUtils.randomInt(from, to)) && i++ < 10) {
        }
        return port;
    }

    public static void main(String[] args) {
        System.out.println(NetUtils.getLocalHost());
    }
}

