/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.net;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.CharsetUtils;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.io.FileUtils;
import com.github.paganini2008.devtools.io.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class Urls {
    private static SSLSocketFactory sslSocketFactory;

    public static URI toURI(String url) {
        try {
            return Urls.toURL(url).toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Malformed URL: " + url, e);
        }
    }

    public static URL toURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + url, e);
        }
    }

    public static URI toURI(URL baseUrl, String url) {
        try {
            return Urls.toURL(baseUrl, url).toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Malformed URL: " + baseUrl, e);
        }
    }

    public static URL toURL(URL baseUrl, String url) {
        Assert.isNull(baseUrl, "Base url must not be null.", new Object[0]);
        try {
            return new URL(baseUrl, url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + baseUrl, e);
        }
    }

    public static URI toURI(URL baseUrl, String[] names) {
        try {
            return Urls.toURL(baseUrl, names).toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Malformed URL: " + baseUrl, e);
        }
    }

    public static URL toURL(URL baseUrl, String[] names) {
        String path = Urls.toPath(names);
        return Urls.toURL(baseUrl, path);
    }

    public static URL toHostUrl(String url) {
        return Urls.toHostUrl(Urls.toURL(url));
    }

    public static URL toHostUrl(URL url) {
        Assert.isNull(url, "Base url must not be null.", new Object[0]);
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), "");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + url.toString(), e);
        }
    }

    private static String toPath(String[] names) {
        Assert.isNull(names, "Names must not be null.", new Object[0]);
        StringBuilder path = new StringBuilder();
        int l = names.length;
        for (int i = 0; i < l; ++i) {
            path.append(names[i]);
            if (i == l - 1) continue;
            path.append("/");
        }
        return path.toString();
    }

    public static Map<String, String> getQueryMap(URL url) {
        Assert.isNull(url, "Base url must not be null.", new Object[0]);
        String str = url.getQuery();
        return StringUtils.isNotBlank(str) ? StringUtils.splitAsMap((CharSequence)str, "&", "=") : null;
    }

    public static String serialize(Map<String, ?> kwargs) {
        return MapUtils.join(kwargs, "=", "&");
    }

    public static String toString(String url, String charset) throws IOException {
        return Urls.toString(Urls.toURL(url), charset);
    }

    public static String toString(URL url, String charset) throws IOException {
        return Urls.toString(url, CharsetUtils.toCharset(charset));
    }

    public static String toString(URL url, Charset charset) throws IOException {
        return IOUtils.toString(Urls.openStream(url), charset);
    }

    public static String toString(URLConnection url, Charset charset) throws IOException {
        return IOUtils.toString(Urls.openStream(url), charset);
    }

    public static String toString(URLConnection url, String charset) throws IOException {
        return Urls.toString(url, CharsetUtils.toCharset(charset));
    }

    public static char[] toCharArray(String url, String charset) throws IOException {
        return Urls.toCharArray(Urls.toURL(url), charset);
    }

    public static char[] toCharArray(URL url, String charset) throws IOException {
        return Urls.toCharArray(url, CharsetUtils.toCharset(charset));
    }

    public static char[] toCharArray(String url, Charset charset) throws IOException {
        return Urls.toCharArray(Urls.toURL(url), charset);
    }

    public static char[] toCharArray(URL url, Charset charset) throws IOException {
        return IOUtils.toCharArray(Urls.openStream(url), charset);
    }

    public static char[] toCharArray(URLConnection url, String charset) throws IOException {
        return Urls.toCharArray(url, CharsetUtils.toCharset(charset));
    }

    public static char[] toCharArray(URLConnection url, Charset charset) throws IOException {
        return IOUtils.toCharArray(Urls.openStream(url), charset);
    }

    public static byte[] toByteArray(String url) throws IOException {
        return Urls.toByteArray(Urls.toURL(url));
    }

    public static byte[] toByteArray(URL url) throws IOException {
        return IOUtils.toByteArray(Urls.openStream(url));
    }

    public static byte[] toByteArray(URLConnection conn) throws IOException {
        return IOUtils.toByteArray(Urls.openStream(conn));
    }

    public static InputStream openStream(String url) throws IOException {
        Assert.hasNoText(url);
        return Urls.openStream(Urls.toURL(url));
    }

    public static InputStream openStream(URL url) throws IOException {
        Assert.isNull(url);
        return Urls.openStream(url.openConnection());
    }

    public static InputStream openStream(URLConnection connection) throws IOException {
        Assert.isNull(connection);
        if (connection instanceof HttpsURLConnection) {
            Urls.initUnsecuredTSL();
            ((HttpsURLConnection)connection).setSSLSocketFactory(sslSocketFactory);
            ((HttpsURLConnection)connection).setHostnameVerifier(Urls.getInsecureVerifier());
        }
        return connection.getInputStream();
    }

    public static int testConnection(String url) throws IOException {
        return Urls.testConnection(new URL(url));
    }

    public static int testConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (connection instanceof HttpsURLConnection) {
            Urls.initUnsecuredTSL();
            ((HttpsURLConnection)connection).setSSLSocketFactory(sslSocketFactory);
            ((HttpsURLConnection)connection).setHostnameVerifier(Urls.getInsecureVerifier());
        }
        connection.connect();
        return connection.getResponseCode();
    }

    private static HostnameVerifier getInsecureVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
    }

    private static synchronized void initUnsecuredTSL() throws IOException {
        if (sslSocketFactory == null) {
            sslSocketFactory = Urls.defaultSSLSocketFactory();
        }
    }

    public static SSLSocketFactory defaultSSLSocketFactory() throws IOException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Can't create unsecure trust manager.", e);
        }
        catch (KeyManagementException e) {
            throw new IOException("Can't create unsecure trust manager.", e);
        }
    }

    public static void write(String url, OutputStream os) throws IOException {
        Urls.write(Urls.toURL(url), os);
    }

    public static void write(URL url, OutputStream os) throws IOException {
        InputStream in = null;
        try {
            in = Urls.openStream(url);
            IOUtils.copy(in, os);
        }
        finally {
            IOUtils.close(in);
        }
    }

    public static void write(URLConnection url, OutputStream os) throws IOException {
        InputStream in = null;
        try {
            in = Urls.openStream(url);
            IOUtils.copy(in, os);
        }
        finally {
            IOUtils.close(in);
        }
    }

    public static void write(String url, String file) throws IOException {
        Urls.write(url, new File(file));
    }

    public static void write(String url, File file) throws IOException {
        Urls.write(Urls.toURL(url), file);
    }

    public static void write(URL url, File file) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream(file);
            Urls.write(url, (OutputStream)out);
        }
        finally {
            IOUtils.close(out);
        }
    }

    public static void write(URLConnection url, File file) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream(file);
            Urls.write(url, (OutputStream)out);
        }
        finally {
            IOUtils.close(out);
        }
    }

    public static String getCookieString(HttpURLConnection connection) {
        String name;
        Assert.isNull(connection);
        String cookie = "";
        int i = 1;
        while ((name = connection.getHeaderFieldKey(i)) != null) {
            if (name.equalsIgnoreCase("Set-Cookie")) {
                String value = connection.getHeaderField(i);
                cookie = cookie + value + ";";
            }
            ++i;
        }
        return cookie;
    }
}

