/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.primitives;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.NumberOverflowException;
import com.github.paganini2008.devtools.NumberRangeAssert;
import com.github.paganini2008.devtools.NumberUtils;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.LruMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public abstract class Longs {
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final int BYTES = 8;
    public static final long MAX_POWER_OF_TWO = 0x4000000000000000L;
    private static final LruMap<String, Long> cache = new LruMap(1024);

    public static void clearCache() {
        cache.clear();
    }

    public static long[] clone(long[] array) {
        return array != null ? (long[])array.clone() : null;
    }

    public static int length(long[] array) {
        return array != null ? array.length : 0;
    }

    public static long[][] create(int yLength, int xLength, long defaultValue) {
        long[][] array = new long[yLength][xLength];
        for (int i = 0; i < yLength; ++i) {
            array[i] = Longs.create(xLength, defaultValue);
        }
        return array;
    }

    public static long[] create(int length, long defaultValue) {
        long[] array = new long[length];
        if (defaultValue != 0L) {
            for (int i = 0; i < length; ++i) {
                array[i] = defaultValue;
            }
        }
        return array;
    }

    public static boolean isNotEmpty(long[] args) {
        return !Longs.isEmpty(args);
    }

    public static boolean isEmpty(long[] args) {
        return args != null ? args.length == 0 : true;
    }

    public static boolean notContains(long[] a, long b) {
        return !Longs.contains(a, b);
    }

    public static boolean contains(long[] a, long b) {
        return Longs.indexOf(a, b) != -1;
    }

    public static int indexOf(long[] a, long b) {
        return Longs.indexOf(a, b, 0, a.length);
    }

    public static int indexOf(long[] a, long b, int start, int end) {
        if (a == null) {
            return -1;
        }
        if (start < 0) {
            return -1;
        }
        int l = Math.min(a.length, end);
        for (int i = start; i < l; ++i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] a, long b) {
        return Longs.lastIndexOf(a, b, a.length - 1);
    }

    public static int lastIndexOf(long[] a, long b, int start) {
        if (a == null || start < 0) {
            return -1;
        }
        for (int i = Math.min(start, a.length - 1); i >= 0; --i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static long[] concat(long[] left, long[] right) {
        Assert.isNull(left, "Left array must not be null.", new Object[0]);
        Assert.isNull(right, "Right array must not be null.", new Object[0]);
        long[] longs = Longs.copy(left, 0, left.length + right.length);
        Longs.hardCopy(right, 0, longs, left.length, right.length);
        return longs;
    }

    public static long[] add(long[] array, long a) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        long[] longs = Longs.copy(array, array.length + 1);
        longs[longs.length - 1] = a;
        return longs;
    }

    public static long[] remove(long[] array, long a) {
        int index = Longs.indexOf(array, a);
        return index != -1 ? Longs.removeAt(array, index) : array;
    }

    public static long[] removeAt(long[] array, int index) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        if (index < 0) {
            index = length - Math.abs(index);
        }
        if (index >= 0 && index < length) {
            long[] target = Longs.create(length - 1, 0L);
            Longs.hardCopy(array, 0, target, 0, index);
            Longs.hardCopy(array, index + 1, target, index, length - index - 1);
            return target;
        }
        throw new ArrayIndexOutOfBoundsException("Bad index: " + index);
    }

    public static long[] copy(long[] array) {
        return Longs.copy(array, array.length);
    }

    public static long[] copy(long[] array, int length) {
        return Longs.copy(array, 0, length);
    }

    public static long[] copy(long[] array, int startIndex, int length) {
        return Longs.copy(array, startIndex, length, 0L);
    }

    public static long[] copy(long[] array, int startIndex, int length, long defaultValue) {
        long[] target = Longs.create(length, defaultValue);
        Longs.hardCopy(array, startIndex, target, 0, length);
        return target;
    }

    private static void hardCopy(long[] src, int srcFrom, long[] dest, int destFrom, int length) {
        System.arraycopy(src, srcFrom, dest, destFrom, Math.min(src.length, length));
    }

    public static Long[] toWrappers(byte[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Long[] result = new Long[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static Long[] valueOf(Number[] array) {
        return Longs.valueOf(array, null);
    }

    public static Long[] valueOf(Number[] array, Long defaultValue) {
        Long[] result = new Long[array.length];
        int i = 0;
        for (Number arg : array) {
            result[i++] = Longs.valueOf(arg, defaultValue);
        }
        return result;
    }

    public static Long[] toWrappers(char[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Long[] result = new Long[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = Longs.valueOf(Character.valueOf(value[i]));
        }
        return result;
    }

    public static Long[] toWrappers(boolean[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Long[] result = new Long[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = Longs.valueOf(value[i]);
        }
        return result;
    }

    public static Long[] valueOf(Boolean[] value) {
        return Longs.valueOf(value, null);
    }

    public static Long[] valueOf(Boolean[] value, Long defaultValue) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Long[] result = new Long[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = Longs.valueOf(value[i], defaultValue);
        }
        return result;
    }

    public static Long[] valueOf(Character[] value) {
        return Longs.valueOf(value, null);
    }

    public static Long[] valueOf(Character[] value, Long defaultValue) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Long[] result = new Long[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = Longs.valueOf(value[i], defaultValue);
        }
        return result;
    }

    public static Long[] toWrappers(short[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Long[] result = new Long[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static Long[] toWrappers(int[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Long[] result = new Long[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static Long[] toWrappers(long[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Long[] result = new Long[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static long[] toPrimitives(Byte[] array) {
        return Longs.toPrimitives(array, true);
    }

    public static long[] toPrimitives(Byte[] array, boolean thrown) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        long[] results = new long[array.length];
        int i = 0;
        for (Byte arg : array) {
            if (arg != null) {
                results[i++] = arg.longValue();
                continue;
            }
            if (!thrown) continue;
            throw new IllegalArgumentException("Null value in array. Index: " + i);
        }
        return Longs.ensureCapacity(results, i);
    }

    public static long[] toPrimitives(Short[] array) {
        return Longs.toPrimitives(array, true);
    }

    public static long[] toPrimitives(Short[] array, boolean thrown) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        long[] results = new long[array.length];
        int i = 0;
        for (Short arg : array) {
            if (arg != null) {
                results[i++] = arg.longValue();
                continue;
            }
            if (!thrown) continue;
            throw new IllegalArgumentException("Null value in array. Index: " + i);
        }
        return Longs.ensureCapacity(results, i);
    }

    public static long[] toPrimitives(Character[] array) {
        return Longs.toPrimitives(array, true);
    }

    public static long[] toPrimitives(Character[] array, boolean thrown) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        long[] results = new long[array.length];
        int i = 0;
        for (Character arg : array) {
            if (arg != null) {
                results[i++] = arg.charValue();
                continue;
            }
            if (!thrown) continue;
            throw new IllegalArgumentException("Null value in array. Index: " + i);
        }
        return Longs.ensureCapacity(results, i);
    }

    public static long[] toPrimitives(Integer[] array) {
        return Longs.toPrimitives(array, true);
    }

    public static long[] toPrimitives(Integer[] array, boolean thrown) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        long[] results = new long[array.length];
        int i = 0;
        for (Integer arg : array) {
            if (arg != null) {
                results[i++] = arg.longValue();
                continue;
            }
            if (!thrown) continue;
            throw new IllegalArgumentException("Null value in array. Index: " + i);
        }
        return Longs.ensureCapacity(results, i);
    }

    public static long[] ensureCapacity(long[] array, int index) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        if (index != length) {
            return Longs.copy(array, 0, Math.min(index, length));
        }
        return array;
    }

    public static long[] expandCapacity(long[] array, int index) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        return Longs.expandCapacity(array, index, array.length);
    }

    public static long[] expandCapacity(long[] array, int index, int size) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        return Longs.copy(array, 0, Math.max(length + size, length));
    }

    public static long max(long[] array) {
        Assert.isTrue(Longs.isEmpty(array), "Empty array.", new Object[0]);
        long max = array[0];
        for (int i = 1; i < array.length; ++i) {
            max = max >= array[i] ? max : array[i];
        }
        return max;
    }

    public static long min(long[] array) {
        Assert.isTrue(Longs.isEmpty(array), "Empty array.", new Object[0]);
        long min = array[0];
        for (int i = 1; i < array.length; ++i) {
            min = min <= array[i] ? min : array[i];
        }
        return min;
    }

    public static long sum(long[] array) {
        Assert.isTrue(Longs.isEmpty(array), "Empty array.", new Object[0]);
        long sum = array[0];
        for (int i = 1; i < array.length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public static double avg(long[] array) {
        double sum = Longs.sum(array);
        return sum / (double)array.length;
    }

    public static String toString(long[] array) {
        return "[" + Longs.join(array) + "]";
    }

    public static String join(long[] array) {
        return Longs.join(array, ",");
    }

    public static String join(long[] array, String delimiter) {
        if (Longs.isEmpty(array)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder str = new StringBuilder();
        int l = array.length;
        for (int i = 0; i < l; ++i) {
            str.append(array[i]);
            if (i == l - 1) continue;
            str.append(delimiter);
        }
        return str.toString();
    }

    public static String join(long[] left, long[] right, String delimiter) {
        return Longs.join(left, right, delimiter, delimiter);
    }

    public static String join(long[] left, long[] right, String conjunction, String delimiter) {
        if (Longs.isEmpty(left) || Longs.isEmpty(right)) {
            return "";
        }
        if (conjunction == null) {
            conjunction = "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder content = new StringBuilder();
        int l = Math.min(left.length, right.length);
        for (int i = 0; i < l; ++i) {
            content.append(left[i]).append(conjunction).append(right[i]);
            if (i == l - 1) continue;
            content.append(delimiter);
        }
        return content.toString();
    }

    public static void swap(long[] x, int a, int b) {
        long t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void sort(long[] array, int low, int high, boolean asc) {
        for (int i = low; i < high; ++i) {
            for (int j = i; j > low; --j) {
                if (!(asc ? array[j - 1] > array[j] : array[j - 1] < array[j])) continue;
                Longs.swap(array, j - 1, j);
            }
        }
    }

    public static void sort(long[] array, boolean asc) {
        if (Longs.isNotEmpty(array)) {
            long[] aux = (long[])array.clone();
            Longs.mergeSort(aux, array, 0, array.length, asc);
        }
    }

    private static void mergeSort(long[] src, long[] dest, int low, int high, boolean asc) {
        int length = high - low;
        if (length < 10) {
            Longs.sort(dest, low, high, asc);
            return;
        }
        int mid = (high + low) / 2;
        Longs.mergeSort(dest, src, low, mid, asc);
        Longs.mergeSort(dest, src, mid, high, asc);
        int i = low;
        int p = low;
        int q = mid;
        while (p < mid && q < high) {
            if (asc ? src[p] <= src[q] : src[p] > src[q]) {
                dest[i++] = src[p++];
                continue;
            }
            dest[i++] = src[q++];
        }
        while (p < mid && i < high) {
            dest[i++] = src[p++];
        }
        while (q < high && i < high) {
            dest[i++] = src[q++];
        }
    }

    public static long[] unionAll(long[] left, long[] right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        long[] total = new long[left.length + right.length];
        int i = 0;
        for (long s : left) {
            total[i++] = s;
        }
        for (long s : right) {
            total[i++] = s;
        }
        return Longs.ensureCapacity(total, i);
    }

    public static long[] union(long[] left, long[] right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        long[] total = new long[left.length + right.length];
        int i = 0;
        for (long s : left) {
            if (Longs.contains(total, s)) continue;
            total[i++] = s;
        }
        for (long s : right) {
            if (Longs.contains(total, s)) continue;
            total[i++] = s;
        }
        return Longs.ensureCapacity(total, i);
    }

    public static long[] minus(long[] left, long[] right) {
        int i;
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        long[] result = new long[right.length];
        for (i = 0; i < left.length; ++i) {
            if (Longs.contains(right, left[i])) continue;
            result[i++] = left[i];
        }
        return Longs.ensureCapacity(result, i);
    }

    public static long[] intersect(long[] left, long[] right) {
        int i;
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        long[] result = new long[right.length];
        for (i = 0; i < left.length; ++i) {
            if (!Longs.contains(right, left[i])) continue;
            result[i++] = left[i];
        }
        return Longs.ensureCapacity(result, i);
    }

    public static long[] toArray(Collection<?> collection) {
        Assert.isNull(collection, "Source collection must not be null.", new Object[0]);
        long[] array = new long[collection.size()];
        int i = 0;
        for (Object a : collection) {
            try {
                array[i++] = ((Number)a).longValue();
            }
            catch (RuntimeException runtimeException) {}
        }
        return Longs.ensureCapacity(array, i);
    }

    public static List<Long> toList(long[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        ArrayList<Long> set = new ArrayList<Long>(array.length);
        for (long a : array) {
            set.add(a);
        }
        return set;
    }

    public static void reverse(long[] src) {
        int l = src.length;
        for (int i = 0; i < l / 2; ++i) {
            long a;
            long t = src[i];
            int j = l - 1 - i;
            src[i] = a = src[j];
            src[j] = t;
        }
    }

    public static int hashCode(long arg) {
        return Long.hashCode(arg);
    }

    public static boolean deepEquals(long[] left, long[] right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        int length = left.length;
        if (length != right.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (left[i] == right[i]) continue;
            return false;
        }
        return true;
    }

    public static Long valueOf(String str) {
        return Longs.valueOf(str, null);
    }

    public static Long valueOf(String str, Long defaultValue) {
        if (StringUtils.isBlank(str)) {
            return defaultValue;
        }
        try {
            return Longs.parse(str);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static Long[] valueOf(String[] strings) {
        return Longs.valueOf(strings, null);
    }

    public static Long[] valueOf(String[] strings, Long defaultValue) {
        Assert.isNull(strings, "Source array must not be null.", new Object[0]);
        Long[] result = new Long[strings.length];
        int i = 0;
        for (String str : strings) {
            result[i++] = Longs.valueOf(str, defaultValue);
        }
        return result;
    }

    public static long[] parseMany(String[] strings) {
        return Longs.parseMany(strings, true);
    }

    public static long[] parseMany(String[] strings, boolean thrown) {
        Assert.isNull(strings, "Source array must not be null.", new Object[0]);
        long[] result = new long[strings.length];
        int i = 0;
        for (String str : strings) {
            try {
                long s = Longs.parse(str);
                result[i++] = s;
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return Longs.ensureCapacity(result, i);
    }

    public static long parse(String str) {
        Assert.hasNoText(str, "Number string must not be null.", new Object[0]);
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException numberFormatException) {
            if (NumberUtils.isHex(str)) {
                try {
                    return Long.decode(str);
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            return Longs.parseStrictly(str);
        }
    }

    private static long parseStrictly(String str) {
        Long pooled = cache.get(str);
        if (pooled == null) {
            String newStr = NumberUtils.read(str);
            if (!NumberUtils.isNumber(newStr)) {
                throw new NumberFormatException("Can not parse string for: " + str);
            }
            try {
                cache.put(str, Long.parseLong(newStr));
            }
            catch (NumberFormatException e) {
                cache.put(str, (long)Double.parseDouble(newStr));
            }
            pooled = cache.get(str);
        }
        return pooled;
    }

    public static long cast(Number value) {
        if (value instanceof BigDecimal) {
            return Longs.cast((BigDecimal)value);
        }
        if (value instanceof BigInteger) {
            return Longs.cast((BigInteger)value);
        }
        return value.longValue();
    }

    public static long[] casts(Number[] array) {
        return Longs.casts(array, true);
    }

    public static long[] casts(Number[] array, boolean thrown) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        long[] result = new long[array.length];
        int i = 0;
        for (Number n : array) {
            try {
                result[i++] = Longs.cast(n);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return Longs.ensureCapacity(result, i);
    }

    public static long cast(boolean b) {
        return b ? 1 : 0;
    }

    public static long[] casts(boolean[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        long[] result = new long[value.length];
        int i = 0;
        for (boolean val : value) {
            result[i++] = Longs.cast(val);
        }
        return result;
    }

    public static long cast(char value) {
        return value;
    }

    public static long[] casts(char[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        long[] result = new long[value.length];
        int i = 0;
        for (char val : value) {
            result[i++] = Longs.cast(val);
        }
        return result;
    }

    public static long[] casts(byte[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        long[] result = new long[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static long[] casts(short[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        long[] result = new long[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static long[] casts(int[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        long[] result = new long[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static long[] casts(float[] value) {
        return Longs.casts(value, true);
    }

    public static long[] casts(float[] value, boolean thrown) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        long[] result = new long[value.length];
        int i = 0;
        for (float val : value) {
            try {
                result[i++] = Longs.cast(Float.valueOf(val));
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return Longs.ensureCapacity(result, i);
    }

    public static long cast(BigInteger value) {
        if (NumberRangeAssert.checkLong(value)) {
            throw new NumberOverflowException(value);
        }
        return value.longValue();
    }

    public static long cast(BigDecimal value) {
        return Longs.cast(value.toBigInteger());
    }

    public static long[] casts(double[] value) {
        return Longs.casts(value, true);
    }

    public static long[] casts(double[] value, boolean thrown) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        long[] result = new long[value.length];
        int i = 0;
        for (double val : value) {
            try {
                result[i++] = Longs.cast(val);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return Longs.ensureCapacity(result, i);
    }

    public static Long valueOf(Number value) {
        return Longs.valueOf(value, null);
    }

    public static Long valueOf(Number value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        try {
            return Longs.cast(value);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static Long valueOf(Character c) {
        return Longs.valueOf(c, null);
    }

    public static Long valueOf(Character c, Long defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        return Longs.cast(c.charValue());
    }

    public static Long valueOf(Boolean b) {
        return Longs.valueOf(b, null);
    }

    public static Long valueOf(Boolean b, Long defaultValue) {
        if (b == null) {
            return defaultValue;
        }
        return Longs.cast(b);
    }

    public static int deepHashCode(long[] args) {
        if (Longs.isEmpty(args)) {
            return 0;
        }
        int prime = 31;
        int hash = 1;
        for (int i = 0; i < args.length; ++i) {
            hash = prime * hash + Longs.hashCode(args[i]);
        }
        return hash;
    }

    public static boolean isEven(long value) {
        return (value & 1L) == 0L;
    }

    public static boolean isEvens(long[] values) {
        for (long l : values) {
            if (!Longs.isOdd(l)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOdds(long[] values) {
        for (long l : values) {
            if (!Longs.isEven(l)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOdd(long value) {
        return !Longs.isEven(value);
    }

    public static String[] toStringArray(long[] args, DecimalFormat df) {
        int l = args.length;
        String[] array = new String[l];
        for (int i = 0; i < l; ++i) {
            array[i] = df != null ? df.format(args[i]) : String.valueOf(args[i]);
        }
        return array;
    }

    public static boolean isSameLength(long[] left, long[] right) {
        if (left == null) {
            return right != null ? right.length == 0 : true;
        }
        if (right == null) {
            return left != null ? left.length == 0 : true;
        }
        return left.length == right.length;
    }

    public static boolean isSerial(long[] array) {
        return Longs.isSerial(array, 1);
    }

    public static boolean isSerial(long[] array, int n) {
        if (Longs.isEmpty(array)) {
            return false;
        }
        for (int i = array.length - 1; i > 0; --i) {
            if (array[i] - array[i - 1] == (long)n) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarray(long[] left, long[] right) {
        if (Longs.isEmpty(left) || Longs.isEmpty(right) || left.length < right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (left[i] != right[0]) continue;
            boolean f = true;
            for (int j = 1; j < right.length; ++j) {
                if (i + j == left.length) {
                    return false;
                }
                if (left[i + j] == right[j]) continue;
                f = false;
                break;
            }
            if (!f) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(long[] left, long[] right) {
        if (Longs.isEmpty(left) || Longs.isEmpty(right) || left.length < right.length) {
            return false;
        }
        for (long l : right) {
            if (!Longs.notContains(left, l)) continue;
            return false;
        }
        return true;
    }

    public static boolean same(long[] array) {
        return Longs.isSerial(array, 0);
    }

    public static void leftScroll(long[] src, int n) {
        if (Longs.isNotEmpty(src) && n > 0) {
            int l = src.length;
            Longs.rightScroll(src, l - n);
        }
    }

    public static void rightScroll(long[] src, int n) {
        if (Longs.isNotEmpty(src) && n > 0) {
            int l = src.length;
            Longs.rightScroll(src, 0, l - (n %= l) - 1);
            Longs.rightScroll(src, l - n, l - 1);
            Longs.rightScroll(src, 0, l - 1);
        }
    }

    private static void rightScroll(long[] src, int n, int m) {
        while (n < m) {
            Longs.swap(src, m, n);
            ++n;
            --m;
        }
    }

    public static void shuffle(long[] src) {
        Longs.shuffle(src, ThreadLocalRandom.current());
    }

    public static void shuffle(long[] src, Random rn) {
        for (int i = src.length; i > 1; --i) {
            Longs.swap(src, i - 1, rn.nextInt(i));
        }
    }

    public static int compare(long a, long b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public static Comparator<long[]> defaultComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static String toBinaryString(long number) {
        char[] chs = new char[64];
        int l = 64;
        for (int i = 0; i < l; ++i) {
            chs[l - 1 - i] = (char)((number >> i & 1L) + 48L);
        }
        return new String(chs);
    }

    public static long parseBinaryString(String binaryString) {
        if (binaryString.charAt(0) == '0') {
            return Long.parseLong(binaryString, 2);
        }
        StringBuilder str = new StringBuilder();
        for (char bit : binaryString.toCharArray()) {
            str.append(bit == '0' ? 1 : 0);
        }
        long convertedLong = Long.parseLong(str.toString(), 2);
        return -(convertedLong + 1L);
    }

    public static long shiftLeft(long number, int amount) {
        String original = Longs.toBinaryString(number);
        StringBuilder dest = new StringBuilder();
        dest.append(original.toCharArray(), amount &= 0x3F, original.length() - amount);
        for (int i = 0; i < amount; ++i) {
            dest.append(0);
        }
        return Longs.parseBinaryString(dest.toString());
    }

    public static long shiftRight(long number, int amount) {
        String original = Longs.toBinaryString(number);
        StringBuilder dest = new StringBuilder();
        dest.append(original.toCharArray(), 0, original.length() - (amount &= 0x3F));
        for (int i = 0; i < amount; ++i) {
            dest.insert(0, number < 0L ? 1 : 0);
        }
        return Longs.parseBinaryString(dest.toString());
    }

    public static long unsignedShiftRight(long number, int amount) {
        String original = Longs.toBinaryString(number);
        StringBuilder dest = new StringBuilder();
        dest.append(original.toCharArray(), 0, original.length() - (amount &= 0x3F));
        for (int i = 0; i < amount; ++i) {
            dest.insert(0, 0);
        }
        return Long.parseLong(dest.toString(), 2);
    }

    public static long and(long left, long right) {
        String leftOrig = Longs.toBinaryString(left);
        String rightOrig = Longs.toBinaryString(right);
        char[] leftArray = leftOrig.toCharArray();
        char[] rightArray = rightOrig.toCharArray();
        char[] array = new char[leftOrig.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = leftArray[i] == '1' && rightArray[i] == '1' ? 49 : 48;
        }
        String binaryString = new String(array);
        return Longs.parseBinaryString(binaryString);
    }

    public static long or(long left, long right) {
        String leftOrig = Longs.toBinaryString(left);
        String rightOrig = Longs.toBinaryString(right);
        char[] leftArray = leftOrig.toCharArray();
        char[] rightArray = rightOrig.toCharArray();
        char[] array = new char[leftOrig.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = leftArray[i] == '1' || rightArray[i] == '1' ? 49 : 48;
        }
        String binaryString = new String(array);
        return Longs.parseBinaryString(binaryString);
    }

    public static long xor(long left, long right) {
        String leftOrig = Longs.toBinaryString(left);
        String rightOrig = Longs.toBinaryString(right);
        char[] leftArray = leftOrig.toCharArray();
        char[] rightArray = rightOrig.toCharArray();
        char[] array = new char[leftOrig.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = leftArray[i] == rightArray[i] ? 48 : 49;
        }
        String binaryString = new String(array);
        return Longs.parseBinaryString(binaryString);
    }

    public static long not(long number) {
        String orig = Longs.toBinaryString(number);
        char[] leftArray = orig.toCharArray();
        char[] array = new char[orig.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = leftArray[i] == '1' ? 48 : 49;
        }
        String binaryString = new String(array);
        return Longs.parseBinaryString(binaryString);
    }

    private static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] left, long[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Longs.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }
    }
}

