/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.reflection;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.ClassUtils;
import com.github.paganini2008.devtools.collection.CollectionUtils;
import com.github.paganini2008.devtools.reflection.MethodFilter;
import com.github.paganini2008.devtools.reflection.ReflectionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class MethodUtils {
    public static Object invokeMethod(Object object, String methodName, Object ... arguments) {
        if (arguments == null) {
            arguments = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        Class[] parameterTypes = new Class[arguments.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = arguments[i].getClass();
        }
        return MethodUtils.invokeMethod(object, methodName, parameterTypes, arguments);
    }

    public static Object invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object ... arguments) {
        Assert.isNull(object, "Source object must not be null.", new Object[0]);
        if (parameterTypes == null) {
            parameterTypes = ClassUtils.EMPTY_ARRAY;
        }
        Method method = MethodUtils.getMethod(object.getClass(), methodName, parameterTypes);
        return MethodUtils.invokeMethod(object, method, arguments);
    }

    public static Object invokeStaticMethod(Class<?> type, String methodName, Object ... arguments) {
        if (arguments == null) {
            arguments = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        Class[] parameterTypes = new Class[arguments.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = arguments[i].getClass();
        }
        return MethodUtils.invokeStaticMethod(type, methodName, parameterTypes, arguments);
    }

    public static Object invokeStaticMethod(Class<?> type, String methodName, Class<?>[] parameterTypes, Object ... arguments) {
        if (arguments == null) {
            arguments = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (parameterTypes == null) {
            parameterTypes = ClassUtils.EMPTY_ARRAY;
        }
        Method method = MethodUtils.getMethod(type, methodName, parameterTypes);
        return MethodUtils.invokeStaticMethod(method, arguments);
    }

    public static Method getMethodIfAbsent(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        try {
            return MethodUtils.getMethod(type, methodName, parameterTypes);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Method getMethod(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        Exception cause = null;
        try {
            return type.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            cause = e;
            if (cause instanceof NoSuchMethodException) {
                try {
                    return MethodUtils.searchMethod(type, type.getDeclaredMethods(), methodName, parameterTypes);
                }
                catch (NoSuchMethodException e2) {
                    cause = e2;
                }
            }
            try {
                return type.getMethod(methodName, parameterTypes);
            }
            catch (Exception e3) {
                cause = e3;
                if (cause instanceof NoSuchMethodException) {
                    try {
                        return MethodUtils.searchMethod(type, type.getMethods(), methodName, parameterTypes);
                    }
                    catch (NoSuchMethodException e4) {
                        cause = e4;
                    }
                }
                throw new ReflectionException(cause);
            }
        }
    }

    private static Method searchMethod(Class<?> type, Method[] methods, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        if (methods != null) {
            ArrayList<Method> candidates = new ArrayList<Method>();
            for (Method method : methods) {
                if (!method.getName().equals(methodName) || !ClassUtils.isAssignable(method.getParameterTypes(), parameterTypes)) continue;
                candidates.add(method);
            }
            if (!candidates.isEmpty()) {
                Method bestMatch = (Method)candidates.get(0);
                for (Method method : candidates) {
                    if (!ClassUtils.equals(method.getParameterTypes(), parameterTypes)) continue;
                    bestMatch = method;
                }
                return bestMatch;
            }
        }
        throw new NoSuchMethodException("No matched method: " + methodName + "(" + ArrayUtils.toString(parameterTypes) + ")");
    }

    public static Object invokeMethod(Object object, Method method, Object ... arguments) {
        Assert.isNull(object, "Source object must not be null.", new Object[0]);
        Assert.isNull(method, "Method must not be null.", new Object[0]);
        if (arguments == null) {
            arguments = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        try {
            method.setAccessible(true);
            return method.invoke(object, arguments);
        }
        catch (Exception e) {
            throw new ReflectionException("Failed to invoke method: " + method.getName(), e);
        }
    }

    public static Object invokeStaticMethod(Method method, Object ... arguments) {
        Assert.isNull(method, "Method must not be null.", new Object[0]);
        if (arguments == null) {
            arguments = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        try {
            method.setAccessible(true);
            return method.invoke(null, arguments);
        }
        catch (Exception e) {
            throw new ReflectionException("Failed to invoke method: " + method.getName(), e);
        }
    }

    public static List<Method> getDeclaredMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationClass) {
        return MethodUtils.getDeclaredMethods(cls, (name, method) -> method.isAnnotationPresent(annotationClass));
    }

    public static List<Method> getDeclaredMethods(Class<?> cls, MethodFilter methodFilter) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : CollectionUtils.forEach(new DeclaredMethodIterator(cls))) {
            if (methodFilter != null && !methodFilter.accept(method.getName(), method)) continue;
            methods.add(method);
        }
        return methods;
    }

    public static List<Method> getMethods(Class<?> cls, MethodFilter methodFilter) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : CollectionUtils.forEach(new MethodIterator(cls))) {
            if (methodFilter != null && !methodFilter.accept(method.getName(), method)) continue;
            methods.add(method);
        }
        return methods;
    }

    public static List<Method> getMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationClass) {
        return MethodUtils.getMethods(cls, (name, method) -> method.isAnnotationPresent(annotationClass));
    }

    public static Object invokeMethodWithAnnotation(Object object, Class<? extends Annotation> annotationClass, Object ... arguments) {
        List<Method> methods = MethodUtils.getMethodsWithAnnotation(object.getClass(), annotationClass);
        Method matched = CollectionUtils.getFirst(methods);
        if (matched != null) {
            return MethodUtils.invokeMethod(object, matched, arguments);
        }
        return null;
    }

    public static Object[] invokeMethodsWithAnnotation(Object object, Class<? extends Annotation> annotationClass, Object ... arguments) {
        List<Method> methods = MethodUtils.getMethodsWithAnnotation(object.getClass(), annotationClass);
        if (CollectionUtils.isNotEmpty(methods)) {
            Object[] results = new Object[methods.size()];
            int i = 0;
            for (Method method : methods) {
                results[i++] = MethodUtils.invokeMethod(object, method, arguments);
            }
            return results;
        }
        return null;
    }

    public static class MethodIterator
    implements Iterator<Method> {
        private final Iterator<Class<?>> superClassesAndInterfaces;
        private Iterator<Method> methods;

        MethodIterator(Class<?> type) {
            this.methods = new DeclaredMethodIterator(type);
            this.superClassesAndInterfaces = ClassUtils.getAllSuperClassesAndInterfaces(type).iterator();
        }

        @Override
        public boolean hasNext() {
            boolean next = this.canContinue();
            if (!next) {
                this.methods = this.superClassesAndInterfaces.hasNext() ? new DeclaredMethodIterator(this.superClassesAndInterfaces.next()) : null;
                next = this.canContinue();
            }
            return next;
        }

        private boolean canContinue() {
            return this.methods != null && this.methods.hasNext();
        }

        @Override
        public Method next() {
            return this.methods.next();
        }
    }

    public static class DeclaredMethodIterator
    implements Iterator<Method> {
        private Iterator<Class<?>> interfaces;
        private Iterator<Method> methods;

        DeclaredMethodIterator(Class<?> type) {
            Method[] methods = type.getDeclaredMethods();
            this.methods = methods != null ? CollectionUtils.iterator(methods) : CollectionUtils.emptyIterator();
            Class<?>[] types = type.getInterfaces();
            this.interfaces = types != null ? CollectionUtils.iterator(types) : CollectionUtils.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            boolean next = this.canContinue();
            if (!next) {
                this.methods = this.interfaces.hasNext() ? CollectionUtils.iterator(this.interfaces.next().getDeclaredMethods()) : null;
                next = this.canContinue();
            }
            return next;
        }

        private boolean canContinue() {
            return this.methods != null && this.methods.hasNext();
        }

        @Override
        public Method next() {
            return this.methods.next();
        }
    }
}

