/*
 * Decompiled with CFR 0.152.
 */
package com.github.panhongan.conveyer.service;

import com.github.panhongan.bean2sql.table.PageContext;
import com.github.panhongan.bean2sql.table.TableAccess;
import com.github.panhongan.bean2sql.transaction.TransactionManagerEx;
import com.github.panhongan.commons.DbBase;
import com.github.panhongan.commons.ExceptionalActionWrapper;
import com.github.panhongan.commons.PageResult;
import com.github.panhongan.conveyer.service.Converter;
import com.github.panhongan.conveyer.service.WriteChecker;
import com.github.panhongan.conveyer.service.req.AddReq;
import com.github.panhongan.conveyer.service.req.ModifyReq;
import com.github.panhongan.conveyer.service.req.QueryByConditionReq;
import com.github.panhongan.conveyer.service.req.QueryByPageReq;
import com.github.panhongan.utils.object.ObjectUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public abstract class AbstractDataService<B, D extends DbBase> {
    @Autowired
    private TransactionManagerEx transactionManagerEx;

    protected abstract TableAccess<D> getTableAccess();

    protected abstract Converter<B, D> getConverter();

    protected abstract WriteChecker<B, D> getWriteChecker();

    public Optional<B> queryById(long id) {
        return (Optional)ExceptionalActionWrapper.run(() -> {
            Optional doObj = this.getTableAccess().queryById(id);
            return doObj.map(x -> this.getConverter().do2bo((DbBase)x));
        });
    }

    public List<B> queryByCondition(QueryByConditionReq<B> request) {
        return (List)ExceptionalActionWrapper.run(() -> {
            ObjectUtils.validateObject((Object)request);
            DbBase condition = (DbBase)this.getConverter().bo2do(request.getBizObjCondition());
            if (Objects.isNull(condition)) {
                condition = (DbBase)this.getTableAccess().emptyDO();
            }
            List doObjs = this.getTableAccess().queryByCondition((Object)condition, request.getSqlCondition());
            return this.getConverter().dos2bos(doObjs);
        });
    }

    public PageResult<B> queryByPage(QueryByPageReq<B> request) {
        return (PageResult)ExceptionalActionWrapper.run(() -> {
            ObjectUtils.validateObject((Object)request);
            DbBase condition = (DbBase)this.getConverter().bo2do(request.getBizObjCondition());
            if (condition == null) {
                condition = (DbBase)this.getTableAccess().emptyDO();
            }
            PageContext pageContext = new PageContext();
            pageContext.setCurrPage(request.getCurrPage());
            pageContext.setPageSize(request.getPageSize());
            PageResult pageResult = this.getTableAccess().queryByPage((Object)condition, request.getSqlCondition(), pageContext);
            PageResult finalResult = new PageResult();
            finalResult.setTotalCount(pageResult.getTotalCount());
            finalResult.setTotalPage(pageResult.getTotalPage());
            finalResult.setPageSize(pageResult.getPageSize());
            finalResult.setCurrPage(pageResult.getCurrPage());
            for (DbBase doObj : pageResult.getResult()) {
                finalResult.add(this.getConverter().do2bo(doObj));
            }
            return finalResult;
        });
    }

    public long add(AddReq<B> request) {
        return (Long)ExceptionalActionWrapper.run(() -> {
            ObjectUtils.validateObject((Object)request);
            Object bizObj = request.getBizObj();
            ObjectUtils.validateObject(bizObj);
            this.getWriteChecker().checkBeforeAdd(bizObj);
            String operator = StringUtils.isNotEmpty((CharSequence)request.getCreatedBy()) ? request.getCreatedBy() : DbBase.defaultOperator();
            Date currTimestamp = new Date();
            DbBase doObj = (DbBase)this.getConverter().bo2do(bizObj);
            doObj.setCreatedAt(currTimestamp);
            doObj.setCreatedBy(operator);
            doObj.setUpdatedAt(currTimestamp);
            doObj.setUpdatedBy(operator);
            return (Long)this.transactionManagerEx.execute(() -> this.getTableAccess().insert((Object)doObj));
        });
    }

    public int modify(ModifyReq<B> request) {
        return (Integer)ExceptionalActionWrapper.run(() -> {
            ObjectUtils.validateObject((Object)request);
            Object newBizObj = request.getNewBizObj();
            ObjectUtils.validateObject(newBizObj);
            long oriId = request.getOriId();
            this.getWriteChecker().checkBeforeModify(oriId, newBizObj);
            DbBase newObj = (DbBase)this.getConverter().bo2do(newBizObj);
            newObj.setUpdatedAt(new Date());
            newObj.setUpdatedBy(StringUtils.isNotEmpty((CharSequence)request.getUpdatedBy()) ? request.getUpdatedBy() : DbBase.defaultOperator());
            return (Integer)this.transactionManagerEx.execute(() -> this.getTableAccess().update(oriId, (Object)newObj));
        });
    }

    public int deleteById(long id) {
        return (Integer)ExceptionalActionWrapper.run(() -> {
            this.getWriteChecker().checkBeforeDelete(id);
            return (Integer)this.transactionManagerEx.execute(() -> this.getTableAccess().deleteById(id));
        });
    }
}

