/*
 * Copyright 2018 Pascal
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.pascalgn.maven.properties;

import java.util.HashMap;
import java.util.Map;

class ColorHelper {
    private static final Map<Integer, String> colors = new HashMap<>(1280);

    /*
     * Resene RGB Values List
     *
     * For further information refer to http://www.resene.co.nz
     *
     * Copyright Resene Paints Ltd 2001
     *
     * Permission to copy this software, to modify it, to redistribute it,
     * to distribute modified versions, and to use it for any purpose is
     * granted, subject to the following restrictions and understandings.
     *
     * 1. Any text copy made of this dictionary must include this copyright
     *    notice in full.
     * 2. Any redistribution in binary form must reproduce this copyright
     *    notice in the documentation or other materials provided with the
     *    distribution.
     * 3. Resene Paints Ltd makes no warranty or representation that this
     *    dictionary is error-free, and is under no obligation to provide
     *    any services, by way of maintenance, update, or otherwise.
     * 4. There shall be no use of the name of Resene or Resene Paints Ltd in
     *    any advertising, promotional, or sales literature without prior
     *    written consent in each case.
     * 5. These RGB colour formulations may not be used to the detriment of
     *    Resene Paints Ltd.
     */
    static {
        colors.put(5001046, "Abbey");
        colors.put(1774596, "Acadia");
        colors.put(8171681, "Acapulco");
        colors.put(6970651, "Acorn");
        colors.put(13238245, "Aero Blue");
        colors.put(7423635, "Affair");
        colors.put(8803850, "Afghan Tan");
        colors.put(13943976, "Akaroa");
        colors.put(16777215, "Alabaster");
        colors.put(16116179, "Albescent White");
        colors.put(10176259, "Alert Tan");
        colors.put(30371, "Allports");
        colors.put(9468785, "Almond Frost");
        colors.put(11505452, "Alpine");
        colors.put(14408667, "Alto");
        colors.put(11119798, "Aluminium");
        colors.put(3897943, "Amazon");
        colors.put(8877422, "Americano");
        colors.put(10721204, "Amethyst Smoke");
        colors.put(16378611, "Amour");
        colors.put(8101760, "Amulet");
        colors.put(10348031, "Anakiwa");
        colors.put(7358983, "Antique Brass");
        colors.put(14726726, "Anzac");
        colors.put(14663279, "Apache");
        colors.put(5220413, "Apple");
        colors.put(11488579, "Apple Blossom");
        colors.put(14873580, "Apple Green");
        colors.put(15438707, "Apricot");
        colors.put(16776940, "Apricot White");
        colors.put(10607319, "Aqua");
        colors.put(15594997, "Aqua Haze");
        colors.put(15399413, "Aqua Spring");
        colors.put(15267314, "Aqua Squeeze");
        colors.put(84803, "Aquamarine");
        colors.put(1117292, "Arapawa");
        colors.put(4406839, "Armadillo");
        colors.put(9734001, "Arrowtown");
        colors.put(13026229, "Ash");
        colors.put(3021061, "Ash Brown");
        colors.put(1247750, "Asphalt");
        colors.put(16444089, "Astra");
        colors.put(3308960, "Astral");
        colors.put(2636407, "Astronaut");
        colors.put(81506, "Astronaut Blue");
        colors.put(15659251, "Athens Grey");
        colors.put(15526862, "Aths Special");
        colors.put(9948461, "Atlantis");
        colors.put(683893, "Atoll");
        colors.put(3228761, "Atomic");
        colors.put(9920605, "Au Chico");
        colors.put(3868944, "Aubergine");
        colors.put(16121790, "Australian Mint");
        colors.put(8949093, "Avocado");
        colors.put(5137993, "Axolotl");
        colors.put(16238810, "Azalea");
        colors.put(859161, "Aztec");
        colors.put(3234721, "Azure");
        colors.put(156565, "Bahama Blue");
        colors.put(10865420, "Bahia");
        colors.put(16775377, "Baja White");
        colors.put(8757167, "Bali Hai");
        colors.put(2762288, "Baltic Sea");
        colors.put(14312196, "Bamboo");
        colors.put(8750192, "Bandicoot");
        colors.put(14604055, "Barberry");
        colors.put(10914651, "Barley Corn");
        colors.put(16774350, "Barley White");
        colors.put(4456749, "Barossa");
        colors.put(2695472, "Bastille");
        colors.put(8556402, "Battleship Grey");
        colors.put(8235405, "Bay Leaf");
        colors.put(2570881, "Bay of Many");
        colors.put(9992059, "Bazaar");
        colors.put(4000770, "Bean");
        colors.put(15647166, "Beauty Bush");
        colors.put(16708295, "Beeswax");
        colors.put(8247494, "Bermuda");
        colors.put(7048098, "Bermuda Grey");
        colors.put(14607808, "Beryl Green");
        colors.put(16579571, "Bianca");
        colors.put(1452608, "Big Stone");
        colors.put(3308564, "Bilbao");
        colors.put(11706858, "Biloba Flower");
        colors.put(3616801, "Birch");
        colors.put(13946134, "Bird Flower");
        colors.put(1782114, "Biscay");
        colors.put(4813187, "Bismark");
        colors.put(12695460, "Bison Hide");
        colors.put(8817012, "Bitter");
        colors.put(13295629, "Bitter Lemon");
        colors.put(15654618, "Bizarre");
        colors.put(530704, "Black Bean");
        colors.put(725764, "Black Forest");
        colors.put(16185335, "Black Haze");
        colors.put(2430726, "Black Magic");
        colors.put(4074524, "Black Marlin");
        colors.put(267042, "Black Pearl");
        colors.put(921112, "Black Pepper");
        colors.put(852786, "Black Rock");
        colors.put(6751021, "Black Rose");
        colors.put(655388, "Black Russian");
        colors.put(15923962, "Black Squeeze");
        colors.put(16776950, "Black White");
        colors.put(5046581, "Blackberry");
        colors.put(3287354, "Blackcurrant");
        colors.put(2494725, "Blackwood");
        colors.put(16708568, "Bleach White");
        colors.put(2892083, "Bleached Cedar");
        colors.put(14464188, "Blossom");
        colors.put(4810361, "Blue Bayoux");
        colors.put(2230392, "Blue Bell");
        colors.put(15854079, "Blue Chalk");
        colors.put(68890, "Blue Charcoal");
        colors.put(821648, "Blue Chill");
        colors.put(3671156, "Blue Diamond");
        colors.put(2115666, "Blue Dianne");
        colors.put(2887308, "Blue Gem");
        colors.put(12566232, "Blue Haze");
        colors.put(96647, "Blue Lagoon");
        colors.put(7759558, "Blue Marguerite");
        colors.put(13825758, "Blue Romance");
        colors.put(7637121, "Blue Smoke");
        colors.put(90466, "Blue Stone");
        colors.put(273996, "Blue Whale");
        colors.put(1254989, "Blue Zodiac");
        colors.put(1595514, "Blumine");
        colors.put(11814504, "Blush");
        colors.put(1839624, "Bokara Grey");
        colors.put(11514296, "Bombay");
        colors.put(15065313, "Bon Jour");
        colors.put(149390, "Bondi Blue");
        colors.put(14995904, "Bone");
        colors.put(6029600, "Bordeaux");
        colors.put(5122650, "Bossanova");
        colors.put(3903924, "Boston Blue");
        colors.put(13098469, "Botticelli");
        colors.put(603684, "Bottle Green");
        colors.put(8026746, "Boulder");
        colors.put(11436190, "Bouquet");
        colors.put(12218142, "Bourbon");
        colors.put(4860420, "Bracken");
        colors.put(14598550, "Brandy");
        colors.put(13468713, "Brandy Punch");
        colors.put(12290435, "Brandy Rose");
        colors.put(8938017, "Brazil");
        colors.put(6136223, "Breaker Bay");
        colors.put(16775924, "Bridal Heath");
        colors.put(16707820, "Bridesmaid");
        colors.put(3948881, "Bright Grey");
        colors.put(11599872, "Bright Red");
        colors.put(16700220, "Bright Sun");
        colors.put(11248022, "Bronco");
        colors.put(4137225, "Bronze");
        colors.put(5128716, "Bronze Olive");
        colors.put(5062671, "Bronzetone");
        colors.put(16772115, "Broom");
        colors.put(5842948, "Brown Bramble");
        colors.put(4793877, "Brown Derby");
        colors.put(4200449, "Brown Pod");
        colors.put(15204095, "Bubbles");
        colors.put(6434608, "Buccaneer");
        colors.put(11054748, "Bud");
        colors.put(12689412, "Buddha Gold");
        colors.put(4720135, "Bulgarian Rose");
        colors.put(8801566, "Bull Shot");
        colors.put(856343, "Bunker");
        colors.put(1384268, "Bunting");
        colors.put(7802629, "Burgundy");
        colors.put(11808, "Burnham");
        colors.put(14259062, "Burning Sand");
        colors.put(6619147, "Burnt Crimson");
        colors.put(863772, "Bush");
        colors.put(15969558, "Buttercup");
        colors.put(10581261, "Buttered Rum");
        colors.put(6442650, "Butterfly Bush");
        colors.put(16773557, "Buttermilk");
        colors.put(16776426, "Buttery White");
        colors.put(5048856, "Cab Sav");
        colors.put(14240114, "Cabaret");
        colors.put(4148282, "Cabbage Pont");
        colors.put(5796182, "Cactus");
        colors.put(11553898, "Cadillac");
        colors.put(7291916, "Cafe Royale");
        colors.put(14729365, "Calico");
        colors.put(16686340, "California");
        colors.put(3240589, "Calypso");
        colors.put(22554, "Camarone");
        colors.put(8991830, "Camelot");
        colors.put(14268827, "Cameo");
        colors.put(3946768, "Camouflage");
        colors.put(13996452, "Can Can");
        colors.put(15989602, "Canary");
        colors.put(16570647, "Candlelight");
        colors.put(8995687, "Cannon Pink");
        colors.put(11052425, "Canvas");
        colors.put(3949635, "Cape Cod");
        colors.put(16704940, "Cape Honey");
        colors.put(10643013, "Cape Palliser");
        colors.put(14478772, "Caper");
        colors.put(404088, "Capri");
        colors.put(16768431, "Caramel");
        colors.put(15658728, "Cararra");
        colors.put(79388, "Cardin Green");
        colors.put(9176414, "Cardinal");
        colors.put(13803178, "Careys Pink");
        colors.put(15370408, "Carissma");
        colors.put(15990744, "Carla");
        colors.put(6041089, "Carnaby Tan");
        colors.put(16376045, "Carousel Pink");
        colors.put(16300115, "Casablanca");
        colors.put(3105128, "Casal");
        colors.put(9152933, "Cascade");
        colors.put(15122085, "Cashmere");
        colors.put(11386577, "Casper");
        colors.put(5373983, "Castro");
        colors.put(15660791, "Catskill White");
        colors.put(14925502, "Cavern Pink");
        colors.put(9925045, "Ce Soir");
        colors.put(4070420, "Cedar");
        colors.put(7412224, "Cedar Wood Finish");
        colors.put(12108381, "Celery");
        colors.put(13750986, "Celeste");
        colors.put(1980507, "Cello");
        colors.put(1454626, "Celtic");
        colors.put(9270882, "Cement");
        colors.put(16580601, "Ceramic");
        colors.put(16774387, "Chablis");
        colors.put(5336637, "Chalet Green");
        colors.put(15652756, "Chalky");
        colors.put(3493516, "Chambray");
        colors.put(15588529, "Chamois");
        colors.put(16444620, "Champagne");
        colors.put(16303071, "Chantilly");
        colors.put(2697527, "Charade");
        colors.put(16774129, "Chardon");
        colors.put(16764300, "Chardonnay");
        colors.put(12250873, "Charlotte");
        colors.put(13923476, "Charm");
        colors.put(4237408, "Chateau Green");
        colors.put(12432327, "Chatelle");
        colors.put(1529209, "Chathams Blue");
        colors.put(8628829, "Chelsea Cucumber");
        colors.put(10375938, "Chelsea Gem");
        colors.put(14667119, "Chenin");
        colors.put(16571032, "Cherokee");
        colors.put(2753369, "Cherry Pie");
        colors.put(6625812, "Cherrywood");
        colors.put(16308713, "Cherub");
        colors.put(8749529, "Chetwode Blue");
        colors.put(6118488, "Chicago");
        colors.put(15859656, "Chiffon");
        colors.put(16217859, "Chilean Fire");
        colors.put(16776678, "Chilean Heath");
        colors.put(16580583, "China Ivory");
        colors.put(13551527, "Chino");
        colors.put(11068349, "Chinook");
        colors.put(3604994, "Chocolate");
        colors.put(3343211, "Christalle");
        colors.put(6792978, "Christi");
        colors.put(15168266, "Christine");
        colors.put(15266260, "Chrome White");
        colors.put(7814938, "Cigar");
        colors.put(16638428, "Cinderella");
        colors.put(8077056, "Cinnamon");
        colors.put(5580812, "Cioccolato");
        colors.put(16447446, "Citrine White");
        colors.put(10397983, "Citron");
        colors.put(10601738, "Citrus");
        colors.put(4720214, "Clairvoyant");
        colors.put(13940399, "Clam Shell");
        colors.put(8329012, "Claret");
        colors.put(16501991, "Classic Rose");
        colors.put(9077600, "Clay Creek");
        colors.put(15335421, "Clear Day");
        colors.put(15298048, "Clementine");
        colors.put(3611913, "Clinker");
        colors.put(13092031, "Cloud");
        colors.put(2109012, "Cloud Burst");
        colors.put(11314591, "Cloudy");
        colors.put(3688720, "Clover");
        colors.put(4725788, "Cocoa Bean");
        colors.put(3153694, "Cocoa Brown");
        colors.put(16316380, "Coconut Cream");
        colors.put(723723, "Cod Grey");
        colors.put(7365973, "Coffee");
        colors.put(2757646, "Coffee Bean");
        colors.put(10434589, "Cognac");
        colors.put(4138240, "Cola");
        colors.put(11247833, "Cold Purple");
        colors.put(13548218, "Cold Turkey");
        colors.put(16772540, "Colonial White");
        colors.put(6053237, "Comet");
        colors.put(5340262, "Como");
        colors.put(13228498, "Conch");
        colors.put(8158074, "Concord");
        colors.put(15921906, "Concrete");
        colors.put(15325018, "Confetti");
        colors.put(5846839, "Congo Brown");
        colors.put(11328845, "Conifer");
        colors.put(13005419, "Contessa");
        colors.put(8272405, "Copper Canyon");
        colors.put(9717575, "Copper Rust");
        colors.put(13089954, "Coral");
        colors.put(16768214, "Coral Candy");
        colors.put(11037547, "Coral Tree");
        colors.put(6319720, "Corduroy");
        colors.put(12898480, "Coriander");
        colors.put(4204829, "Cork");
        colors.put(15187717, "Corn");
        colors.put(16317133, "Corn Field");
        colors.put(9136907, "Corn Harvest");
        colors.put(16756908, "Cornflower");
        colors.put(16438178, "Corvette");
        colors.put(7747933, "Cosmic");
        colors.put(16767193, "Cosmos");
        colors.put(6380848, "Costa Del Sol");
        colors.put(12762550, "Cotton Seed");
        colors.put(79642, "County Green");
        colors.put(333399, "Cove Grey");
        colors.put(5056557, "Cowboy");
        colors.put(10495762, "Crab Apple");
        colors.put(12144960, "Crail");
        colors.put(11940204, "Cranberry");
        colors.put(4596773, "Crater Brown");
        colors.put(16770464, "Cream Brulee");
        colors.put(16107612, "Cream Can");
        colors.put(16776345, "Creme De Banane");
        colors.put(1969924, "Creole");
        colors.put(7567401, "Crete");
        colors.put(7564632, "Crocodile");
        colors.put(7806751, "Crown of Thorns");
        colors.put(11922655, "Cruise");
        colors.put(18454, "Crusoe");
        colors.put(16612147, "Crusta");
        colors.put(9585441, "Cumin");
        colors.put(16646101, "Cumulus");
        colors.put(16498394, "Cupid");
        colors.put(2463441, "Curious Blue");
        colors.put(5273202, "Cutty Sark");
        colors.put(15936, "Cyprus");
        colors.put(75569, "Daintree");
        colors.put(16377020, "Dairy Cream");
        colors.put(5186456, "Daisy Bush");
        colors.put(7228198, "Dallas");
        colors.put(6329297, "Danube");
        colors.put(3940357, "Dark Ebony");
        colors.put(6367000, "Dark Oak");
        colors.put(6241574, "Dark Rimu");
        colors.put(4268048, "Dark Rum");
        colors.put(3754065, "Dark Slate");
        colors.put(6688784, "Dark Tan");
        colors.put(10920602, "Dawn");
        colors.put(15985125, "Dawn Pink");
        colors.put(8045704, "De York");
        colors.put(13818519, "Deco");
        colors.put(14972568, "Deep Blush");
        colors.put(4861956, "Deep Bronze");
        colors.put(331840, "Deep Cove");
        colors.put(10496, "Deep Fir");
        colors.put(1774203, "Deep Koamaru");
        colors.put(98923, "Deep Sea");
        colors.put(13618, "Deep Teal");
        colors.put(11573909, "Del Rio");
        colors.put(3761171, "Dell");
        colors.put(10790045, "Delta");
        colors.put(7693224, "Deluge");
        colors.put(16772824, "Derby");
        colors.put(11427872, "Desert");
        colors.put(16316663, "Desert Storm");
        colors.put(15400958, "Dew");
        colors.put(14391646, "Di Serria");
        colors.put(1245184, "Diesel");
        colors.put(6125383, "Dingley");
        colors.put(8852816, "Disco");
        colors.put(14849048, "Dixie");
        colors.put(16383883, "Dolly");
        colors.put(6578295, "Dolphin");
        colors.put(9336670, "Domino");
        colors.put(6114385, "Don Juan");
        colors.put(10916473, "Donkey Brown");
        colors.put(7034709, "Dorado");
        colors.put(15655853, "Double Colonial White");
        colors.put(16577744, "Double Pearl Lusta");
        colors.put(15128505, "Double Spanish White");
        colors.put(7171180, "Dove Grey");
        colors.put(598614, "Downriver");
        colors.put(7327941, "Downy");
        colors.put(11503441, "Driftwood");
        colors.put(16644013, "Drover");
        colors.put(3683635, "Dune");
        colors.put(15060169, "Dust Storm");
        colors.put(11049115, "Dusty Grey");
        colors.put(11975332, "Eagle");
        colors.put(13220155, "Earls Green");
        colors.put(16775654, "Early Dawn");
        colors.put(4279421, "East Bay");
        colors.put(11309518, "East Side");
        colors.put(2005680, "Eastern Blue");
        colors.put(15328227, "Ebb");
        colors.put(789277, "Ebony");
        colors.put(2500667, "Ebony Clay");
        colors.put(11517401, "Echo Blue");
        colors.put(3218455, "Eclipse");
        colors.put(16118757, "Ecru White");
        colors.put(16414740, "Ecstasy");
        colors.put(1071186, "Eden");
        colors.put(13165527, "Edgewater");
        colors.put(10661547, "Edward");
        colors.put(16774365, "Egg Sour");
        colors.put(16773057, "Egg White");
        colors.put(1971976, "El Paso");
        colors.put(9387571, "El Salva");
        colors.put(1193031, "Elephant");
        colors.put(557936, "Elf Green");
        colors.put(1866877, "Elm");
        colors.put(7090306, "Eminence");
        colors.put(5326409, "Emperor");
        colors.put(8483703, "Empress");
        colors.put(22183, "Endeavour");
        colors.put(16309596, "Energy Yellow");
        colors.put(142613, "English Holly");
        colors.put(4074275, "English Walnut");
        colors.put(9152144, "Envy");
        colors.put(14793828, "Equator");
        colors.put(2169358, "Eternity");
        colors.put(2591323, "Eucalyptus");
        colors.put(13607837, "Eunry");
        colors.put(151110, "Evening Sea");
        colors.put(1851438, "Everglade");
        colors.put(16773100, "Fair Pink");
        colors.put(8348269, "Falcon");
        colors.put(16446448, "Fantasy");
        colors.put(7957112, "Fedora");
        colors.put(10476940, "Feijoa");
        colors.put(673805, "Fern");
        colors.put(6648352, "Fern Frond");
        colors.put(7360336, "Ferra");
        colors.put(16509292, "Festival");
        colors.put(15793386, "Feta");
        colors.put(11751955, "Fiery Orange");
        colors.put(6448713, "Finch");
        colors.put(5598550, "Finlandia");
        colors.put(6892884, "Finn");
        colors.put(4215145, "Fiord");
        colors.put(11158019, "Fire");
        colors.put(15243560, "Fire Bush");
        colors.put(928304, "Firefly");
        colors.put(14310200, "Flame Pea");
        colors.put(13042462, "Flame Red");
        colors.put(16743687, "Flamenco");
        colors.put(15881514, "Flamingo");
        colors.put(8094309, "Flax");
        colors.put(7301729, "Flint");
        colors.put(10616941, "Flirt");
        colors.put(14220538, "Foam");
        colors.put(14143743, "Fog");
        colors.put(13355702, "Foggy Grey");
        colors.put(1584393, "Forest Green");
        colors.put(16773614, "Forget Me Not");
        colors.put(5682366, "Fountain Blue");
        colors.put(16768691, "Frangipani");
        colors.put(12434886, "French Grey");
        colors.put(15517678, "French Lilac");
        colors.put(12447229, "French Pass");
        colors.put(8420985, "Friar Grey");
        colors.put(11657921, "Fringy Flower");
        colors.put(16086404, "Froly");
        colors.put(15594973, "Frost");
        colors.put(14417912, "Frosted Mint");
        colors.put(15005415, "Frostee");
        colors.put(5217629, "Fruit Salad");
        colors.put(8018113, "Fuchsia");
        colors.put(12508685, "Fuego");
        colors.put(15509799, "Fuel Yellow");
        colors.put(1661352, "Fun Blue");
        colors.put(93497, "Fun Green");
        colors.put(5526349, "Fuscous Grey");
        colors.put(1455409, "Gable Green");
        colors.put(15724527, "Gallery");
        colors.put(14463500, "Galliano");
        colors.put(13733659, "Geebung");
        colors.put(1405803, "Genoa");
        colors.put(16484745, "Geraldine");
        colors.put(13950946, "Geyser");
        colors.put(13093333, "Ghost");
        colors.put(5389460, "Gigas");
        colors.put(12105066, "Gimblet");
        colors.put(15266539, "Gin");
        colors.put(16775650, "Gin Fizz");
        colors.put(16311487, "Givry");
        colors.put(8434628, "Glacier");
        colors.put(6390879, "Glade Green");
        colors.put(7499086, "Go Ben");
        colors.put(4029778, "Goblin");
        colors.put(15827456, "Gold Drop");
        colors.put(14596627, "Gold Tips");
        colors.put(14846227, "Golden Bell");
        colors.put(15783213, "Golden Dream");
        colors.put(16120637, "Golden Fizz");
        colors.put(16638613, "Golden Glow");
        colors.put(15784829, "Golden Sand");
        colors.put(16763996, "Golden Tainoi");
        colors.put(2495508, "Gondola");
        colors.put(725255, "Gordons Green");
        colors.put(16773455, "Gorse");
        colors.put(433025, "Gossamer");
        colors.put(13826224, "Gossip");
        colors.put(7180961, "Gothic");
        colors.put(3095731, "Governor Bay");
        colors.put(14996919, "Grain Brown");
        colors.put(16765836, "Grandis");
        colors.put(9275764, "Granite Green");
        colors.put(14022371, "Granny Apple");
        colors.put(8691872, "Granny Smith");
        colors.put(3676753, "Grape");
        colors.put(2430471, "Graphite");
        colors.put(8156721, "Grass Hopper");
        colors.put(4867147, "Gravel");
        colors.put(2379791, "Green House");
        colors.put(2437404, "Green Kelp");
        colors.put(4418061, "Green Leaf");
        colors.put(13358000, "Green Mist");
        colors.put(1925442, "Green Pea");
        colors.put(10792814, "Green Smoke");
        colors.put(12108209, "Green Spring");
        colors.put(207698, "Green Vogue");
        colors.put(1053701, "Green Waterloo");
        colors.put(15264736, "Green White");
        colors.put(13977088, "Grenadier");
        colors.put(10660531, "Grey Chateau");
        colors.put(4540726, "Grey Green");
        colors.put(12829629, "Grey Nickel");
        colors.put(15199462, "Grey Nurse");
        colors.put(11117713, "Grey Olive");
        colors.put(12697293, "Grey Suit");
        colors.put(12189953, "Guardsman Red");
        colors.put(8434606, "Gulf Stream");
        colors.put(10333367, "Gull Grey");
        colors.put(11981759, "Gum Leaf");
        colors.put(8167846, "Gumbo");
        colors.put(4276823, "Gun Powder");
        colors.put(134421, "Gunmetal");
        colors.put(8554117, "Gunsmoke");
        colors.put(10130807, "Gurkha");
        colors.put(9994523, "Hacienda");
        colors.put(7023124, "Hairy Heath");
        colors.put(1773621, "Haiti");
        colors.put(16776929, "Half and Half");
        colors.put(8766668, "Half Baked");
        colors.put(16643795, "Half Colonial White");
        colors.put(16709598, "Half Dutch White");
        colors.put(16708827, "Half Spanish White");
        colors.put(15063215, "Hampton");
        colors.put(15135466, "Harp");
        colors.put(14727540, "Harvest Gold");
        colors.put(3413269, "Havana");
        colors.put(5607641, "Havelock Blue");
        colors.put(10311190, "Hawaiian Tan");
        colors.put(13951740, "Hawkes Blue");
        colors.put(5509138, "Heath");
        colors.put(12043216, "Heather");
        colors.put(11972757, "Heathered Grey");
        colors.put(2830888, "Heavy Metal");
        colors.put(6184251, "Hemlock");
        colors.put(9468020, "Hemp");
        colors.put(9473337, "Highball");
        colors.put(7310947, "Highland");
        colors.put(11314566, "Hillary");
        colors.put(15138793, "Hint of Green");
        colors.put(16382457, "Hint of Red");
        colors.put(16448996, "Hint of Yellow");
        colors.put(5806767, "Hippie Blue");
        colors.put(5472843, "Hippie Green");
        colors.put(11421024, "Hippie Pink");
        colors.put(10595765, "Hit Grey");
        colors.put(16755585, "Hit Pink");
        colors.put(13149480, "Hokey Pokey");
        colors.put(6653599, "Hoki");
        colors.put(72979, "Holly");
        colors.put(5184624, "Honey Flower");
        colors.put(15596676, "Honeysuckle");
        colors.put(13659553, "Hopbush");
        colors.put(5932960, "Horizon");
        colors.put(6310163, "Horses Neck");
        colors.put(9111331, "Hot Chile");
        colors.put(11763719, "Hot Toddy");
        colors.put(13629939, "Humming Bird");
        colors.put(1449232, "Hunter Green");
        colors.put(8879227, "Hurricane");
        colors.put(12035160, "Husk");
        colors.put(11662567, "Ice Cold");
        colors.put(14349552, "Iceberg");
        colors.put(16164041, "Illusion");
        colors.put(5053953, "Indian Tan");
        colors.put(12741379, "Indochine");
        colors.put(4403488, "Iroko");
        colors.put(13948889, "Iron");
        colors.put(4267792, "Ironbark");
        colors.put(6776418, "Ironside Grey");
        colors.put(8800316, "Ironstone");
        colors.put(16776430, "Island Spice");
        colors.put(3015465, "Jacaranda");
        colors.put(3811946, "Jacarta");
        colors.put(2105485, "Jacksons Purple");
        colors.put(4356471, "Jade");
        colors.put(15697471, "Jaffa");
        colors.put(12773605, "Jagged Ice");
        colors.put(3477079, "Jagger");
        colors.put(524560, "Jaguar");
        colors.put(5976083, "Jambalaya");
        colors.put(16051155, "Janna");
        colors.put(682246, "Japanese Laurel");
        colors.put(7864585, "Japanese Maple");
        colors.put(14187619, "Japonica");
        colors.put(2081474, "Java");
        colors.put(2718618, "Jelly Bean");
        colors.put(11915982, "Jet Stream");
        colors.put(1207104, "Jewel");
        colors.put(3874591, "Jon");
        colors.put(15663002, "Jonquil");
        colors.put(9091569, "Jordy Blue");
        colors.put(5522227, "Judge Grey");
        colors.put(8158082, "Jumbo");
        colors.put(2629141, "Jungle Green");
        colors.put(11849683, "Jungle Mist");
        colors.put(7180946, "Juniper");
        colors.put(15519161, "Just Right");
        colors.put(6178878, "Kabul");
        colors.put(17952, "Kaitoke Green");
        colors.put(13027517, "Kangaroo");
        colors.put(1971721, "Karaka");
        colors.put(16771796, "Karry");
        colors.put(5271702, "Kashmir Blue");
        colors.put(8133637, "Kenyan Copper");
        colors.put(3846302, "Keppel");
        colors.put(14805716, "Kidnapper");
        colors.put(2362370, "Kilamanjaro");
        colors.put(3828295, "Killarney");
        colors.put(7564447, "Kimberly");
        colors.put(4064384, "Kingfisher Daisy");
        colors.put(15179716, "Kobi");
        colors.put(7236951, "Kokoda");
        colors.put(9390862, "Korma");
        colors.put(16760159, "Koromiko");
        colors.put(16770930, "Kournikova");
        colors.put(3573526, "La Palma");
        colors.put(11780368, "La Rioja");
        colors.put(13035024, "Las Palmas");
        colors.put(13153640, "Laser");
        colors.put(7639928, "Laurel");
        colors.put(11049446, "Lavender");
        colors.put(9859161, "Leather");
        colors.put(16046108, "Lemon");
        colors.put(11312674, "Lemon Ginger");
        colors.put(10198671, "Lemon Grass");
        colors.put(16564254, "Lightning Yellow");
        colors.put(9991379, "Lilac Bush");
        colors.put(13150911, "Lily");
        colors.put(15202559, "Lily White");
        colors.put(7781655, "Lima");
        colors.put(12568865, "Lime");
        colors.put(7314690, "Limeade");
        colors.put(7634275, "Limed Ash");
        colors.put(4340001, "Limed Gum");
        colors.put(11307606, "Limed Oak");
        colors.put(10338825, "Limerick");
        colors.put(15131860, "Linen");
        colors.put(14279925, "Link Water");
        colors.put(11208035, "Lipstick");
        colors.put(5056558, "Livid Brown");
        colors.put(15660254, "Loafer");
        colors.put(12437966, "Loblolly");
        colors.put(2919556, "Lochinvar");
        colors.put(32455, "Lochmara");
        colors.put(11054990, "Locust");
        colors.put(2370077, "Log Cabin");
        colors.put(11184589, "Logan");
        colors.put(14667739, "Lola");
        colors.put(12494531, "London Hue");
        colors.put(7143681, "Lonestar");
        colors.put(8797244, "Lotus");
        colors.put(4590401, "Loulou");
        colors.put(11509532, "Lucky");
        colors.put(1710696, "Lucky Point");
        colors.put(3950906, "Lunar Green");
        colors.put(10033927, "Lusty");
        colors.put(10979372, "Luxor Gold");
        colors.put(6913690, "Lynch");
        colors.put(14284799, "Mabel");
        colors.put(12054718, "Madang");
        colors.put(599389, "Madison");
        colors.put(4141058, "Madras");
        colors.put(16315647, "Magnolia");
        colors.put(5113350, "Mahogany");
        colors.put(11560456, "Mai Tai");
        colors.put(16111008, "Maize");
        colors.put(9010541, "Makara");
        colors.put(4475220, "Mako");
        colors.put(8243447, "Malibu");
        colors.put(2307096, "Mallard");
        colors.put(12432033, "Malta");
        colors.put(9339280, "Mamba");
        colors.put(11368475, "Mandalay");
        colors.put(14832741, "Mandy");
        colors.put(15909810, "Mandys Pink");
        colors.put(16107929, "Manhattan");
        colors.put(7652197, "Mantis");
        colors.put(9149584, "Mantle");
        colors.put(15658872, "Manz");
        colors.put(3473462, "Mardi Gras");
        colors.put(12160296, "Marigold");
        colors.put(2648781, "Mariner");
        colors.put(4326147, "Maroon");
        colors.put(724744, "Marshland");
        colors.put(11509918, "Martini");
        colors.put(3551312, "Martinique");
        colors.put(16309149, "Marzipan");
        colors.put(4209464, "Masala");
        colors.put(1795485, "Matisse");
        colors.put(11558228, "Matrix");
        colors.put(5126977, "Matterhorn");
        colors.put(14205653, "Maverick");
        colors.put(14992085, "Melanie");
        colors.put(3147049, "Melanzane");
        colors.put(13091327, "Melrose");
        colors.put(6102543, "Meranti");
        colors.put(15066597, "Mercury");
        colors.put(16183526, "Merino");
        colors.put(4275255, "Merlin");
        colors.put(8591651, "Merlot");
        colors.put(4798235, "Metallic Bronze");
        colors.put(7416093, "Metallic Copper");
        colors.put(13663506, "Meteor");
        colors.put(3940214, "Meteorite");
        colors.put(10954021, "Mexican Red");
        colors.put(6250350, "Mid Grey");
        colors.put(71221, "Midnight");
        colors.put(1857, "Midnight Express");
        colors.put(266244, "Midnight Moss");
        colors.put(2958608, "Mikado");
        colors.put(16449444, "Milan");
        colors.put(12062980, "Milano Red");
        colors.put(16774868, "Milk Punch");
        colors.put(5850163, "Millbrook");
        colors.put(16317907, "Mimosa");
        colors.put(14940552, "Mindaro");
        colors.put(3289650, "Mine Shaft");
        colors.put(4152659, "Mineral Green");
        colors.put(3568765, "Ming");
        colors.put(4141183, "Minsk");
        colors.put(15855297, "Mint Julep");
        colors.put(12907755, "Mint Tulip");
        colors.put(1448232, "Mirage");
        colors.put(13751005, "Mischka");
        colors.put(12895420, "Mist Grey");
        colors.put(8353161, "Mobster");
        colors.put(7216404, "Moccaccino");
        colors.put(7875865, "Mocha");
        colors.put(12601143, "Mojo");
        colors.put(16753044, "Mona Lisa");
        colors.put(4865072, "Mondo");
        colors.put(11903615, "Mongoose");
        colors.put(9077641, "Monsoon");
        colors.put(2694704, "Montana");
        colors.put(8638662, "Monte Carlo");
        colors.put(8353491, "Moody Blue");
        colors.put(16580314, "Moon Glow");
        colors.put(14474700, "Moon Mist");
        colors.put(14077686, "Moon Raker");
        colors.put(10411744, "Morning Glory");
        colors.put(4463872, "Morocco Brown");
        colors.put(5260113, "Mortar");
        colors.put(223854, "Mosque");
        colors.put(9802646, "Mountain Mist");
        colors.put(12029532, "Muddy Waters");
        colors.put(11176795, "Muesli");
        colors.put(6030646, "Mulberry");
        colors.put(9193263, "Mule Fawn");
        colors.put(5129570, "Mulled Wine");
        colors.put(7627789, "Mustard");
        colors.put(14061960, "My Pink");
        colors.put(16757535, "My Sin");
        colors.put(14871533, "Mystic");
        colors.put(4939090, "Nandor");
        colors.put(11314324, "Napa");
        colors.put(15596017, "Narvik");
        colors.put(13360086, "Nebula");
        colors.put(16769733, "Negroni");
        colors.put(9350081, "Nepal");
        colors.put(8173499, "Neptune");
        colors.put(1312256, "Nero");
        colors.put(6581877, "Nevada");
        colors.put(8075265, "New Amber");
        colors.put(15980189, "New Orleans");
        colors.put(14123903, "New York Pink");
        colors.put(434569, "Niagara");
        colors.put(2036239, "Night Rider");
        colors.put(11155290, "Night Shadz");
        colors.put(6684741, "Nightclub");
        colors.put(1652561, "Nile Blue");
        colors.put(12038577, "Nobel");
        colors.put(12235170, "Nomad");
        colors.put(11058591, "Norway");
        colors.put(12949794, "Nugget");
        colors.put(8471084, "Nutmeg");
        colors.put(6829568, "Nutmeg Wood Finish");
        colors.put(16707534, "Oasis");
        colors.put(165487, "Observatory");
        colors.put(4303480, "Ocean Green");
        colors.put(15137011, "Off Green");
        colors.put(16710115, "Off Yellow");
        colors.put(9444894, "Old Brick");
        colors.put(7490095, "Old Copper");
        colors.put(2371094, "Olive Green");
        colors.put(9143408, "Olive Haze");
        colors.put(7433744, "Olivetone");
        colors.put(13497599, "Onahau");
        colors.put(3090190, "Onion");
        colors.put(11126466, "Opal");
        colors.put(9334640, "Opium");
        colors.put(3634293, "Oracle");
        colors.put(12867353, "Orange Roughy");
        colors.put(16710893, "Orange White");
        colors.put(16776691, "Orchid White");
        colors.put(89733, "Orient");
        colors.put(13013393, "Oriental Pink");
        colors.put(15989716, "Orinoco");
        colors.put(8883601, "Oslo Grey");
        colors.put(15333613, "Ottoman");
        colors.put(3687765, "Oxford Blue");
        colors.put(7839366, "Oxley");
        colors.put(14351103, "Oyster Bay");
        colors.put(15322829, "Oyster Pink");
        colors.put(10900777, "Paarl");
        colors.put(7827297, "Pablo");
        colors.put(7831840, "Pacifika");
        colors.put(11396804, "Padua");
        colors.put(12637113, "Pale Leaf");
        colors.put(9997687, "Pale Oyster");
        colors.put(16645816, "Pale Prim");
        colors.put(16769522, "Pale Rose");
        colors.put(7239555, "Pale Sky");
        colors.put(12828609, "Pale Slate");
        colors.put(598799, "Palm Green");
        colors.put(1651470, "Palm Leaf");
        colors.put(16052974, "Pampas");
        colors.put(15398638, "Panache");
        colors.put(15584683, "Pancho");
        colors.put(9241126, "Paprika");
        colors.put(3243394, "Paradiso");
        colors.put(15854034, "Parchment");
        colors.put(16774254, "Paris Daisy");
        colors.put(2491754, "Paris M");
        colors.put(13294804, "Paris White");
        colors.put(1265433, "Parsley");
        colors.put(6527631, "Patina");
        colors.put(14611967, "Pattens Blue");
        colors.put(2491240, "Paua");
        colors.put(14140568, "Pavlova");
        colors.put(13624786, "Pea Soup");
        colors.put(16773339, "Peach");
        colors.put(7876374, "Peanut");
        colors.put(15261909, "Pearl Bush");
        colors.put(16577756, "Pearl Lusta");
        colors.put(7433046, "Peat");
        colors.put(4107199, "Pelorous");
        colors.put(14939617, "Peppermint");
        colors.put(11124466, "Perano");
        colors.put(13680376, "Perfume");
        colors.put(14804694, "Periglacial Blue");
        colors.put(7347228, "Persian Plum");
        colors.put(5377047, "Persian Red");
        colors.put(16739155, "Persimmon");
        colors.put(8337922, "Peru Tan");
        colors.put(14390928, "Petite Orchid");
        colors.put(9873569, "Pewter");
        colors.put(10715259, "Pharlap");
        colors.put(16774045, "Picasso");
        colors.put(7227430, "Pickled Bean");
        colors.put(4567528, "Picton Blue");
        colors.put(7167572, "Pine Cone");
        colors.put(13094288, "Pine Glade");
        colors.put(1515268, "Pine Tree");
        colors.put(14794952, "Pink Flare");
        colors.put(16768500, "Pink Lace");
        colors.put(16773592, "Pink Lady");
        colors.put(12498359, "Pink Swan");
        colors.put(13198115, "Piper");
        colors.put(16708812, "Pipi");
        colors.put(16769503, "Pippin");
        colors.put(12222211, "Pirate Gold");
        colors.put(12638390, "Pixie Green");
        colors.put(16748544, "Pizazz");
        colors.put(13210645, "Pizza");
        colors.put(2576459, "Plantation");
        colors.put(4259926, "Plum");
        colors.put(9372188, "Pohutukawa");
        colors.put(15071734, "Polar");
        colors.put(9283788, "Polo Blue");
        colors.put(15725299, "Porcelain");
        colors.put(15380073, "Porsche");
        colors.put(2432847, "Port Gore");
        colors.put(16777140, "Portafino");
        colors.put(9150446, "Portage");
        colors.put(16377443, "Portica");
        colors.put(16115682, "Pot Pourri");
        colors.put(9197368, "Potters Clay");
        colors.put(12372418, "Powder Blue");
        colors.put(10106912, "Prairie Sand");
        colors.put(13680869, "Prelude");
        colors.put(15786732, "Prim");
        colors.put(15592089, "Primrose");
        colors.put(16709105, "Provincial Pink");
        colors.put(12627, "Prussian Blue");
        colors.put(8203284, "Pueblo");
        colors.put(4178346, "Puerto Rico");
        colors.put(12765892, "Pumice");
        colors.put(11624715, "Pumpkin");
        colors.put(14435123, "Punch");
        colors.put(5061908, "Punga");
        colors.put(15191436, "Putty");
        colors.put(16776692, "Quarter Pearl Lusta");
        colors.put(16249569, "Quarter Spanish White");
        colors.put(12425102, "Quicksand");
        colors.put(14079697, "Quill Grey");
        colors.put(6438701, "Quincy");
        colors.put(792849, "Racing Green");
        colors.put(15391416, "Raffia");
        colors.put(8092820, "Raincloud");
        colors.put(12175532, "Rainee");
        colors.put(16234088, "Rajah");
        colors.put(3027490, "Rangitoto");
        colors.put(1842707, "Rangoon Green");
        colors.put(7502729, "Raven");
        colors.put(3936774, "Rebel");
        colors.put(9306112, "Red Berry");
        colors.put(14314049, "Red Damask");
        colors.put(8782097, "Red Devil");
        colors.put(7211266, "Red Oxide");
        colors.put(8401951, "Red Robin");
        colors.put(13655812, "Red Stage");
        colors.put(13238178, "Reef");
        colors.put(10453532, "Reef Gold");
        colors.put(81770, "Regal Blue");
        colors.put(8819871, "Regent Grey");
        colors.put(11196134, "Regent St Blue");
        colors.put(16706547, "Remy");
        colors.put(11035925, "Reno Sand");
        colors.put(9095, "Resolution Blue");
        colors.put(2889266, "Revolver");
        colors.put(3030882, "Rhino");
        colors.put(16776944, "Rice Cake");
        colors.put(15663074, "Rice Flower");
        colors.put(11031303, "Rich Gold");
        colors.put(12308489, "Rio Grande");
        colors.put(9168600, "Riptide");
        colors.put(4410457, "River Bed");
        colors.put(15386228, "Rob Roy");
        colors.put(12437683, "Robins Egg Blue");
        colors.put(5060659, "Rock");
        colors.put(10400205, "Rock Blue");
        colors.put(12207372, "Rock Spray");
        colors.put(13218459, "Rodeo Dust");
        colors.put(7634307, "Rolling Stone");
        colors.put(14574432, "Roman");
        colors.put(7953740, "Roman Coffee");
        colors.put(16776957, "Romance");
        colors.put(16765623, "Romantic");
        colors.put(15517006, "Ronchi");
        colors.put(10891040, "Roof Terracotta");
        colors.put(9325854, "Rope");
        colors.put(15187124, "Rose");
        colors.put(16495267, "Rose Bud");
        colors.put(8391495, "Rose Bud Cherry");
        colors.put(12539136, "Rose of Sharon");
        colors.put(16774901, "Rose White");
        colors.put(13019211, "Roti");
        colors.put(10632044, "Rouge");
        colors.put(11220082, "Royal Heath");
        colors.put(7956873, "Rum");
        colors.put(16382180, "Rum Swizzle");
        colors.put(7690839, "Russett");
        colors.put(4719620, "Rustic Red");
        colors.put(4993060, "Saddle");
        colors.put(5780481, "Saddle Brown");
        colors.put(16367448, "Saffron");
        colors.put(10397063, "Sage");
        colors.put(12034580, "Sahara");
        colors.put(12116217, "Sail");
        colors.put(622411, "Salem");
        colors.put(16702349, "Salomie");
        colors.put(6839918, "Salt Box");
        colors.put(15857650, "Saltpan");
        colors.put(3809296, "Sambuca");
        colors.put(745991, "San Felix");
        colors.put(3165034, "San Juan");
        colors.put(4549804, "San Marino");
        colors.put(8548197, "Sand Dune");
        colors.put(11177327, "Sandal");
        colors.put(11243898, "Sandrift");
        colors.put(7957858, "Sandstone");
        colors.put(16115618, "Sandwisp");
        colors.put(16771784, "Sandy Beach");
        colors.put(9568266, "Sangria");
        colors.put(9256248, "Sanguine Brown");
        colors.put(11627858, "Santa Fe");
        colors.put(10461361, "Santas Grey");
        colors.put(14603428, "Sapling");
        colors.put(3101086, "Sapphire");
        colors.put(5593872, "Saratoga");
        colors.put(16774643, "Sauvignon");
        colors.put(16774368, "Sazerac");
        colors.put(6774694, "Scampi");
        colors.put(13630196, "Scandal");
        colors.put(4396384, "Scarlet Gum");
        colors.put(9764885, "Scarlett");
        colors.put(5789026, "Scarpa Flow");
        colors.put(11121815, "Schist");
        colors.put(9143422, "Schooner");
        colors.put(3063764, "Scooter");
        colors.put(6905698, "Scorpion");
        colors.put(16776156, "Scotch Mist");
        colors.put(16490793, "Sea Buckthorn");
        colors.put(612441, "Sea Green");
        colors.put(12966858, "Sea Mist");
        colors.put(7906204, "Sea Nymph");
        colors.put(15571102, "Sea Pink");
        colors.put(8441066, "Seagull");
        colors.put(7544463, "Seance");
        colors.put(15856113, "Seashell");
        colors.put(1781521, "Seaweed");
        colors.put(15789821, "Selago");
        colors.put(2818562, "Sepia");
        colors.put(16774376, "Serenade");
        colors.put(10142392, "Shadow Green");
        colors.put(11183529, "Shady Lady");
        colors.put(5155793, "Shakespeare");
        colors.put(16515002, "Shalimar");
        colors.put(2434860, "Shark");
        colors.put(18768, "Sherpa Blue");
        colors.put(147500, "Sherwood Green");
        colors.put(15251891, "Shilo");
        colors.put(7032369, "Shingle Fawn");
        colors.put(7900090, "Ship Cove");
        colors.put(4078148, "Ship Grey");
        colors.put(11667761, "Shiraz");
        colors.put(14848704, "Shocking");
        colors.put(6252146, "Shuttle Grey");
        colors.put(6580820, "Siam");
        colors.put(15984571, "Sidecar");
        colors.put(12431784, "Silk");
        colors.put(11316396, "Silver Chalice");
        colors.put(12566978, "Silver Sand");
        colors.put(6731151, "Silver Tree");
        colors.put(10475475, "Sinbad");
        colors.put(7995706, "Siren");
        colors.put(7438464, "Sirocco");
        colors.put(13880250, "Sisal");
        colors.put(13297370, "Skeptic");
        colors.put(5341327, "Smalt Blue");
        colors.put(6314867, "Smoky");
        colors.put(16251639, "Snow Drift");
        colors.put(15007697, "Snow Flurry");
        colors.put(14090203, "Snowy Mint");
        colors.put(14866669, "Snuff");
        colors.put(16776185, "Soapstone");
        colors.put(13747892, "Soft Amber");
        colors.put(16117231, "Soft Peach");
        colors.put(8992835, "Solid Pink");
        colors.put(16709858, "Solitaire");
        colors.put(15398655, "Solitude");
        colors.put(16612359, "Sorbus");
        colors.put(13547919, "Sorrell Brown");
        colors.put(13745832, "Sour Dough");
        colors.put(6971473, "Soya Bean");
        colors.put(8493189, "Spanish Green");
        colors.put(3103319, "Spectra");
        colors.put(6964270, "Spice");
        colors.put(8934210, "Spicy Mix");
        colors.put(8482417, "Spicy Pink");
        colors.put(11981290, "Spindle");
        colors.put(7986924, "Spray");
        colors.put(5735267, "Spring Green");
        colors.put(11324337, "Spring Rain");
        colors.put(16187356, "Spring Sun");
        colors.put(16316145, "Spring Wood");
        colors.put(12703664, "Sprout");
        colors.put(11185079, "Spun Pearl");
        colors.put(9404790, "Squirrel");
        colors.put(2971291, "St Tropaz");
        colors.put(9080714, "Stack");
        colors.put(10461084, "Star Dust");
        colors.put(15062973, "Stark White");
        colors.put(15528517, "Starship");
        colors.put(2499381, "Steel Grey");
        colors.put(10236726, "Stiletto");
        colors.put(9602419, "Stonewall");
        colors.put(6579299, "Storm Dust");
        colors.put(7435398, "Storm Grey");
        colors.put(13942669, "Straw");
        colors.put(9790343, "Strikemaster");
        colors.put(3300690, "Stromboli");
        colors.put(7424690, "Studio");
        colors.put(12240841, "Submarine");
        colors.put(16383990, "Sugar Cane");
        colors.put(12710012, "Sulu");
        colors.put(9878443, "Summer Green");
        colors.put(16493587, "Sun");
        colors.put(13218651, "Sundance");
        colors.put(16757171, "Sundown");
        colors.put(14996514, "Sunflower");
        colors.put(14772325, "Sunglo");
        colors.put(16752172, "Sunshade");
        colors.put(16763137, "Supernova");
        colors.put(12310465, "Surf");
        colors.put(817785, "Surfie Green");
        colors.put(8891193, "Sushi");
        colors.put(8946567, "Suva Grey");
        colors.put(6940, "Swamp");
        colors.put(14479594, "Swans Down");
        colors.put(16509580, "Sweet Corn");
        colors.put(16621474, "Sweet Pink");
        colors.put(13880773, "Swirl");
        colors.put(14538453, "Swiss Coffee");
        colors.put(15577985, "Tacao");
        colors.put(14075234, "Tacha");
        colors.put(15301639, "Tahiti Gold");
        colors.put(15659208, "Tahuna Sands");
        colors.put(11742505, "Tall Poppy");
        colors.put(10032659, "Tamarillo");
        colors.put(14277825, "Tana");
        colors.put(202300, "Tangaroa");
        colors.put(15563292, "Tango");
        colors.put(8091764, "Tapa");
        colors.put(11558529, "Tapestry");
        colors.put(14808808, "Tara");
        colors.put(473680, "Tarawera");
        colors.put(13622479, "Tasman");
        colors.put(11775893, "Taupe Grey");
        colors.put(6890821, "Tawny Port");
        colors.put(1983292, "Te Papa Green");
        colors.put(12696240, "Tea");
        colors.put(11637857, "Teak");
        colors.put(279129, "Teal Blue");
        colors.put(3866635, "Temptress");
        colors.put(16770759, "Tequila");
        colors.put(16316828, "Texas");
        colors.put(16758101, "Texas Rose");
        colors.put(11967896, "Thatch");
        colors.put(4209945, "Thatch Green");
        colors.put(13421224, "Thistle");
        colors.put(3352879, "Thunder");
        colors.put(12593944, "Thunderbird");
        colors.put(12665870, "Tia Maria");
        colors.put(12833233, "Tiara");
        colors.put(406839, "Tiber");
        colors.put(15859629, "Tidal");
        colors.put(12564656, "Tide");
        colors.put(1454636, "Timber Green");
        colors.put(15789823, "Titan White");
        colors.put(10120801, "Toast");
        colors.put(7429447, "Tobacco Brown");
        colors.put(3801120, "Toledo");
        colors.put(1770053, "Tolopea");
        colors.put(4151355, "Tom Thumb");
        colors.put(15179660, "Tonys Pink");
        colors.put(8157066, "Topaz");
        colors.put(994718, "Torea Bay");
        colors.put(1331370, "Tory Blue");
        colors.put(9256767, "Tosca");
        colors.put(11124159, "Tower Grey");
        colors.put(6271916, "Tradewind");
        colors.put(15138815, "Tranquil");
        colors.put(16776680, "Travertine");
        colors.put(16555037, "Tree Poppy");
        colors.put(3876896, "Treehouse");
        colors.put(8161306, "Trendy Green");
        colors.put(9200789, "Trendy Pink");
        colors.put(15093251, "Trinidad");
        colors.put(12836345, "Tropical Blue");
        colors.put(4869722, "Trout");
        colors.put(9073622, "True V");
        colors.put(3552564, "Tuatara");
        colors.put(16768461, "Tuft Bush");
        colors.put(15381307, "Tulip Tree");
        colors.put(3614990, "Tumbleweed");
        colors.put(3487042, "Tuna");
        colors.put(4866628, "Tundora");
        colors.put(16442880, "Turbo");
        colors.put(11891329, "Turkish Rose");
        colors.put(13286216, "Turmeric");
        colors.put(2766859, "Turtle Green");
        colors.put(12410414, "Tuscany");
        colors.put(15659971, "Tusk");
        colors.put(12949835, "Tussock");
        colors.put(16773625, "Tutu");
        colors.put(14995422, "Twilight");
        colors.put(15662591, "Twilight Blue");
        colors.put(12752221, "Twine");
        colors.put(14173239, "Valencia");
        colors.put(3477058, "Valentino");
        colors.put(2824527, "Valhalla");
        colors.put(4790028, "Van Cleef");
        colors.put(15981023, "Vanilla Ice");
        colors.put(16774879, "Varden");
        colors.put(7471375, "Venetian Red");
        colors.put(350601, "Venice Blue");
        colors.put(9602448, "Venus");
        colors.put(6118967, "Verdigris");
        colors.put(4805632, "Verdun Green");
        colors.put(11618827, "Vesuvius");
        colors.put(5457041, "Victoria");
        colors.put(5541913, "Vida Loca");
        colors.put(6606043, "Viking");
        colors.put(9977185, "Vin Rouge");
        colors.put(13340585, "Viola");
        colors.put(2690142, "Violent Violet");
        colors.put(2361920, "Violet");
        colors.put(6785397, "Viridian Green");
        colors.put(16773025, "Vis Vis");
        colors.put(9426612, "Vista Blue");
        colors.put(16578807, "Vista White");
        colors.put(5452885, "Voodoo");
        colors.put(1053213, "Vulcan");
        colors.put(14601158, "Wafer");
        colors.put(5926556, "Waikawa Grey");
        colors.put(3554317, "Waiouru");
        colors.put(7899685, "Wasabi");
        colors.put(10611166, "Water Leaf");
        colors.put(356183, "Watercourse");
        colors.put(14473031, "Wattle");
        colors.put(16768463, "Watusi");
        colors.put(16761000, "Wax Flower");
        colors.put(16243686, "We Peep");
        colors.put(5144478, "Wedgewood");
        colors.put(11809586, "Well Read");
        colors.put(6443289, "West Coast");
        colors.put(16748815, "West Side");
        colors.put(14473682, "Westar");
        colors.put(15834027, "Wewak");
        colors.put(15986127, "Wheatfield");
        colors.put(13998703, "Whiskey");
        colors.put(16250362, "Whisper");
        colors.put(14547441, "White Ice");
        colors.put(16316412, "White Lilac");
        colors.put(16314600, "White Linen");
        colors.put(16709887, "White Pointer");
        colors.put(15395028, "White Rock");
        colors.put(15523984, "Wild Rice");
        colors.put(16053492, "Wild Sand");
        colors.put(12174442, "Wild Willow");
        colors.put(3827820, "William");
        colors.put(14675162, "Willow Brook");
        colors.put(6648925, "Willow Grove");
        colors.put(3934328, "Windsor");
        colors.put(5840181, "Wine Berry");
        colors.put(14012821, "Winter Hazel");
        colors.put(16708856, "Wisp Pink");
        colors.put(10790611, "Wistful");
        colors.put(5067560, "Woodland");
        colors.put(3156495, "Woodrush");
        colors.put(789775, "Woodsmoke");
        colors.put(4731185, "Woody Brown");
        colors.put(7571064, "Xanadu");
        colors.put(7430968, "Yellow Metal");
        colors.put(16689412, "Yellow Sea");
        colors.put(16761792, "Your Pink");
        colors.put(8087048, "Yukon Gold");
        colors.put(13550225, "Yuma");
        colors.put(6837592, "Zambezi");
        colors.put(14347478, "Zanah");
        colors.put(15041563, "Zest");
        colors.put(2695961, "Zeus");
        colors.put(12573666, "Ziggurat");
        colors.put(16054527, "Zircon");
        colors.put(14997147, "Zombie");
        colors.put(10853265, "Zorba");
        colors.put(278562, "Zuccini");
        colors.put(15595263, "Zumthor");
    }

    /**
     * Returns a color name such as "Alabaster" for the given color
     *
     * @param color The hex value of the color, for example ff0000 (a bright red)
     * @return The name of the closest matching color, never null
     */
    public static String getColorName(String color) {
        if (color.length() != 6) {
            throw new IllegalArgumentException("Invalid color: " + color);
        }
        int given = Integer.parseInt(color, 16);
        if (colors.containsKey(given)) {
            return colors.get(given);
        }
        int givenRed = (given & 0xFF0000) >>> 16;
        int givenGreen = (given & 0xFF00) >>> 8;
        int givenBlue = given & 0xFF;
        Map.Entry<Integer, String> match = null;
        int matchDelta = Integer.MAX_VALUE;
        for (Map.Entry<Integer, String> entry : colors.entrySet()) {
            if (match == null) {
                match = entry;
            } else {
                int c = entry.getKey();
                int deltaRed = givenRed - ((c & 0xFF0000) >>> 16);
                int deltaGreen = givenGreen - ((c & 0xFF00) >>> 8);
                int deltaBlue = givenBlue - (c & 0xFF);
                int delta = (deltaRed * deltaRed) + (deltaGreen * deltaGreen) + (deltaBlue * deltaBlue);
                if (delta < matchDelta) {
                    match = entry;
                    matchDelta = delta;
                }
            }
        }
        assert (match != null);
        return match.getValue();
    }

    /**
     * Returns the perceived lightness of the color
     *
     * @param color The hex value of the color, for example ff0000 (a bright red)
     * @return The lightness, between 0 and 100 (inclusive)
     */
    public static int getLightness(String color) {
        int given = Integer.parseInt(color, 16);
        int givenRed = (given & 0xFF0000) >>> 16;
        int givenGreen = (given & 0xFF00) >>> 8;
        int givenBlue = given & 0xFF;
        return (int) Math.round((givenRed * 0.299 + givenGreen * 0.587 + givenBlue * 0.114) / 2.55);
    }

    /**
     * Returns the recommended foreground color, assuming the given color is used as background
     *
     * @param color The hex value of the color, for example ff0000 (a bright red)
     * @return The foreground color, 000000 (black) for light colors and ffffff (white) for dark colors
     */
    public static String getForeground(String color) {
        int lightness = getLightness(color);
        return (lightness > 50 ? "000000" : "ffffff");
    }
}
