/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.elasticsearch.boot.autoconfigure;

import internal.org.springframework.content.elasticsearch.ElasticsearchConfig;
import internal.org.springframework.content.elasticsearch.ElasticsearchIndexer;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchRestClientAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.content.commons.search.IndexService;
import org.springframework.content.elasticsearch.EnableElasticsearchFulltextIndexing;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;

@Configuration
@AutoConfigureAfter(value={ElasticsearchRestClientAutoConfiguration.class})
@ConditionalOnClass(value={RestHighLevelClient.class, EnableElasticsearchFulltextIndexing.class})
@Import(value={ElasticsearchConfig.class})
public class ElasticsearchAutoConfiguration {
    @ConditionalOnProperty(prefix="spring.content.elasticsearch", name={"autoindex"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={ElasticsearchIndexer.class})
    @Bean
    public ElasticsearchIndexer elasticFulltextIndexerEventListener(RestHighLevelClient client, IndexService elasticFulltextIndexService) throws IOException {
        return new ElasticsearchIndexer(client, elasticFulltextIndexService);
    }

    @Bean
    @ConditionalOnMissingBean(value={RestHighLevelClient.class})
    public RestHighLevelClient restHighLevelClient() {
        return new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost("localhost", 9200, "http")}));
    }

    @Component
    @ConfigurationProperties(prefix="spring.content.elasticsearch")
    public static class ElasticsearchProperties {
        boolean autoindex = true;

        public boolean getAutoindex() {
            return this.autoindex;
        }

        public void setAutoindex(boolean autoindex) {
            this.autoindex = autoindex;
        }
    }
}

