/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.azure.config;

import com.azure.spring.autoconfigure.storage.resource.AzureStorageProtocolResolver;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import internal.org.springframework.content.azure.store.DefaultAzureStorageImpl;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.content.commons.repository.factory.AbstractStoreFactoryBean;
import org.springframework.content.commons.utils.PlacementService;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.ResourceLoader;
import org.springframework.versions.LockingAndVersioningProxyFactory;

public class AzureStorageFactoryBean
extends AbstractStoreFactoryBean {
    @Autowired
    private ApplicationContext context;
    @Autowired
    private BlobServiceClientBuilder clientBuilder;
    private BlobServiceClient client;
    @Autowired
    private PlacementService s3StorePlacementService;
    @Autowired(required=false)
    private LockingAndVersioningProxyFactory versioning;
    @Autowired
    private AzureStorageProtocolResolver resolver;
    @Value(value="${spring.content.gcp.storage.bucket:#{environment.AZURE_STORAGE_BUCKET}}")
    private String bucket;

    public AzureStorageFactoryBean() {
    }

    @Autowired
    public AzureStorageFactoryBean(ApplicationContext context, BlobServiceClientBuilder client, PlacementService s3StorePlacementService) {
        this.context = context;
        this.client = client.buildClient();
        this.s3StorePlacementService = s3StorePlacementService;
    }

    protected void addProxyAdvice(ProxyFactory result, BeanFactory beanFactory) {
        if (this.versioning != null) {
            this.versioning.apply(result);
        }
    }

    protected Object getContentStoreImpl() {
        DefaultResourceLoader loader = new DefaultResourceLoader();
        loader.addProtocolResolver((ProtocolResolver)this.resolver);
        return new DefaultAzureStorageImpl(this.context, (ResourceLoader)loader, this.s3StorePlacementService, this.client);
    }
}

