/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.azure.config;

import com.azure.spring.autoconfigure.storage.resource.AzureStorageProtocolResolver;
import internal.org.springframework.content.azure.config.BlobIdResolverConverter;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.content.azure.Bucket;
import org.springframework.content.azure.config.AzureStorageConfigurer;
import org.springframework.content.azure.config.BlobId;
import org.springframework.content.commons.config.ContentPropertyInfo;
import org.springframework.content.commons.repository.StoreAccessException;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.commons.utils.PlacementService;
import org.springframework.content.commons.utils.PlacementServiceImpl;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;

@Configuration
@Import(value={AzureStorageProtocolResolver.class})
public class AzureStorageConfiguration {
    @Autowired(required=false)
    private List<AzureStorageConfigurer> configurers;
    @Value(value="${spring.content.azure.bucket:#{environment.AZURE_STORAGE_BUCKET}}")
    private String bucket;

    @Bean
    public PlacementService azureStoragePlacementService() {
        PlacementServiceImpl conversion = new PlacementServiceImpl();
        AzureStorageConfiguration.addDefaultConverters((PlacementService)conversion, this.bucket);
        this.addConverters((ConverterRegistry)conversion);
        return conversion;
    }

    public static void addDefaultConverters(PlacementService conversion, final String bucket) {
        conversion.addConverter((GenericConverter)new BlobIdResolverConverter(bucket));
        conversion.addConverter((Converter)new Converter<ContentPropertyInfo<Object, Serializable>, BlobId>(){
            private String defaultBucket;
            {
                this.defaultBucket = bucket;
            }

            public BlobId convert(ContentPropertyInfo<Object, Serializable> info) {
                String strBucket = null;
                Object bucket2 = BeanUtils.getFieldWithAnnotation((Object)info.entity(), Bucket.class);
                if (bucket2 == null) {
                    bucket2 = this.defaultBucket;
                }
                if (bucket2 == null) {
                    throw new StoreAccessException("Bucket not set");
                }
                strBucket = bucket2.toString();
                Serializable key = info.contentId();
                return key != null ? new BlobId(strBucket, key.toString()) : null;
            }
        });
    }

    private void addConverters(ConverterRegistry registry) {
        if (this.configurers == null) {
            return;
        }
        for (AzureStorageConfigurer configurer : this.configurers) {
            configurer.configureAzureStorageConverters(registry);
        }
    }
}

