/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.azure.store;

import com.azure.storage.blob.BlobServiceClient;
import internal.org.springframework.content.azure.io.AzureBlobResource;
import internal.org.springframework.content.commons.utils.ContentPropertyInfoTypeDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.azure.config.BlobId;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.annotations.ContentLength;
import org.springframework.content.commons.config.ContentPropertyInfo;
import org.springframework.content.commons.io.DeletableResource;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.repository.UnsetContentParams;
import org.springframework.content.commons.store.GetResourceParams;
import org.springframework.content.commons.store.SetContentParams;
import org.springframework.content.commons.store.StoreAccessException;
import org.springframework.content.commons.store.UnsetContentParams;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.commons.utils.Condition;
import org.springframework.content.commons.utils.PlacementService;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.WritableResource;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional
public class DefaultAzureStorageImpl<S, SID extends Serializable>
implements Store<SID>,
AssociativeStore<S, SID>,
ContentStore<S, SID>,
org.springframework.content.commons.store.ContentStore<S, SID> {
    private static Log logger = LogFactory.getLog(DefaultAzureStorageImpl.class);
    private ApplicationContext context;
    private ResourceLoader loader;
    private PlacementService placementService;
    private BlobServiceClient client;
    private MappingContext mappingContext;

    public DefaultAzureStorageImpl(ApplicationContext context, ResourceLoader loader, MappingContext mappingContext, PlacementService placementService, BlobServiceClient client) {
        Assert.notNull((Object)context, (String)"context must be specified");
        Assert.notNull((Object)loader, (String)"loader must be specified");
        Assert.notNull((Object)placementService, (String)"placementService must be specified");
        Assert.notNull((Object)client, (String)"client must be specified");
        this.context = context;
        this.loader = loader;
        this.placementService = placementService;
        this.client = client;
        this.mappingContext = mappingContext;
        if (this.mappingContext == null) {
            this.mappingContext = new MappingContext((CharSequence)"/", (CharSequence)".");
        }
    }

    public Resource getResource(SID id) {
        if (id == null) {
            return null;
        }
        if (!(id instanceof BlobId)) {
            BlobId blobId = null;
            if (this.placementService.canConvert(id.getClass(), BlobId.class)) {
                blobId = (BlobId)this.placementService.convert(id, BlobId.class);
                return this.getResourceInternal(blobId);
            }
            throw new StoreAccessException(String.format("Unable to convert from %s to BlobId", id));
        }
        return this.getResourceInternal((BlobId)id);
    }

    public Resource getResource(S entity) {
        if (entity == null) {
            return null;
        }
        BlobId blobId = null;
        if (this.placementService.canConvert(entity.getClass(), BlobId.class) && (blobId = (BlobId)this.placementService.convert(entity, BlobId.class)) != null) {
            return this.getResourceInternal(blobId);
        }
        Serializable contentId = (Serializable)BeanUtils.getFieldWithAnnotation(entity, ContentId.class);
        return this.getResource((S)contentId);
    }

    public Resource getResource(S entity, PropertyPath propertyPath) {
        return this.getResource(entity, propertyPath, GetResourceParams.builder().build());
    }

    public Resource getResource(S entity, PropertyPath propertyPath, org.springframework.content.commons.repository.GetResourceParams params) {
        return this.getResource(entity, propertyPath, GetResourceParams.builder().range(params.getRange()).build());
    }

    public Resource getResource(S entity, PropertyPath propertyPath, GetResourceParams params) {
        ContentPropertyInfo contentPropertyInfo;
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        if (entity == null) {
            return null;
        }
        BlobId blobId = null;
        TypeDescriptor contentPropertyInfoType = ContentPropertyInfoTypeDescriptor.withGenerics(entity, (ContentProperty)property);
        if (this.placementService.canConvert(contentPropertyInfoType, TypeDescriptor.valueOf(BlobId.class)) && (blobId = (BlobId)this.placementService.convert((Object)(contentPropertyInfo = ContentPropertyInfo.of(entity, (Serializable)((Serializable)property.getContentId(entity)), (PropertyPath)propertyPath, (ContentProperty)property)), BlobId.class)) != null) {
            return this.getResourceInternal(blobId);
        }
        Serializable contentId = (Serializable)property.getContentId(entity);
        return this.getResource((S)contentId);
    }

    protected Resource getResourceInternal(BlobId id) {
        String bucket = id.getBucket();
        String location = null;
        if (this.placementService.canConvert(BlobId.class, String.class)) {
            location = (String)this.placementService.convert((Object)id, String.class);
            location = this.absolutify(bucket, location);
        } else {
            String objectId = id.getName();
            location = (String)this.placementService.convert((Object)objectId, String.class);
            location = this.absolutify(bucket, location);
        }
        BlobServiceClient clientToUse = this.client;
        ResourceLoader loaderToUse = this.loader;
        Resource resource = loaderToUse.getResource(location);
        return new AzureBlobResource(clientToUse, bucket, resource);
    }

    public void associate(Object entity, Serializable id) {
        BeanUtils.setFieldWithAnnotation((Object)entity, ContentId.class, (Object)id);
    }

    public void associate(S entity, PropertyPath propertyPath, SID id) {
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        property.setContentId(entity, id, null);
    }

    public void unassociate(Object entity) {
        BeanUtils.setFieldWithAnnotationConditionally((Object)entity, ContentId.class, null, (Condition)new Condition(){

            public boolean matches(Field field) {
                for (Annotation annotation : field.getAnnotations()) {
                    if (!"jakarta.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public void unassociate(S entity, PropertyPath propertyPath) {
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        property.setContentId(entity, null, new org.springframework.content.commons.mappingcontext.Condition(){

            public boolean matches(TypeDescriptor descriptor) {
                for (Annotation annotation : descriptor.getAnnotations()) {
                    if (!"jakarta.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Transactional
    public S setContent(S entity, InputStream content) {
        Resource resource;
        Object contentId = BeanUtils.getFieldWithAnnotation(entity, ContentId.class);
        if (contentId == null) {
            String newId = UUID.randomUUID().toString();
            Object convertedId = this.placementService.convert((Object)newId, TypeDescriptor.forObject((Object)newId), TypeDescriptor.valueOf((Class)BeanUtils.getFieldWithAnnotationType(entity, ContentId.class)));
            BeanUtils.setFieldWithAnnotation(entity, ContentId.class, (Object)convertedId);
        }
        if ((resource = this.getResource(entity)) == null) {
            return entity;
        }
        try (OutputStream os = ((WritableResource)resource).getOutputStream();){
            IOUtils.copy((InputStream)content, (OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content for entity %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Setting content for entity %s", entity), (Throwable)e);
        }
        try {
            BeanUtils.setFieldWithAnnotation(entity, ContentLength.class, (Object)resource.contentLength());
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content length for entity %s", entity), (Throwable)e);
        }
        return entity;
    }

    @Transactional
    public S setContent(S entity, PropertyPath propertyPath, InputStream content) {
        return this.setContent(entity, propertyPath, content, -1L);
    }

    @Transactional
    public S setContent(S entity, PropertyPath propertyPath, InputStream content, long contentLen) {
        return this.setContent(entity, propertyPath, content, SetContentParams.builder().contentLength(contentLen).build());
    }

    public S setContent(S entity, PropertyPath propertyPath, InputStream content, org.springframework.content.commons.repository.SetContentParams params) {
        return this.setContent(entity, propertyPath, content, SetContentParams.builder().contentLength(params.getContentLength()).overwriteExistingContent(params.isOverwriteExistingContent()).build());
    }

    public S setContent(S entity, PropertyPath propertyPath, InputStream content, SetContentParams params) {
        Resource resource;
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        Object contentId = property.getContentId(entity);
        if (contentId == null || params.getDisposition().equals((Object)SetContentParams.ContentDisposition.CreateNew)) {
            String newId = UUID.randomUUID().toString();
            Object convertedId = this.placementService.convert((Object)newId, TypeDescriptor.forObject((Object)newId), property.getContentIdType(entity));
            property.setContentId(entity, convertedId, null);
        }
        if ((resource = this.getResource(entity, propertyPath)) == null) {
            return entity;
        }
        try (OutputStream os = ((WritableResource)resource).getOutputStream();){
            IOUtils.copy((InputStream)content, (OutputStream)os);
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content for entity %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Setting content for entity %s", entity), (Throwable)e);
        }
        try {
            long lenToSet = params.getContentLength();
            if (lenToSet == -1L) {
                lenToSet = resource.contentLength();
            }
            property.setContentLength(entity, (Object)lenToSet);
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content length for entity %s", entity), (Throwable)e);
        }
        return entity;
    }

    public S setContent(S property, Resource resourceContent) {
        try {
            return this.setContent(property, resourceContent.getInputStream());
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content for entity %s", property), (Throwable)e);
            throw new StoreAccessException(String.format("Setting content for entity %s", property), (Throwable)e);
        }
    }

    public S setContent(S property, PropertyPath propertyPath, Resource resourceContent) {
        try {
            return this.setContent(property, propertyPath, resourceContent.getInputStream());
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error setting content for entity %s", property), (Throwable)e);
            throw new StoreAccessException(String.format("Setting content for entity %s", property), (Throwable)e);
        }
    }

    @Transactional
    public InputStream getContent(S entity) {
        if (entity == null) {
            return null;
        }
        Resource resource = this.getResource(entity);
        try {
            if (resource != null && resource.exists()) {
                return resource.getInputStream();
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error getting content for entity %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Getting content for entity %s", entity), (Throwable)e);
        }
        return null;
    }

    @Transactional
    public InputStream getContent(S entity, PropertyPath propertyPath) {
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        if (entity == null) {
            return null;
        }
        Resource resource = this.getResource(entity, propertyPath);
        try {
            if (resource != null && resource.exists()) {
                return resource.getInputStream();
            }
        }
        catch (IOException e) {
            logger.error((Object)String.format("Unexpected error getting content for entity %s", entity), (Throwable)e);
            throw new StoreAccessException(String.format("Getting content for entity %s", entity), (Throwable)e);
        }
        return null;
    }

    @Transactional
    public S unsetContent(S entity) {
        if (entity == null) {
            return entity;
        }
        Resource resource = this.getResource(entity);
        if (resource != null && resource.exists() && resource instanceof DeletableResource) {
            try {
                ((DeletableResource)resource).delete();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Unexpected error unsetting content for entity %s", entity));
                throw new StoreAccessException(String.format("Unsetting content for entity %s", entity), (Throwable)e);
            }
        }
        BeanUtils.setFieldWithAnnotationConditionally(entity, ContentId.class, null, (Condition)new Condition(){

            public boolean matches(Field field) {
                for (Annotation annotation : field.getAnnotations()) {
                    if (!"jakarta.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                    return false;
                }
                return true;
            }
        });
        Class contentLenType = BeanUtils.getFieldWithAnnotationType(entity, ContentLength.class);
        if (contentLenType != null) {
            BeanUtils.setFieldWithAnnotation(entity, ContentLength.class, (Object)BeanUtils.getDefaultValueForType((Class)contentLenType));
        }
        return entity;
    }

    @Transactional
    public S unsetContent(S entity, PropertyPath propertyPath) {
        return this.unsetContent(entity, propertyPath, org.springframework.content.commons.store.UnsetContentParams.builder().build());
    }

    @Transactional
    public S unsetContent(S entity, PropertyPath propertyPath, UnsetContentParams params) {
        int ordinal = params.getDisposition().ordinal();
        org.springframework.content.commons.store.UnsetContentParams params1 = org.springframework.content.commons.store.UnsetContentParams.builder().disposition(UnsetContentParams.Disposition.values()[ordinal]).build();
        return this.unsetContent(entity, propertyPath, params1);
    }

    @Transactional
    public S unsetContent(S entity, PropertyPath propertyPath, org.springframework.content.commons.store.UnsetContentParams params) {
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        if (entity == null) {
            return entity;
        }
        Resource resource = this.getResource(entity, propertyPath);
        if (resource != null && resource.exists() && resource instanceof DeletableResource && params.getDisposition().equals((Object)UnsetContentParams.Disposition.Remove)) {
            try {
                ((DeletableResource)resource).delete();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Unexpected error unsetting content for entity %s", entity));
                throw new StoreAccessException(String.format("Unsetting content for entity %s", entity), (Throwable)e);
            }
        }
        if (resource != null) {
            property.setContentId(entity, null, new org.springframework.content.commons.mappingcontext.Condition(){

                public boolean matches(TypeDescriptor descriptor) {
                    for (Annotation annotation : descriptor.getAnnotations()) {
                        if (!"jakarta.persistence.Id".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.data.annotation.Id".equals(annotation.annotationType().getCanonicalName())) continue;
                        return false;
                    }
                    return true;
                }
            });
            property.setContentLength(entity, BeanUtils.getDefaultValueForType((Class)property.getContentLengthType().getType()));
        }
        return entity;
    }

    private String absolutify(String bucket, String location) {
        String locationToUse = null;
        Assert.state((!location.startsWith("azure-blob://") ? 1 : 0) != 0, (String)"resource location must start with azure-blob://");
        locationToUse = location.startsWith("/") ? location.substring(1) : location;
        return String.format("azure-blob://%s/%s", bucket, locationToUse);
    }
}

