/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.commons.repository.factory;

import internal.org.springframework.content.commons.config.StoreFragment;
import internal.org.springframework.content.commons.config.StoreFragments;
import internal.org.springframework.content.commons.repository.StoreInvokerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.content.commons.fragments.ContentStoreAware;
import org.springframework.content.commons.io.FileRemover;
import org.springframework.content.commons.io.ObservableInputStream;
import org.springframework.content.commons.repository.AfterStoreEvent;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.repository.StoreAccessException;
import org.springframework.content.commons.repository.StoreEvent;
import org.springframework.content.commons.repository.StoreExtension;
import org.springframework.content.commons.repository.events.AfterAssociateEvent;
import org.springframework.content.commons.repository.events.AfterGetContentEvent;
import org.springframework.content.commons.repository.events.AfterGetResourceEvent;
import org.springframework.content.commons.repository.events.AfterSetContentEvent;
import org.springframework.content.commons.repository.events.AfterUnassociateEvent;
import org.springframework.content.commons.repository.events.AfterUnsetContentEvent;
import org.springframework.content.commons.repository.events.BeforeAssociateEvent;
import org.springframework.content.commons.repository.events.BeforeGetContentEvent;
import org.springframework.content.commons.repository.events.BeforeGetResourceEvent;
import org.springframework.content.commons.repository.events.BeforeSetContentEvent;
import org.springframework.content.commons.repository.events.BeforeUnassociateEvent;
import org.springframework.content.commons.repository.events.BeforeUnsetContentEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class StoreMethodInterceptor
implements MethodInterceptor {
    private Map<Method, StoreExtension> extensions;
    private ContentStore<Object, Serializable> store = null;
    private ApplicationEventPublisher publisher;
    private StoreFragments storeFragments;
    private static Method getContentMethod = ReflectionUtils.findMethod(ContentStore.class, (String)"getContent", (Class[])new Class[]{Object.class});
    private static Method setContentMethod;
    private static Method unsetContentMethod;
    private static Method getResourceMethod;
    private static Method associativeGetResourceMethod;
    private static Method associateResourceMethod;
    private static Method unassociateResourceMethod;
    private static Method toStringMethod;
    private static Method setContentStoreMethod;
    private Class<?> domainClass = null;
    private Class<? extends Serializable> contentIdClass = null;

    public StoreMethodInterceptor(ContentStore<Object, Serializable> store, Class<?> domainClass, Class<? extends Serializable> contentIdClass, Map<Method, StoreExtension> extensions, ApplicationEventPublisher publisher) {
        if (extensions == null) {
            extensions = Collections.emptyMap();
        }
        this.store = store;
        this.domainClass = domainClass;
        this.contentIdClass = contentIdClass;
        this.extensions = extensions;
        this.publisher = publisher;
    }

    public void setStoreFragments(StoreFragments storeFragments) {
        this.storeFragments = storeFragments;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!this.isStoreMethod(invocation) && this.storeFragments != null) {
            Optional<StoreFragment> fragment = this.storeFragments.stream().filter(it -> it.hasMethod(invocation.getMethod())).findFirst();
            fragment.orElseThrow(() -> new IllegalStateException(String.format("No fragment found for method %s", invocation.getMethod())));
            StoreFragment f = fragment.get();
            if (f.hasImplementationMethod(setContentStoreMethod)) {
                ReflectionUtils.invokeMethod((Method)setContentStoreMethod, f.getImplementation(), (Object[])new Object[]{invocation.getThis()});
            }
            return invocation.getMethod().invoke(fragment.get().getImplementation(), invocation.getArguments());
        }
        Method method = invocation.getMethod();
        StoreExtension extension = this.extensions.get(method);
        if (extension != null) {
            return extension.invoke(invocation, new StoreInvokerImpl(this.domainClass, this.contentIdClass, invocation));
        }
        if (!this.isStoreMethod(invocation)) {
            throw new StoreAccessException(String.format("No implementation found for %s", method.getName()));
        }
        StoreEvent before = null;
        AfterStoreEvent after = null;
        File tmpStreamFile = null;
        TeeInputStream eventStream = null;
        if (getContentMethod.equals(invocation.getMethod())) {
            if (invocation.getArguments().length > 0) {
                before = new BeforeGetContentEvent(invocation.getArguments()[0], this.store);
                after = new AfterGetContentEvent(invocation.getArguments()[0], this.store);
            }
        } else if (setContentMethod.equals(invocation.getMethod())) {
            if (invocation.getArguments().length > 0) {
                tmpStreamFile = Files.createTempFile("sc", "bsce", new FileAttribute[0]).toFile();
                eventStream = new TeeInputStream((InputStream)invocation.getArguments()[1], new FileOutputStream(tmpStreamFile), true);
                before = new BeforeSetContentEvent(invocation.getArguments()[0], this.store, (InputStream)((Object)eventStream));
                after = new AfterSetContentEvent(invocation.getArguments()[0], this.store);
            }
        } else if (unsetContentMethod.equals(invocation.getMethod())) {
            if (invocation.getArguments().length > 0 && invocation.getArguments()[0] != null) {
                before = new BeforeUnsetContentEvent(invocation.getArguments()[0], this.store);
                after = new AfterUnsetContentEvent(invocation.getArguments()[0], this.store);
            }
        } else if (getResourceMethod.equals(invocation.getMethod())) {
            if (invocation.getArguments().length > 0 && invocation.getArguments()[0] != null) {
                before = new BeforeGetResourceEvent(invocation.getArguments()[0], this.store);
                after = new AfterGetResourceEvent(invocation.getArguments()[0], this.store);
            }
        } else if (associativeGetResourceMethod.equals(invocation.getMethod())) {
            if (invocation.getArguments().length > 0 && invocation.getArguments()[0] != null) {
                before = new BeforeGetResourceEvent(invocation.getArguments()[0], this.store);
                after = new AfterGetResourceEvent(invocation.getArguments()[0], this.store);
            }
        } else if (associateResourceMethod.equals(invocation.getMethod())) {
            if (invocation.getArguments().length > 0 && invocation.getArguments()[0] != null) {
                before = new BeforeAssociateEvent(invocation.getArguments()[0], this.store);
                after = new AfterAssociateEvent(invocation.getArguments()[0], this.store);
            }
        } else if (unassociateResourceMethod.equals(invocation.getMethod()) && invocation.getArguments().length > 0 && invocation.getArguments()[0] != null) {
            before = new BeforeUnassociateEvent(invocation.getArguments()[0], this.store);
            after = new AfterUnassociateEvent(invocation.getArguments()[0], this.store);
        }
        if (before != null) {
            this.publisher.publishEvent(before);
            if (before instanceof BeforeSetContentEvent && eventStream.isDirty()) {
                while (eventStream.read(new byte[4096]) != -1) {
                }
                eventStream.close();
                invocation.getArguments()[1] = new ObservableInputStream(new FileInputStream(tmpStreamFile), new FileRemover(tmpStreamFile));
            }
        }
        Object result = invocation.proceed();
        if (after != null) {
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    private boolean isStoreMethod(MethodInvocation invocation) {
        return getContentMethod.equals(invocation.getMethod()) || setContentMethod.equals(invocation.getMethod()) || unsetContentMethod.equals(invocation.getMethod()) || getResourceMethod.equals(invocation.getMethod()) || associativeGetResourceMethod.equals(invocation.getMethod()) || associateResourceMethod.equals(invocation.getMethod()) || unassociateResourceMethod.equals(invocation.getMethod()) || toStringMethod.equals(invocation.getMethod());
    }

    static {
        Assert.notNull((Object)getContentMethod);
        setContentMethod = ReflectionUtils.findMethod(ContentStore.class, (String)"setContent", (Class[])new Class[]{Object.class, InputStream.class});
        Assert.notNull((Object)setContentMethod);
        unsetContentMethod = ReflectionUtils.findMethod(ContentStore.class, (String)"unsetContent", (Class[])new Class[]{Object.class});
        Assert.notNull((Object)unsetContentMethod);
        getResourceMethod = ReflectionUtils.findMethod(Store.class, (String)"getResource", (Class[])new Class[]{Serializable.class});
        Assert.notNull((Object)getResourceMethod);
        associativeGetResourceMethod = ReflectionUtils.findMethod(AssociativeStore.class, (String)"getResource", (Class[])new Class[]{Object.class});
        Assert.notNull((Object)associativeGetResourceMethod);
        associateResourceMethod = ReflectionUtils.findMethod(AssociativeStore.class, (String)"associate", (Class[])new Class[]{Object.class, Serializable.class});
        Assert.notNull((Object)getResourceMethod);
        unassociateResourceMethod = ReflectionUtils.findMethod(AssociativeStore.class, (String)"unassociate", (Class[])new Class[]{Object.class});
        Assert.notNull((Object)getResourceMethod);
        toStringMethod = ReflectionUtils.findMethod(Object.class, (String)"toString");
        Assert.notNull((Object)toStringMethod);
        setContentStoreMethod = ReflectionUtils.findMethod(ContentStoreAware.class, (String)"setContentStore", (Class[])new Class[]{ContentStore.class});
        Assert.notNull((Object)setContentStoreMethod);
    }

    private static class TeeInputStream
    extends org.apache.commons.io.input.TeeInputStream {
        private boolean isDirty = false;

        public TeeInputStream(InputStream input, OutputStream branch, boolean closeBranch) {
            super(input, branch, closeBranch);
        }

        public int read() throws IOException {
            this.isDirty = true;
            return super.read();
        }

        public int read(byte[] bts, int st, int end) throws IOException {
            this.isDirty = true;
            return super.read(bts, st, end);
        }

        public int read(byte[] bts) throws IOException {
            this.isDirty = true;
            return super.read(bts);
        }

        public boolean isDirty() {
            return this.isDirty;
        }
    }
}

