/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.commons.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.content.commons.repository.factory.AbstractStoreFactoryBean;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ClassUtils;

class StoreInterfaceAwareBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanFactoryAware,
PriorityOrdered {
    private static final Log LOGGER = LogFactory.getLog(StoreInterfaceAwareBeanPostProcessor.class);
    private static final Class<?> REPOSITORY_TYPE = AbstractStoreFactoryBean.class;
    private final Map<String, Class<?>> cache = new ConcurrentHashMap();
    private ConfigurableListableBeanFactory context;

    StoreInterfaceAwareBeanPostProcessor() {
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.context = (ConfigurableListableBeanFactory)beanFactory;
        }
    }

    public Class<?> predictBeanType(Class<?> beanClass, String beanName) {
        if (null == this.context || !REPOSITORY_TYPE.isAssignableFrom(beanClass)) {
            return null;
        }
        Class<?> resolvedBeanClass = this.cache.get(beanName);
        if (resolvedBeanClass != null) {
            return resolvedBeanClass == Void.class ? null : resolvedBeanClass;
        }
        BeanDefinition definition = this.context.getBeanDefinition(beanName);
        PropertyValue value = definition.getPropertyValues().getPropertyValue("storeInterface");
        resolvedBeanClass = this.getClassForPropertyValue(value, beanName);
        this.cache.put(beanName, resolvedBeanClass);
        return resolvedBeanClass == Void.class ? null : resolvedBeanClass;
    }

    private Class<?> getClassForPropertyValue(PropertyValue propertyValue, String beanName) {
        Object value = propertyValue.getValue();
        String className = null;
        if (value instanceof TypedStringValue) {
            className = ((TypedStringValue)value).getValue();
        } else if (value instanceof String) {
            className = (String)value;
        } else {
            if (value instanceof Class) {
                return (Class)value;
            }
            return Void.class;
        }
        try {
            return ClassUtils.resolveClassName((String)className, (ClassLoader)this.context.getBeanClassLoader());
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn((Object)String.format("Couldn't load class %s referenced as repository interface in bean %s!", className, beanName));
            return Void.class;
        }
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

