/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.repository.events;

import org.springframework.content.commons.repository.StoreEvent;
import org.springframework.content.commons.repository.events.AfterAssociateEvent;
import org.springframework.content.commons.repository.events.AfterGetContentEvent;
import org.springframework.content.commons.repository.events.AfterGetResourceEvent;
import org.springframework.content.commons.repository.events.AfterSetContentEvent;
import org.springframework.content.commons.repository.events.AfterUnassociateEvent;
import org.springframework.content.commons.repository.events.AfterUnsetContentEvent;
import org.springframework.content.commons.repository.events.BeforeAssociateEvent;
import org.springframework.content.commons.repository.events.BeforeGetContentEvent;
import org.springframework.content.commons.repository.events.BeforeGetResourceEvent;
import org.springframework.content.commons.repository.events.BeforeSetContentEvent;
import org.springframework.content.commons.repository.events.BeforeUnassociateEvent;
import org.springframework.content.commons.repository.events.BeforeUnsetContentEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.GenericTypeResolver;

public abstract class AbstractStoreEventListener<T>
implements ApplicationListener<StoreEvent> {
    private final Class<?> INTERESTED_TYPE = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractStoreEventListener.class);

    public final void onApplicationEvent(StoreEvent event) {
        Class<?> srcType = event.getSource().getClass();
        if (null != this.INTERESTED_TYPE && !this.INTERESTED_TYPE.isAssignableFrom(srcType)) {
            return;
        }
        if (event instanceof BeforeGetResourceEvent) {
            this.onBeforeGetResource((BeforeGetResourceEvent)event);
            this.onBeforeGetResource(event.getSource());
        } else if (event instanceof AfterGetResourceEvent) {
            this.onAfterGetResource((AfterGetResourceEvent)event);
            this.onAfterGetResource(event.getSource());
        } else if (event instanceof BeforeAssociateEvent) {
            this.onBeforeAssociate((BeforeAssociateEvent)event);
            this.onBeforeAssociate(event.getSource());
        } else if (event instanceof AfterAssociateEvent) {
            this.onAfterAssociate((AfterAssociateEvent)event);
            this.onAfterAssociate(event.getSource());
        } else if (event instanceof BeforeUnassociateEvent) {
            this.onBeforeUnassociate((BeforeUnassociateEvent)event);
            this.onBeforeUnassociate(event.getSource());
        } else if (event instanceof AfterUnassociateEvent) {
            this.onAfterUnassociate((AfterUnassociateEvent)event);
            this.onAfterUnassociate(event.getSource());
        } else if (event instanceof BeforeGetContentEvent) {
            this.onBeforeGetContent((BeforeGetContentEvent)event);
            this.onBeforeGetContent(event.getSource());
        } else if (event instanceof AfterGetContentEvent) {
            this.onAfterGetContent((AfterGetContentEvent)event);
            this.onAfterGetContent(event.getSource());
        } else if (event instanceof BeforeSetContentEvent) {
            this.onBeforeSetContent((BeforeSetContentEvent)event);
            this.onBeforeSetContent(event.getSource());
        } else if (event instanceof AfterSetContentEvent) {
            this.onAfterSetContent((AfterSetContentEvent)event);
            this.onAfterSetContent(event.getSource());
        } else if (event instanceof BeforeUnsetContentEvent) {
            this.onBeforeUnsetContent((BeforeUnsetContentEvent)event);
            this.onBeforeUnsetContent(event.getSource());
        } else if (event instanceof AfterUnsetContentEvent) {
            this.onAfterUnsetContent((AfterUnsetContentEvent)event);
            this.onAfterUnsetContent(event.getSource());
        }
    }

    protected void onBeforeGetResource(BeforeGetResourceEvent event) {
    }

    protected void onBeforeGetResource(T entity) {
    }

    protected void onAfterGetResource(AfterGetResourceEvent event) {
    }

    protected void onAfterGetResource(T entity) {
    }

    protected void onBeforeAssociate(BeforeAssociateEvent event) {
    }

    protected void onBeforeAssociate(T entity) {
    }

    protected void onAfterAssociate(AfterAssociateEvent event) {
    }

    protected void onAfterAssociate(T entity) {
    }

    protected void onBeforeUnassociate(BeforeUnassociateEvent event) {
    }

    protected void onBeforeUnassociate(T entity) {
    }

    protected void onAfterUnassociate(AfterUnassociateEvent event) {
    }

    protected void onAfterUnassociate(T entity) {
    }

    protected void onBeforeGetContent(BeforeGetContentEvent event) {
    }

    protected void onBeforeGetContent(T entity) {
    }

    protected void onAfterGetContent(AfterGetContentEvent event) {
    }

    protected void onAfterGetContent(T entity) {
    }

    protected void onBeforeSetContent(BeforeSetContentEvent entity) {
    }

    protected void onBeforeSetContent(T entity) {
    }

    protected void onAfterSetContent(AfterSetContentEvent event) {
    }

    protected void onAfterSetContent(T entity) {
    }

    protected void onBeforeUnsetContent(BeforeUnsetContentEvent event) {
    }

    protected void onBeforeUnsetContent(T entity) {
    }

    protected void onAfterUnsetContent(AfterUnsetContentEvent event) {
    }

    protected void onAfterUnsetContent(T entity) {
    }
}

