/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.repository.factory;

import internal.org.springframework.content.commons.config.StoreFragments;
import internal.org.springframework.content.commons.repository.factory.StoreMethodInterceptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.repository.StoreExtension;
import org.springframework.content.commons.repository.factory.StoreFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.util.Assert;

public abstract class AbstractStoreFactoryBean
implements BeanFactoryAware,
InitializingBean,
FactoryBean<Store<? extends Serializable>>,
BeanClassLoaderAware,
ApplicationEventPublisherAware,
StoreFactory {
    private static Log logger = LogFactory.getLog(AbstractStoreFactoryBean.class);
    private Class<? extends Store<Serializable>> storeInterface;
    private ClassLoader classLoader;
    private ApplicationEventPublisher publisher;
    private Store<? extends Serializable> store;
    @Autowired(required=false)
    private Set<StoreExtension> extensions = Collections.emptySet();
    private StoreFragments storeFragments;
    private BeanFactory beanFactory;

    @Autowired
    public void setStoreInterface(Class<? extends Store<Serializable>> storeInterface) {
        Assert.notNull(storeInterface);
        this.storeInterface = storeInterface;
    }

    @Autowired
    public void setStoreFragments(StoreFragments storeFragments) {
        this.storeFragments = storeFragments;
    }

    @Override
    public Class<?> getStoreInterface() {
        return this.storeInterface;
    }

    public Store<Serializable> getStore() {
        return this.getObject();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public Store<? extends Serializable> getObject() {
        return this.initAndReturn();
    }

    public Class<? extends Store<? extends Serializable>> getObjectType() {
        return null == this.storeInterface ? Store.class : this.storeInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.initAndReturn();
    }

    private Store<? extends Serializable> initAndReturn() {
        if (this.store == null) {
            this.store = this.createContentStore();
        }
        return this.store;
    }

    protected Store<? extends Serializable> createContentStore() {
        Object target = this.getContentStoreImpl();
        ProxyFactory result = new ProxyFactory();
        result.setTarget(target);
        result.setInterfaces(new Class[]{this.storeInterface, Store.class, ContentStore.class});
        HashMap<Method, StoreExtension> extensionsMap = new HashMap<Method, StoreExtension>();
        try {
            for (StoreExtension extension : this.extensions) {
                for (Method method : extension.getMethods()) {
                    extensionsMap.put(method, extension);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to setup extensions", (Throwable)e);
        }
        this.addProxyAdvice(result, this.beanFactory);
        StoreMethodInterceptor intercepter = new StoreMethodInterceptor((ContentStore)target, AbstractStoreFactoryBean.getDomainClass(this.storeInterface), AbstractStoreFactoryBean.getContentIdClass(this.storeInterface), extensionsMap, this.publisher);
        intercepter.setStoreFragments(this.storeFragments);
        result.addAdvice((Advice)intercepter);
        return (Store)result.getProxy(this.classLoader);
    }

    public static Class<?> getDomainClass(Class<?> repositoryClass) {
        return AbstractStoreFactoryBean.getStoreParameter(repositoryClass, 0);
    }

    public static Class<? extends Serializable> getContentIdClass(Class<?> repositoryClass) {
        return AbstractStoreFactoryBean.getStoreParameter(repositoryClass, 1);
    }

    private static Class<?> getStoreParameter(Class<?> repositoryClass, int index) {
        Type[] types;
        Class clazz = null;
        for (Type t : types = repositoryClass.getGenericInterfaces()) {
            if (!(t instanceof ParameterizedType)) continue;
            ParameterizedType pt = (ParameterizedType)t;
            if (pt.getRawType().getTypeName().equals(Store.class.getCanonicalName())) {
                types = pt.getActualTypeArguments();
                if (types.length != 1) {
                    throw new IllegalStateException(String.format("Store class %s must have a contentId type", repositoryClass.getCanonicalName()));
                }
                if (!(types[0] instanceof Class)) continue;
                clazz = (Class)types[0];
                continue;
            }
            if (!pt.getRawType().getTypeName().equals(AssociativeStore.class.getCanonicalName()) && !pt.getRawType().getTypeName().equals(ContentStore.class.getCanonicalName())) continue;
            types = pt.getActualTypeArguments();
            if (types.length != 2) {
                throw new IllegalStateException(String.format("ContentRepository class %s must have domain and contentId types", repositoryClass.getCanonicalName()));
            }
            if (!(types[index] instanceof Class)) continue;
            clazz = (Class)types[index];
        }
        return clazz;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected void addProxyAdvice(ProxyFactory result, BeanFactory beanFactory) {
    }

    protected abstract Object getContentStoreImpl();
}

