/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.commons.store.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.UnsetContentParams;
import org.springframework.content.commons.repository.events.AfterGetResourceEvent;
import org.springframework.content.commons.repository.events.AfterUnassociateEvent;
import org.springframework.content.commons.repository.events.AfterUnsetContentEvent;
import org.springframework.content.commons.repository.events.BeforeGetResourceEvent;
import org.springframework.content.commons.repository.events.BeforeSetContentEvent;
import org.springframework.content.commons.repository.events.BeforeUnassociateEvent;
import org.springframework.content.commons.store.GetResourceParams;
import org.springframework.content.commons.store.SetContentParams;
import org.springframework.content.commons.store.Store;
import org.springframework.content.commons.store.UnsetContentParams;
import org.springframework.content.commons.store.events.AfterAssociateEvent;
import org.springframework.content.commons.store.events.AfterGetContentEvent;
import org.springframework.content.commons.store.events.AfterSetContentEvent;
import org.springframework.content.commons.store.events.BeforeAssociateEvent;
import org.springframework.content.commons.store.events.BeforeGetContentEvent;
import org.springframework.content.commons.store.events.BeforeUnsetContentEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.Resource;

public class StoreImpl
implements ContentStore<Object, Serializable>,
org.springframework.content.commons.store.ContentStore<Object, Serializable> {
    private static final Log logger = LogFactory.getLog(StoreImpl.class);
    private final org.springframework.content.commons.repository.Store<Serializable> delegate;
    private final ApplicationEventPublisher publisher;
    private final Path copyContentRootPath;

    public StoreImpl(org.springframework.content.commons.repository.Store<Serializable> delegate, ApplicationEventPublisher publisher, Path copyContentRootPath) {
        this.delegate = delegate;
        this.publisher = publisher;
        this.copyContentRootPath = copyContentRootPath;
    }

    @Override
    public Object setContent(Object entity, InputStream content) {
        return this.internalSetContent(entity, null, content, (InputStream actualContent) -> {
            if (this.delegate instanceof org.springframework.content.commons.store.ContentStore) {
                return ((org.springframework.content.commons.store.ContentStore)this.delegate).setContent(entity, (InputStream)actualContent);
            }
            return ((ContentStore)this.delegate).setContent(entity, (InputStream)actualContent);
        });
    }

    @Override
    public Object setContent(Object entity, PropertyPath propertyPath, InputStream content) {
        return this.internalSetContent(entity, propertyPath, content, (InputStream actualContent) -> {
            if (this.delegate instanceof org.springframework.content.commons.store.ContentStore) {
                return ((org.springframework.content.commons.store.ContentStore)this.delegate).setContent(entity, propertyPath, (InputStream)actualContent);
            }
            return ((ContentStore)this.delegate).setContent(entity, propertyPath, (InputStream)actualContent);
        });
    }

    @Override
    public Object setContent(Object entity, PropertyPath propertyPath, InputStream content, long contentLen) {
        return this.internalSetContent(entity, propertyPath, content, (InputStream actualContent) -> {
            if (this.delegate instanceof org.springframework.content.commons.store.ContentStore) {
                return ((org.springframework.content.commons.store.ContentStore)this.delegate).setContent(entity, propertyPath, (InputStream)actualContent, contentLen);
            }
            return ((ContentStore)this.delegate).setContent(entity, propertyPath, (InputStream)actualContent, contentLen);
        });
    }

    @Override
    public Object setContent(Object entity, PropertyPath propertyPath, InputStream content, org.springframework.content.commons.repository.SetContentParams params) {
        return this.internalSetContent(entity, propertyPath, content, (InputStream actualContent) -> ((ContentStore)this.delegate).setContent(entity, propertyPath, (InputStream)actualContent, params));
    }

    @Override
    public Object setContent(Object entity, PropertyPath propertyPath, InputStream content, SetContentParams params) {
        return this.internalSetContent(entity, propertyPath, content, (InputStream actualContent) -> ((org.springframework.content.commons.store.ContentStore)this.delegate).setContent(entity, propertyPath, (InputStream)actualContent, params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object internalSetContent(Object property, PropertyPath propertyPath, InputStream content, Function<InputStream, Object> invocation) {
        File contentCopy;
        Object result;
        block27: {
            result = null;
            contentCopy = null;
            TeeInputStream contentCopyStream = null;
            try {
                contentCopy = Files.createTempFile(this.copyContentRootPath, "contentCopy", ".tmp", new FileAttribute[0]).toFile();
                contentCopyStream = new TeeInputStream(content, new FileOutputStream(contentCopy), true);
                BeforeSetContentEvent oldBefore = null;
                org.springframework.content.commons.store.events.BeforeSetContentEvent before = null;
                oldBefore = new BeforeSetContentEvent(property, propertyPath, this.delegate, (InputStream)((Object)contentCopyStream));
                this.publisher.publishEvent((ApplicationEvent)oldBefore);
                org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
                if (contentStore != null) {
                    before = new org.springframework.content.commons.store.events.BeforeSetContentEvent(property, propertyPath, contentStore, (InputStream)((Object)contentCopyStream));
                    this.publisher.publishEvent((ApplicationEvent)before);
                }
                if (oldBefore != null && oldBefore.getInputStream() != null && !oldBefore.getInputStream().equals((Object)contentCopyStream)) {
                    content = oldBefore.getInputStream();
                } else if (before != null && before.getInputStream() != null && !before.getInputStream().equals((Object)contentCopyStream)) {
                    content = before.getInputStream();
                } else if (contentCopyStream != null && contentCopyStream.isDirty()) {
                    while (contentCopyStream.read(new byte[4096]) != -1) {
                    }
                    content = new FileInputStream(contentCopy);
                }
                result = invocation.apply(content);
                org.springframework.content.commons.repository.events.AfterSetContentEvent oldAfter = new org.springframework.content.commons.repository.events.AfterSetContentEvent(property, propertyPath, this.delegate);
                oldAfter.setResult(result);
                this.publisher.publishEvent((ApplicationEvent)oldAfter);
                if (contentStore != null) {
                    AfterSetContentEvent after = new AfterSetContentEvent(property, propertyPath, contentStore);
                    after.setResult(result);
                    this.publisher.publishEvent((ApplicationEvent)after);
                }
                if (contentCopyStream == null) break block27;
            }
            catch (FileNotFoundException fileNotFoundException) {
                block28: {
                    fileNotFoundException.printStackTrace();
                    if (contentCopyStream == null) break block28;
                    IOUtils.closeQuietly(contentCopyStream);
                }
                if (contentCopy != null) {
                    try {
                        Files.deleteIfExists(contentCopy.toPath());
                    }
                    catch (IOException e) {
                        logger.error((Object)String.format("Unable to delete content copy %s", contentCopy.toPath()), (Throwable)e);
                    }
                }
            }
            catch (IOException ioException) {
                block29: {
                    ioException.printStackTrace();
                    if (contentCopyStream == null) break block29;
                    {
                        catch (Throwable throwable) {
                            if (contentCopyStream != null) {
                                IOUtils.closeQuietly(contentCopyStream);
                            }
                            if (contentCopy != null) {
                                try {
                                    Files.deleteIfExists(contentCopy.toPath());
                                }
                                catch (IOException e) {
                                    logger.error((Object)String.format("Unable to delete content copy %s", contentCopy.toPath()), (Throwable)e);
                                }
                            }
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly(contentCopyStream);
                }
                if (contentCopy != null) {
                    try {
                        Files.deleteIfExists(contentCopy.toPath());
                    }
                    catch (IOException e) {
                        logger.error((Object)String.format("Unable to delete content copy %s", contentCopy.toPath()), (Throwable)e);
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)((Object)contentCopyStream));
        }
        if (contentCopy != null) {
            try {
                Files.deleteIfExists(contentCopy.toPath());
            }
            catch (IOException e) {
                logger.error((Object)String.format("Unable to delete content copy %s", contentCopy.toPath()), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public Object setContent(Object entity, Resource resourceContent) {
        return this.internalSetContent(entity, null, resourceContent, () -> {
            if (this.delegate instanceof org.springframework.content.commons.store.ContentStore) {
                return ((org.springframework.content.commons.store.ContentStore)this.delegate).setContent(entity, resourceContent);
            }
            return ((ContentStore)this.delegate).setContent(entity, resourceContent);
        });
    }

    @Override
    public Object setContent(Object entity, PropertyPath propertyPath, Resource resourceContent) {
        return this.internalSetContent(entity, propertyPath, resourceContent, () -> {
            if (this.delegate instanceof org.springframework.content.commons.store.ContentStore) {
                return ((org.springframework.content.commons.store.ContentStore)this.delegate).setContent(entity, propertyPath, resourceContent);
            }
            return ((ContentStore)this.delegate).setContent(entity, propertyPath, resourceContent);
        });
    }

    public Object internalSetContent(Object property, PropertyPath propertyPath, Resource resourceContent, Supplier invocation) {
        BeforeSetContentEvent oldBefore = new BeforeSetContentEvent(property, propertyPath, this.delegate, resourceContent);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.BeforeSetContentEvent before = new org.springframework.content.commons.store.events.BeforeSetContentEvent(property, propertyPath, contentStore, resourceContent);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        Object result = invocation.get();
        org.springframework.content.commons.repository.events.AfterSetContentEvent oldAfter = new org.springframework.content.commons.repository.events.AfterSetContentEvent(property, propertyPath, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            AfterSetContentEvent after = new AfterSetContentEvent(property, propertyPath, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    @Override
    public Object unsetContent(Object entity) {
        return this.internalUnsetContent(entity, null, () -> {
            if (this.delegate instanceof org.springframework.content.commons.store.ContentStore) {
                return ((org.springframework.content.commons.store.ContentStore)this.delegate).unsetContent(entity);
            }
            return ((ContentStore)this.delegate).unsetContent(entity);
        });
    }

    @Override
    public Object unsetContent(Object entity, PropertyPath propertyPath) {
        return this.internalUnsetContent(entity, propertyPath, () -> {
            if (this.delegate instanceof org.springframework.content.commons.store.ContentStore) {
                return ((org.springframework.content.commons.store.ContentStore)this.delegate).unsetContent(entity, propertyPath);
            }
            return ((ContentStore)this.delegate).unsetContent(entity, propertyPath);
        });
    }

    @Override
    public Object unsetContent(Object entity, PropertyPath propertyPath, UnsetContentParams params) {
        return this.internalUnsetContent(entity, propertyPath, () -> {
            if (this.delegate instanceof org.springframework.content.commons.store.ContentStore) {
                int ordinal = params.getDisposition().ordinal();
                org.springframework.content.commons.store.UnsetContentParams params1 = org.springframework.content.commons.store.UnsetContentParams.builder().disposition(UnsetContentParams.Disposition.values()[ordinal]).build();
                return ((org.springframework.content.commons.store.ContentStore)this.delegate).unsetContent(entity, propertyPath, params1);
            }
            return ((ContentStore)this.delegate).unsetContent(entity, propertyPath, params);
        });
    }

    @Override
    public Object unsetContent(Object entity, PropertyPath propertyPath, org.springframework.content.commons.store.UnsetContentParams params) {
        return this.internalUnsetContent(entity, propertyPath, () -> {
            if (this.delegate instanceof org.springframework.content.commons.store.ContentStore) {
                return ((org.springframework.content.commons.store.ContentStore)this.delegate).unsetContent(entity, propertyPath, params);
            }
            int ordinal = params.getDisposition().ordinal();
            UnsetContentParams params1 = UnsetContentParams.builder().disposition(UnsetContentParams.Disposition.values()[ordinal]).build();
            return ((ContentStore)this.delegate).unsetContent(entity, propertyPath, params1);
        });
    }

    public Object internalUnsetContent(Object entity, PropertyPath propertyPath, Supplier invocation) {
        org.springframework.content.commons.repository.events.BeforeUnsetContentEvent oldBefore = new org.springframework.content.commons.repository.events.BeforeUnsetContentEvent(entity, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            BeforeUnsetContentEvent before = new BeforeUnsetContentEvent(entity, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        Object result = invocation.get();
        AfterUnsetContentEvent oldAfter = new AfterUnsetContentEvent(entity, propertyPath, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.AfterUnsetContentEvent after = new org.springframework.content.commons.store.events.AfterUnsetContentEvent(entity, propertyPath, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    @Override
    public InputStream getContent(Object entity) {
        return this.internalGetContent(entity, null, () -> {
            if (this.delegate instanceof org.springframework.content.commons.store.ContentStore) {
                return ((org.springframework.content.commons.store.ContentStore)this.delegate).getContent(entity);
            }
            return ((ContentStore)this.delegate).getContent(entity);
        });
    }

    @Override
    public InputStream getContent(Object entity, PropertyPath propertyPath) {
        return this.internalGetContent(entity, propertyPath, () -> {
            if (this.delegate instanceof org.springframework.content.commons.store.ContentStore) {
                return ((org.springframework.content.commons.store.ContentStore)this.delegate).getContent(entity, propertyPath);
            }
            return ((ContentStore)this.delegate).getContent(entity, propertyPath);
        });
    }

    public InputStream internalGetContent(Object entity, PropertyPath propertyPath, Supplier<InputStream> invocation) {
        org.springframework.content.commons.repository.events.BeforeGetContentEvent oldBefore = new org.springframework.content.commons.repository.events.BeforeGetContentEvent(entity, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            BeforeGetContentEvent before = new BeforeGetContentEvent(entity, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        InputStream result = invocation.get();
        org.springframework.content.commons.repository.events.AfterGetContentEvent oldAfter = new org.springframework.content.commons.repository.events.AfterGetContentEvent(entity, propertyPath, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (oldAfter.getResult() != null) {
            result = (InputStream)oldAfter.getResult();
        }
        if (contentStore != null) {
            AfterGetContentEvent after = new AfterGetContentEvent(entity, propertyPath, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
            if (after.getResult() != null) {
                result = (InputStream)after.getResult();
            }
        }
        return result;
    }

    @Override
    public Resource getResource(Object entity) {
        return this.internalGetResource(entity, null, () -> {
            if (this.delegate instanceof Store) {
                return ((org.springframework.content.commons.store.AssociativeStore)this.delegate).getResource(entity);
            }
            return ((AssociativeStore)this.delegate).getResource(entity);
        });
    }

    @Override
    public Resource getResource(Object entity, PropertyPath propertyPath) {
        return this.internalGetResource(entity, propertyPath, () -> {
            if (this.delegate instanceof org.springframework.content.commons.store.AssociativeStore) {
                return ((org.springframework.content.commons.store.AssociativeStore)this.delegate).getResource(entity, propertyPath);
            }
            return ((AssociativeStore)this.delegate).getResource(entity, propertyPath);
        });
    }

    @Override
    public Resource getResource(Object entity, PropertyPath propertyPath, org.springframework.content.commons.repository.GetResourceParams oldParams) {
        return this.internalGetResource(entity, propertyPath, () -> ((AssociativeStore)this.delegate).getResource(entity, propertyPath, oldParams));
    }

    @Override
    public Resource getResource(Object entity, PropertyPath propertyPath, GetResourceParams params) {
        return this.internalGetResource(entity, propertyPath, () -> ((org.springframework.content.commons.store.AssociativeStore)this.delegate).getResource(entity, propertyPath, params));
    }

    public Resource internalGetResource(Object entity, PropertyPath propertyPath, Supplier<Resource> invocation) {
        BeforeGetResourceEvent oldBefore = new BeforeGetResourceEvent(entity, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.BeforeGetResourceEvent before = new org.springframework.content.commons.store.events.BeforeGetResourceEvent(entity, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        Resource result = invocation.get();
        AfterGetResourceEvent oldAfter = new AfterGetResourceEvent(entity, propertyPath, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (oldAfter.getResult() != null) {
            result = (Resource)oldAfter.getResult();
        }
        if (contentStore != null) {
            org.springframework.content.commons.store.events.AfterGetResourceEvent after = new org.springframework.content.commons.store.events.AfterGetResourceEvent(entity, propertyPath, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
            if (after.getStore() != null) {
                result = (Resource)after.getResult();
            }
        }
        return result;
    }

    @Override
    public Resource getResource(Serializable id) {
        BeforeGetResourceEvent oldBefore = new BeforeGetResourceEvent(id, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.BeforeGetResourceEvent before = new org.springframework.content.commons.store.events.BeforeGetResourceEvent((Object)id, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        Resource result = this.delegate instanceof Store ? ((Store)this.delegate).getResource(id) : this.delegate.getResource(id);
        AfterGetResourceEvent oldAfter = new AfterGetResourceEvent(id, this.delegate);
        oldAfter.setResult(result);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.AfterGetResourceEvent after = new org.springframework.content.commons.store.events.AfterGetResourceEvent((Object)id, contentStore);
            after.setResult(result);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
        return result;
    }

    @Override
    public void associate(Object entity, Serializable id) {
        org.springframework.content.commons.repository.events.BeforeAssociateEvent oldBefore = new org.springframework.content.commons.repository.events.BeforeAssociateEvent(entity, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            BeforeAssociateEvent before = new BeforeAssociateEvent(entity, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        if (this.delegate instanceof org.springframework.content.commons.store.AssociativeStore) {
            ((org.springframework.content.commons.store.AssociativeStore)this.delegate).associate(entity, id);
        } else {
            ((AssociativeStore)this.delegate).associate(entity, id);
        }
        org.springframework.content.commons.repository.events.AfterAssociateEvent oldAfter = new org.springframework.content.commons.repository.events.AfterAssociateEvent(entity, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            AfterAssociateEvent after = new AfterAssociateEvent(entity, contentStore);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
    }

    @Override
    public void associate(Object entity, PropertyPath propertyPath, Serializable id) {
        org.springframework.content.commons.repository.events.BeforeAssociateEvent oldBefore = new org.springframework.content.commons.repository.events.BeforeAssociateEvent(entity, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            BeforeAssociateEvent before = new BeforeAssociateEvent(entity, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        if (this.delegate instanceof org.springframework.content.commons.store.AssociativeStore) {
            ((org.springframework.content.commons.store.AssociativeStore)this.delegate).associate(entity, propertyPath, id);
        } else {
            ((AssociativeStore)this.delegate).associate(entity, propertyPath, id);
        }
        org.springframework.content.commons.repository.events.AfterAssociateEvent oldAfter = new org.springframework.content.commons.repository.events.AfterAssociateEvent(entity, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            AfterAssociateEvent after = new AfterAssociateEvent(entity, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
    }

    @Override
    public void unassociate(Object entity) {
        BeforeUnassociateEvent oldBefore = new BeforeUnassociateEvent(entity, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.BeforeUnassociateEvent before = new org.springframework.content.commons.store.events.BeforeUnassociateEvent(entity, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        if (this.delegate instanceof org.springframework.content.commons.store.AssociativeStore) {
            ((org.springframework.content.commons.store.AssociativeStore)this.delegate).unassociate(entity);
        } else {
            ((AssociativeStore)this.delegate).unassociate(entity);
        }
        AfterUnassociateEvent oldAfter = new AfterUnassociateEvent(entity, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.AfterUnassociateEvent after = new org.springframework.content.commons.store.events.AfterUnassociateEvent(entity, contentStore);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
    }

    @Override
    public void unassociate(Object entity, PropertyPath propertyPath) {
        BeforeUnassociateEvent oldBefore = new BeforeUnassociateEvent(entity, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldBefore);
        org.springframework.content.commons.store.ContentStore contentStore = this.castToContentStore(this.delegate);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.BeforeUnassociateEvent before = new org.springframework.content.commons.store.events.BeforeUnassociateEvent(entity, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)before);
        }
        if (this.delegate instanceof org.springframework.content.commons.store.AssociativeStore) {
            ((org.springframework.content.commons.store.AssociativeStore)this.delegate).unassociate(entity, propertyPath);
        } else {
            ((AssociativeStore)this.delegate).unassociate(entity, propertyPath);
        }
        AfterUnassociateEvent oldAfter = new AfterUnassociateEvent(entity, propertyPath, this.delegate);
        this.publisher.publishEvent((ApplicationEvent)oldAfter);
        if (contentStore != null) {
            org.springframework.content.commons.store.events.AfterUnassociateEvent after = new org.springframework.content.commons.store.events.AfterUnassociateEvent(entity, propertyPath, contentStore);
            this.publisher.publishEvent((ApplicationEvent)after);
        }
    }

    private <SID extends Serializable> org.springframework.content.commons.store.ContentStore<Object, SID> castToContentStore(org.springframework.content.commons.repository.Store<Serializable> delegate) {
        if (!(delegate instanceof org.springframework.content.commons.store.ContentStore)) {
            return null;
        }
        return (org.springframework.content.commons.store.ContentStore)delegate;
    }

    static class TeeInputStream
    extends org.apache.commons.io.input.TeeInputStream {
        private boolean isDirty = false;

        public TeeInputStream(InputStream input, OutputStream branch, boolean closeBranch) {
            super(input, branch, closeBranch);
        }

        public int read() throws IOException {
            this.isDirty = true;
            return super.read();
        }

        public int read(byte[] bts, int st, int end) throws IOException {
            this.isDirty = true;
            return super.read(bts, st, end);
        }

        public int read(byte[] bts) throws IOException {
            this.isDirty = true;
            return super.read(bts);
        }

        public void close() throws IOException {
            super.close();
        }

        public boolean isDirty() {
            return this.isDirty;
        }
    }
}

