/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.fragments;

import internal.org.springframework.content.commons.renditions.RenditionServiceImpl;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.annotations.MimeType;
import org.springframework.content.commons.fragments.ContentStoreAware;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.renditions.Renderable;
import org.springframework.content.commons.renditions.RenditionProvider;
import org.springframework.content.commons.renditions.RenditionService;
import org.springframework.content.commons.store.ContentStore;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.core.io.Resource;

public class RenderableImpl
implements Renderable,
ContentStoreAware {
    private static final Log LOGGER = LogFactory.getLog(RenderableImpl.class);
    private ContentStore store;
    private org.springframework.content.commons.repository.ContentStore<Object, Serializable> contentStore;
    private MappingContext mappingContext;
    private RenditionService renditionService = null;
    private List<RenditionProvider> providers = new ArrayList<RenditionProvider>();

    public RenderableImpl() {
        this.mappingContext = new MappingContext("/", ".");
    }

    @Autowired(required=false)
    public void setRenditionProviders(RenditionProvider ... providers) {
        for (RenditionProvider provider : providers) {
            this.providers.add(provider);
        }
    }

    @Override
    public void setDomainClass(Class<?> domainClass) {
    }

    @Override
    public void setIdClass(Class<?> idClass) {
    }

    @Override
    public void setContentStore(org.springframework.content.commons.repository.ContentStore store) {
        this.contentStore = store;
    }

    @Override
    public void setContentStore(ContentStore store) {
        this.store = store;
    }

    public RenditionService getRenditionService() {
        if (this.renditionService == null) {
            this.renditionService = new RenditionServiceImpl(this.providers.toArray(new RenditionProvider[0]));
        }
        return this.renditionService;
    }

    @Autowired(required=false)
    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public InputStream getRendition(Object entity, String mimeType) {
        String fromMimeType = null;
        fromMimeType = (String)BeanUtils.getFieldWithAnnotation(entity, MimeType.class);
        if (fromMimeType == null) {
            return null;
        }
        if (this.getRenditionService().canConvert(fromMimeType, mimeType)) {
            InputStream content = null;
            try {
                if (this.store != null) {
                    content = this.store.getContent(entity);
                } else if (this.contentStore != null) {
                    content = this.contentStore.getContent(entity);
                }
                if (content != null) {
                    return this.getRenditionService().convert(fromMimeType, content, mimeType);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)String.format("Failed to get rendition from %s to %s", fromMimeType, mimeType), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getRendition(Object entity, PropertyPath propertyPath, String mimeType) {
        Object fromMimeType = null;
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (property == null) {
            return null;
        }
        fromMimeType = property.getMimeType(entity);
        if (fromMimeType == null) {
            return null;
        }
        if (!this.getRenditionService().canConvert(fromMimeType.toString(), mimeType)) return null;
        try {
            Resource r = null;
            if (this.store != null) {
                r = this.store.getResource(entity, propertyPath);
            } else if (this.contentStore != null) {
                r = this.contentStore.getResource(entity, propertyPath);
            }
            if (r == null) return null;
            try (InputStream content = r.getInputStream();){
                if (content == null) return null;
                InputStream inputStream = this.getRenditionService().convert(fromMimeType.toString(), content, mimeType);
                return inputStream;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)String.format("Failed to get rendition from %s to %s", fromMimeType, mimeType), (Throwable)e);
        }
        return null;
    }

    public boolean hasRendition(Object entity, String mimeType) {
        String fromMimeType = null;
        fromMimeType = (String)BeanUtils.getFieldWithAnnotation(entity, MimeType.class);
        if (fromMimeType == null) {
            return false;
        }
        return this.getRenditionService().canConvert(fromMimeType, mimeType);
    }

    public boolean hasRendition(Object entity, PropertyPath propertyPath, String mimeType) {
        ContentProperty property = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        Object fromMimeType = null;
        fromMimeType = property.getMimeType(entity);
        if (fromMimeType == null) {
            return false;
        }
        return this.getRenditionService().canConvert(fromMimeType.toString(), mimeType);
    }
}

