/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.springframework.content.commons.io.CloseableObserver;

public class ObservableInputStream
extends InputStream {
    private final InputStream is;
    private final CloseableObserver observer;

    public ObservableInputStream(InputStream is, CloseableObserver observer) {
        this.is = is;
        this.observer = observer;
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.observer.closed();
    }

    public List<CloseableObserver> getObservers() {
        return Arrays.asList(this.observer);
    }
}

